/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hbase.shaded.org.apache.http.NameValuePair;
import org.apache.hadoop.hbase.shaded.org.apache.http.client.utils.URLEncodedUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.HttpExceptionUtils;

public class AuthenticationWithProxyUserFilter
extends AuthenticationFilter {
    private static final String DO_AS = "doAs";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    @Override
    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String proxyUser = AuthenticationWithProxyUserFilter.getDoAs(request);
        if (proxyUser != null) {
            UserGroupInformation realUser = UserGroupInformation.createRemoteUser(request.getRemoteUser());
            UserGroupInformation proxyUserInfo = UserGroupInformation.createProxyUser(proxyUser, realUser);
            try {
                ProxyUsers.authorize(proxyUserInfo, request.getRemoteAddr());
            }
            catch (AuthorizationException ex) {
                HttpExceptionUtils.createServletExceptionResponse(response, 403, ex);
                return;
            }
            final UserGroupInformation finalProxyUser = proxyUserInfo;
            request = new HttpServletRequestWrapper((HttpServletRequest)request){

                public String getRemoteUser() {
                    return finalProxyUser.getUserName();
                }
            };
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static String getDoAs(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        List<NameValuePair> list = URLEncodedUtils.parse(queryString, UTF8_CHARSET);
        if (list != null) {
            for (NameValuePair nv : list) {
                if (!DO_AS.equalsIgnoreCase(nv.getName())) continue;
                return nv.getValue();
            }
        }
        return null;
    }
}

