/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.internal.hpack;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.UnsupportedValueConverter;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.CharSequenceMap;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.internal.hpack.HeaderField;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.internal.hpack.HpackUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.AsciiString;

final class StaticTable {
    private static final List<HeaderField> STATIC_TABLE = Arrays.asList(StaticTable.newEmptyHeaderField(":authority"), StaticTable.newHeaderField(":method", "GET"), StaticTable.newHeaderField(":method", "POST"), StaticTable.newHeaderField(":path", "/"), StaticTable.newHeaderField(":path", "/index.html"), StaticTable.newHeaderField(":scheme", "http"), StaticTable.newHeaderField(":scheme", "https"), StaticTable.newHeaderField(":status", "200"), StaticTable.newHeaderField(":status", "204"), StaticTable.newHeaderField(":status", "206"), StaticTable.newHeaderField(":status", "304"), StaticTable.newHeaderField(":status", "400"), StaticTable.newHeaderField(":status", "404"), StaticTable.newHeaderField(":status", "500"), StaticTable.newEmptyHeaderField("accept-charset"), StaticTable.newHeaderField("accept-encoding", "gzip, deflate"), StaticTable.newEmptyHeaderField("accept-language"), StaticTable.newEmptyHeaderField("accept-ranges"), StaticTable.newEmptyHeaderField("accept"), StaticTable.newEmptyHeaderField("access-control-allow-origin"), StaticTable.newEmptyHeaderField("age"), StaticTable.newEmptyHeaderField("allow"), StaticTable.newEmptyHeaderField("authorization"), StaticTable.newEmptyHeaderField("cache-control"), StaticTable.newEmptyHeaderField("content-disposition"), StaticTable.newEmptyHeaderField("content-encoding"), StaticTable.newEmptyHeaderField("content-language"), StaticTable.newEmptyHeaderField("content-length"), StaticTable.newEmptyHeaderField("content-location"), StaticTable.newEmptyHeaderField("content-range"), StaticTable.newEmptyHeaderField("content-type"), StaticTable.newEmptyHeaderField("cookie"), StaticTable.newEmptyHeaderField("date"), StaticTable.newEmptyHeaderField("etag"), StaticTable.newEmptyHeaderField("expect"), StaticTable.newEmptyHeaderField("expires"), StaticTable.newEmptyHeaderField("from"), StaticTable.newEmptyHeaderField("host"), StaticTable.newEmptyHeaderField("if-match"), StaticTable.newEmptyHeaderField("if-modified-since"), StaticTable.newEmptyHeaderField("if-none-match"), StaticTable.newEmptyHeaderField("if-range"), StaticTable.newEmptyHeaderField("if-unmodified-since"), StaticTable.newEmptyHeaderField("last-modified"), StaticTable.newEmptyHeaderField("link"), StaticTable.newEmptyHeaderField("location"), StaticTable.newEmptyHeaderField("max-forwards"), StaticTable.newEmptyHeaderField("proxy-authenticate"), StaticTable.newEmptyHeaderField("proxy-authorization"), StaticTable.newEmptyHeaderField("range"), StaticTable.newEmptyHeaderField("referer"), StaticTable.newEmptyHeaderField("refresh"), StaticTable.newEmptyHeaderField("retry-after"), StaticTable.newEmptyHeaderField("server"), StaticTable.newEmptyHeaderField("set-cookie"), StaticTable.newEmptyHeaderField("strict-transport-security"), StaticTable.newEmptyHeaderField("transfer-encoding"), StaticTable.newEmptyHeaderField("user-agent"), StaticTable.newEmptyHeaderField("vary"), StaticTable.newEmptyHeaderField("via"), StaticTable.newEmptyHeaderField("www-authenticate"));
    private static final CharSequenceMap<Integer> STATIC_INDEX_BY_NAME = StaticTable.createMap();
    static final int length = STATIC_TABLE.size();

    private static HeaderField newEmptyHeaderField(CharSequence name) {
        return StaticTable.newHeaderField(name, AsciiString.EMPTY_STRING);
    }

    private static HeaderField newHeaderField(CharSequence name, CharSequence value) {
        return new HeaderField(AsciiString.of(name), AsciiString.of(value));
    }

    static HeaderField getEntry(int index) {
        return STATIC_TABLE.get(index - 1);
    }

    static int getIndex(CharSequence name) {
        Integer index = (Integer)STATIC_INDEX_BY_NAME.get(name);
        if (index == null) {
            return -1;
        }
        return index;
    }

    static int getIndex(CharSequence name, CharSequence value) {
        int index = StaticTable.getIndex(name);
        if (index == -1) {
            return -1;
        }
        while (index <= length) {
            HeaderField entry = StaticTable.getEntry(index);
            if (HpackUtil.equalsConstantTime(name, entry.name) == 0) break;
            if (HpackUtil.equalsConstantTime(value, entry.value) != 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static CharSequenceMap<Integer> createMap() {
        int length = STATIC_TABLE.size();
        CharSequenceMap<Integer> ret = new CharSequenceMap<Integer>(true, UnsupportedValueConverter.instance(), length);
        for (int index = length; index > 0; --index) {
            HeaderField entry = StaticTable.getEntry(index);
            CharSequence name = entry.name;
            ret.set(name, index);
        }
        return ret;
    }

    private StaticTable() {
    }
}

