/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2;

import java.util.Queue;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Connection;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2ConnectionAdapter;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Error;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hadoop.hbase.shaded.io.netty.handler.codec.http2.StreamByteDistributor;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.MathUtil;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.PriorityQueue;
import org.apache.hadoop.hbase.shaded.io.netty.util.internal.PriorityQueueNode;

public final class WeightedFairQueueByteDistributor
implements StreamByteDistributor {
    private final Http2Connection.PropertyKey stateKey;
    private final State connectionState;
    private int allocationQuantum = 1024;

    public WeightedFairQueueByteDistributor(Http2Connection connection) {
        this.stateKey = connection.newKey();
        Http2Stream connectionStream = connection.connectionStream();
        this.connectionState = new State(connectionStream, 16);
        connectionStream.setProperty(this.stateKey, this.connectionState);
        connection.addListener(new Http2ConnectionAdapter(){

            @Override
            public void onStreamAdded(Http2Stream stream) {
                stream.setProperty(WeightedFairQueueByteDistributor.this.stateKey, new State(stream));
            }

            @Override
            public void onWeightChanged(Http2Stream stream, short oldWeight) {
                Http2Stream parent;
                if (((WeightedFairQueueByteDistributor)WeightedFairQueueByteDistributor.this).state((Http2Stream)stream).activeCountForTree != 0 && (parent = stream.parent()) != null) {
                    ((WeightedFairQueueByteDistributor)WeightedFairQueueByteDistributor.this).state((Http2Stream)parent).totalQueuedWeights += (long)(stream.weight() - oldWeight);
                }
            }

            @Override
            public void onStreamClosed(Http2Stream stream) {
                WeightedFairQueueByteDistributor.this.state(stream).close();
            }

            @Override
            public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
                Http2Stream parent = stream.parent();
                if (parent != null) {
                    State state = WeightedFairQueueByteDistributor.this.state(stream);
                    if (state.activeCountForTree != 0) {
                        State pState = WeightedFairQueueByteDistributor.this.state(parent);
                        pState.offerAndInitializePseudoTime(state);
                        pState.activeCountChangeForTree(state.activeCountForTree);
                    }
                }
            }

            @Override
            public void onPriorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
                Http2Stream parent = stream.parent();
                if (parent != null) {
                    State state = WeightedFairQueueByteDistributor.this.state(stream);
                    if (state.activeCountForTree != 0) {
                        State pState = WeightedFairQueueByteDistributor.this.state(parent);
                        pState.remove(state);
                        pState.activeCountChangeForTree(-state.activeCountForTree);
                    }
                }
            }
        });
    }

    @Override
    public void updateStreamableBytes(StreamByteDistributor.StreamState state) {
        this.state(state.stream()).updateStreamableBytes(Http2CodecUtil.streamableBytes(state), state.hasFrame() && state.windowSize() >= 0);
    }

    @Override
    public boolean distribute(int maxBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
        int oldIsActiveCountForTree;
        if (this.connectionState.activeCountForTree == 0) {
            return false;
        }
        do {
            oldIsActiveCountForTree = this.connectionState.activeCountForTree;
            maxBytes -= this.distributeToChildren(maxBytes, writer, this.connectionState);
        } while (this.connectionState.activeCountForTree != 0 && (maxBytes > 0 || oldIsActiveCountForTree != this.connectionState.activeCountForTree));
        return this.connectionState.activeCountForTree != 0;
    }

    public void allocationQuantum(int allocationQuantum) {
        if (allocationQuantum <= 0) {
            throw new IllegalArgumentException("allocationQuantum must be > 0");
        }
        this.allocationQuantum = allocationQuantum;
    }

    private int distribute(int maxBytes, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        if (state.isActive()) {
            int nsent = Math.min(maxBytes, state.streamableBytes);
            state.write(nsent, writer);
            if (nsent == 0 && maxBytes != 0) {
                state.updateStreamableBytes(state.streamableBytes, false);
            }
            return nsent;
        }
        return this.distributeToChildren(maxBytes, writer, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int distributeToChildren(int maxBytes, StreamByteDistributor.Writer writer, State state) throws Http2Exception {
        long oldTotalQueuedWeights = state.totalQueuedWeights;
        State childState = state.poll();
        State nextChildState = state.peek();
        childState.setDistributing();
        try {
            assert (nextChildState == null || nextChildState.pseudoTimeToWrite >= childState.pseudoTimeToWrite) : "nextChildState[" + nextChildState.stream.id() + "].pseudoTime(" + nextChildState.pseudoTimeToWrite + ") < " + " childState[" + childState.stream.id() + "].pseudoTime(" + childState.pseudoTimeToWrite + ")";
            int nsent = this.distribute(nextChildState == null ? maxBytes : Math.min(maxBytes, (int)Math.min((nextChildState.pseudoTimeToWrite - childState.pseudoTimeToWrite) * (long)childState.stream.weight() / oldTotalQueuedWeights + (long)this.allocationQuantum, Integer.MAX_VALUE)), writer, childState);
            state.pseudoTime += (long)nsent;
            childState.updatePseudoTime(state, nsent, oldTotalQueuedWeights);
            int n = nsent;
            return n;
        }
        finally {
            childState.unsetDistributing();
            if (childState.activeCountForTree != 0) {
                state.offer(childState);
            }
        }
    }

    private State state(Http2Stream stream) {
        return (State)stream.getProperty(this.stateKey);
    }

    int streamableBytes0(Http2Stream stream) {
        return this.state((Http2Stream)stream).streamableBytes;
    }

    private final class State
    implements PriorityQueueNode<State> {
        private static final int STATE_IS_ACTIVE = 1;
        private static final int STATE_IS_DISTRIBUTING = 2;
        final Http2Stream stream;
        private final Queue<State> queue;
        int streamableBytes;
        int activeCountForTree;
        private int priorityQueueIndex = -1;
        long pseudoTimeToWrite;
        long pseudoTime;
        long totalQueuedWeights;
        private byte flags;

        State(Http2Stream stream) {
            this(stream, 0);
        }

        State(Http2Stream stream, int initialSize) {
            this.stream = stream;
            this.queue = new PriorityQueue<State>(initialSize);
        }

        void write(int numBytes, StreamByteDistributor.Writer writer) throws Http2Exception {
            try {
                writer.write(this.stream, numBytes);
            }
            catch (Throwable t) {
                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, t, "byte distribution write error", new Object[0]);
            }
        }

        void activeCountChangeForTree(int increment) {
            assert (this.activeCountForTree + increment >= 0);
            this.activeCountForTree += increment;
            if (!this.stream.isRoot()) {
                State pState = WeightedFairQueueByteDistributor.this.state(this.stream.parent());
                assert (this.activeCountForTree != increment || this.priorityQueueIndex == -1 || pState.queue.contains(this)) : "State[" + this.stream.id() + "].activeCountForTree changed from 0 to " + increment + " is in a queue" + ", but not in parent[ " + pState.stream.id() + "]'s queue";
                if (this.activeCountForTree == 0) {
                    pState.remove(this);
                } else if (this.activeCountForTree == increment && !this.isDistributing()) {
                    pState.offerAndInitializePseudoTime(this);
                }
                pState.activeCountChangeForTree(increment);
            }
        }

        void updateStreamableBytes(int newStreamableBytes, boolean isActive) {
            if (this.isActive() != isActive) {
                if (isActive) {
                    this.activeCountChangeForTree(1);
                    this.setActive();
                } else {
                    this.activeCountChangeForTree(-1);
                    this.unsetActive();
                }
            }
            this.streamableBytes = newStreamableBytes;
        }

        void updatePseudoTime(State parentState, int nsent, long totalQueuedWeights) {
            assert (this.stream.id() != 0 && nsent >= 0);
            this.pseudoTimeToWrite = Math.min(this.pseudoTimeToWrite, parentState.pseudoTime) + (long)nsent * totalQueuedWeights / (long)this.stream.weight();
        }

        void offerAndInitializePseudoTime(State state) {
            state.pseudoTimeToWrite = this.pseudoTime;
            this.offer(state);
        }

        void offer(State state) {
            this.queue.offer(state);
            this.totalQueuedWeights += (long)state.stream.weight();
        }

        State poll() {
            State state = this.queue.poll();
            this.totalQueuedWeights -= (long)state.stream.weight();
            return state;
        }

        void remove(State state) {
            if (this.queue.remove(state)) {
                this.totalQueuedWeights -= (long)state.stream.weight();
            }
        }

        State peek() {
            return this.queue.peek();
        }

        void close() {
            this.updateStreamableBytes(0, false);
        }

        boolean isActive() {
            return (this.flags & 1) != 0;
        }

        private void setActive() {
            this.flags = (byte)(this.flags | 1);
        }

        private void unsetActive() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }

        boolean isDistributing() {
            return (this.flags & 2) != 0;
        }

        void setDistributing() {
            this.flags = (byte)(this.flags | 2);
        }

        void unsetDistributing() {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
        }

        @Override
        public int compareTo(State o) {
            return MathUtil.compare(this.pseudoTimeToWrite, o.pseudoTimeToWrite);
        }

        @Override
        public int priorityQueueIndex() {
            return this.priorityQueueIndex;
        }

        @Override
        public void priorityQueueIndex(int i) {
            this.priorityQueueIndex = i;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(256 * (this.activeCountForTree > 0 ? this.activeCountForTree : 1));
            this.toString(sb);
            return sb.toString();
        }

        private void toString(StringBuilder sb) {
            sb.append("{stream ").append(this.stream.id()).append(" streamableBytes ").append(this.streamableBytes).append(" activeCountForTree ").append(this.activeCountForTree).append(" priorityQueueIndex ").append(this.priorityQueueIndex).append(" pseudoTimeToWrite ").append(this.pseudoTimeToWrite).append(" pseudoTime ").append(this.pseudoTime).append(" flags ").append(this.flags).append(" queue.size() ").append(this.queue.size()).append("} [");
            if (!this.queue.isEmpty()) {
                for (State s : this.queue) {
                    s.toString(sb);
                    sb.append(", ");
                }
                sb.setLength(sb.length() - 2);
            }
            sb.append(']');
        }
    }
}

