/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import com.google.auto.value.AutoValue;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.fn.data.AutoValue_RemoteGrpcPortRead;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

@AutoValue
public abstract class RemoteGrpcPortRead {
    public static final String URN = "beam:runner:source:v1";
    private static final String LOCAL_OUTPUT_ID = "local_output";

    public static RemoteGrpcPortRead readFromPort(BeamFnApi.RemoteGrpcPort port, String outputPCollectionId) {
        return new AutoValue_RemoteGrpcPortRead(port, outputPCollectionId);
    }

    public static RemoteGrpcPortRead fromPTransform(RunnerApi.PTransform pTransform) throws InvalidProtocolBufferException {
        Preconditions.checkArgument((boolean)URN.equals(pTransform.getSpec().getUrn()), (String)"Expected URN for %s, got %s", (Object)RemoteGrpcPortRead.class.getSimpleName(), (Object)pTransform.getSpec().getUrn());
        Preconditions.checkArgument((pTransform.getOutputsCount() == 1 ? 1 : 0) != 0, (String)"Expected exactly one output, got %s", (int)pTransform.getOutputsCount());
        BeamFnApi.RemoteGrpcPort port = BeamFnApi.RemoteGrpcPort.parseFrom((ByteString)pTransform.getSpec().getPayload());
        String outputPcollection = (String)Iterables.getOnlyElement(pTransform.getOutputsMap().values());
        return RemoteGrpcPortRead.readFromPort(port, outputPcollection);
    }

    public RunnerApi.PTransform toPTransform() {
        return RunnerApi.PTransform.newBuilder().setSpec(RunnerApi.FunctionSpec.newBuilder().setUrn(URN).setPayload(this.getPort().toByteString()).build()).putOutputs(LOCAL_OUTPUT_ID, this.getOutputPCollectionId()).build();
    }

    public abstract BeamFnApi.RemoteGrpcPort getPort();

    abstract String getOutputPCollectionId();
}

