/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.data;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.sdk.fn.data.LogicalEndpoint;
import org.apache.beam.sdk.fn.stream.OutboundObserverFactory;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.stub.StreamObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamFnDataGrpcMultiplexer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BeamFnDataGrpcMultiplexer.class);
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Endpoints.ApiServiceDescriptor apiServiceDescriptor;
    private final StreamObserver<BeamFnApi.Elements> inboundObserver;
    private final StreamObserver<BeamFnApi.Elements> outboundObserver;
    private final ConcurrentMap<LogicalEndpoint, CompletableFuture<BiConsumer<ByteString, Boolean>>> consumers;

    public BeamFnDataGrpcMultiplexer(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Endpoints.ApiServiceDescriptor apiServiceDescriptor, OutboundObserverFactory outboundObserverFactory, OutboundObserverFactory.BasicFactory<BeamFnApi.Elements, BeamFnApi.Elements> baseOutboundObserverFactory) {
        this.apiServiceDescriptor = apiServiceDescriptor;
        this.consumers = new ConcurrentHashMap<LogicalEndpoint, CompletableFuture<BiConsumer<ByteString, Boolean>>>();
        this.inboundObserver = new InboundObserver();
        this.outboundObserver = outboundObserverFactory.outboundObserverFor(baseOutboundObserverFactory, this.inboundObserver);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("apiServiceDescriptor", (Object)this.apiServiceDescriptor).add("consumers", this.consumers).toString();
    }

    public StreamObserver<BeamFnApi.Elements> getInboundObserver() {
        return this.inboundObserver;
    }

    public StreamObserver<BeamFnApi.Elements> getOutboundObserver() {
        return this.outboundObserver;
    }

    private CompletableFuture<BiConsumer<ByteString, Boolean>> receiverFuture(LogicalEndpoint endpoint) {
        return this.consumers.computeIfAbsent(endpoint, unused -> new CompletableFuture());
    }

    public <T> void registerConsumer(LogicalEndpoint inputLocation, BiConsumer<ByteString, Boolean> bytesReceiver) {
        this.receiverFuture(inputLocation).complete(bytesReceiver);
    }

    @VisibleForTesting
    boolean hasConsumer(LogicalEndpoint outputLocation) {
        return this.consumers.containsKey(outputLocation);
    }

    @Override
    public void close() {
        for (CompletableFuture receiver : ImmutableList.copyOf(this.consumers.values())) {
            receiver.cancel(true);
        }
        this.outboundObserver.onError((Throwable)Status.CANCELLED.withDescription("Multiplexer hanging up").asException());
        this.inboundObserver.onCompleted();
    }

    private final class InboundObserver
    implements StreamObserver<BeamFnApi.Elements> {
        private InboundObserver() {
        }

        public void onNext(BeamFnApi.Elements value) {
            CompletableFuture consumer;
            LogicalEndpoint key;
            for (BeamFnApi.Elements.Data data : value.getDataList()) {
                try {
                    key = LogicalEndpoint.data(data.getInstructionId(), data.getTransformId());
                    consumer = BeamFnDataGrpcMultiplexer.this.receiverFuture(key);
                    if (!consumer.isDone()) {
                        LOG.debug("Received data for key {} without consumer ready. Waiting for consumer to be registered.", (Object)key);
                    }
                    ((BiConsumer)consumer.get()).accept(data.getData(), data.getIsLast());
                    if (!data.getIsLast()) continue;
                    BeamFnDataGrpcMultiplexer.this.consumers.remove(key);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Client interrupted during handling of data for instruction {} and transform {}", new Object[]{data.getInstructionId(), data.getTransformId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.error("Client failed to handle data for instruction {} and transform {}", new Object[]{data.getInstructionId(), data.getTransformId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
            }
            for (BeamFnApi.Elements.Timers timer : value.getTimersList()) {
                try {
                    key = LogicalEndpoint.timer(timer.getInstructionId(), timer.getTransformId(), timer.getTimerFamilyId());
                    consumer = BeamFnDataGrpcMultiplexer.this.receiverFuture(key);
                    if (!consumer.isDone()) {
                        LOG.debug("Received data for key {} without consumer ready. Waiting for consumer to be registered.", (Object)key);
                    }
                    ((BiConsumer)consumer.get()).accept(timer.getTimers(), timer.getIsLast());
                    if (!timer.getIsLast()) continue;
                    BeamFnDataGrpcMultiplexer.this.consumers.remove(key);
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Client interrupted during handling of timer for instruction {}, transform {}, and timer family {}", new Object[]{timer.getInstructionId(), timer.getTransformId(), timer.getTimerFamilyId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
                catch (RuntimeException e) {
                    LOG.error("Client failed to handle timer for instruction {}, transform {}, and timer family {}", new Object[]{timer.getInstructionId(), timer.getTransformId(), timer.getTimerFamilyId(), e});
                    BeamFnDataGrpcMultiplexer.this.outboundObserver.onError((Throwable)e);
                }
            }
        }

        public void onError(Throwable t) {
            LOG.error("Failed to handle for {}", (Object)(BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor), (Object)t);
        }

        public void onCompleted() {
            LOG.warn("Hanged up for {}.", (Object)(BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor == null ? "unknown endpoint" : BeamFnDataGrpcMultiplexer.this.apiServiceDescriptor));
        }
    }
}

