/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.BaseFileOutputMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutput;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputData;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputField;
import org.w3c.dom.Node;

@Transform(id="JsonOutput", image="JSO.svg", name="i18n::JsonOutput.name", description="i18n::JsonOutput.description", categoryDescription="i18n::JsonOutput.category", keywords={"json", "javascript", "object", "notation"}, documentationUrl="/pipeline/transforms/jsonoutput.html")
public class JsonOutputMeta
extends BaseFileOutputMeta
implements ITransformMeta<JsonOutput, JsonOutputData> {
    private static final Class<?> PKG = JsonOutputMeta.class;
    private int operationType;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.OutputValue", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.WriteToFile", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.Both", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"outputvalue", "writetofile", "both"};
    public static final int OPERATION_TYPE_OUTPUT_VALUE = 0;
    public static final int OPERATION_TYPE_WRITE_TO_FILE = 1;
    public static final int OPERATION_TYPE_BOTH = 2;
    private String encoding;
    private String outputValue;
    private String jsonBloc;
    private String nrRowsInBloc;
    private JsonOutputField[] outputFields;
    private boolean AddToResult;
    private boolean fileAppended;
    private boolean compatibilityMode;
    private boolean createparentfolder;
    private boolean DoNotOpenNewFileInit;

    public boolean isDoNotOpenNewFileInit() {
        return this.DoNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean DoNotOpenNewFileInit) {
        this.DoNotOpenNewFileInit = DoNotOpenNewFileInit;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public boolean AddToResult() {
        return this.AddToResult;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JsonOutputMeta.getOperationTypeByCode(tt);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public JsonOutputField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(JsonOutputField[] outputFields) {
        this.outputFields = outputFields;
    }

    public void loadXml(Node transformnode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformnode);
    }

    public void allocate(int nrFields) {
        this.outputFields = new JsonOutputField[nrFields];
    }

    public Object clone() {
        JsonOutputMeta retval = (JsonOutputMeta)((Object)super.clone());
        int nrFields = this.outputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            retval.outputFields[i] = (JsonOutputField)this.outputFields[i].clone();
        }
        return retval;
    }

    public void setAddToResult(boolean AddToResult) {
        this.AddToResult = AddToResult;
    }

    private void readData(Node transformnode) throws HopXmlException {
        try {
            this.outputValue = XmlHandler.getTagValue((Node)transformnode, (String)"outputValue");
            this.jsonBloc = XmlHandler.getTagValue((Node)transformnode, (String)"jsonBloc");
            this.nrRowsInBloc = XmlHandler.getTagValue((Node)transformnode, (String)"nrRowsInBloc");
            this.operationType = JsonOutputMeta.getOperationTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformnode, (String)"operation_type"), (String)""));
            this.compatibilityMode = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"compatibility_mode"));
            this.encoding = XmlHandler.getTagValue((Node)transformnode, (String)"encoding");
            this.AddToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"AddToResult"));
            this.fileName = XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"create_parent_folder"));
            this.extension = XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"extention");
            this.fileAppended = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"append"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"add_time"));
            this.DoNotOpenNewFileInit = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformnode, (String)"file", (String)"DoNotOpenNewFileInit"));
            Node fields = XmlHandler.getSubNode((Node)transformnode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new JsonOutputField();
                this.outputFields[i].setFieldName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setElementName(XmlHandler.getTagValue((Node)fnode, (String)"element"));
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from Xml", (Throwable)e);
        }
    }

    public void setDefault() {
        this.encoding = "UTF-8";
        this.outputValue = "outputValue";
        this.jsonBloc = "data";
        this.nrRowsInBloc = "1";
        this.operationType = 1;
        this.extension = "js";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.outputFields[i] = new JsonOutputField();
            this.outputFields[i].setFieldName("field" + i);
            this.outputFields[i].setElementName("field" + i);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.getOperationType() != 1) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getOutputValue()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    public String getXml() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"outputValue", (String)this.outputValue));
        retval.append("    ").append(XmlHandler.addTagValue((String)"jsonBloc", (String)this.jsonBloc));
        retval.append("    ").append(XmlHandler.addTagValue((String)"nrRowsInBloc", (String)this.nrRowsInBloc));
        retval.append("    ").append(XmlHandler.addTagValue((String)"operation_type", (String)JsonOutputMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"compatibility_mode", (boolean)this.compatibilityMode));
        retval.append("    ").append(XmlHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XmlHandler.addTagValue((String)"addtoresult", (boolean)this.AddToResult));
        retval.append("    <file>" + Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XmlHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append("      ").append(XmlHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("      ").append(XmlHandler.addTagValue((String)"DoNotOpenNewFileInit", (boolean)this.DoNotOpenNewFileInit));
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            JsonOutputField field = this.outputFields[i];
            if (field.getFieldName() == null || field.getFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"element", (String)field.getElementName()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (this.getOperationType() != 1 && Utils.isEmpty((CharSequence)variables.resolve(this.getOutputValue()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)variables.resolve(this.getFileName()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingTargetFilename", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getFieldName());
                if (idx >= 0) continue;
                errorMessage = errorMessage + "\t\t" + this.outputFields[i].getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public JsonOutput createTransform(TransformMeta transformMeta, JsonOutputData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new JsonOutput(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public JsonOutputData getTransformData() {
        return new JsonOutputData();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getJsonBloc() {
        return this.jsonBloc;
    }

    public void setJsonBloc(String jsonBloc) {
        this.jsonBloc = jsonBloc;
    }

    public String getNrRowsInBloc() {
        return this.nrRowsInBloc;
    }

    public void setNrRowsInBloc(String nrRowsInBloc) {
        this.nrRowsInBloc = nrRowsInBloc;
    }

    @Override
    public int getSplitEvery() {
        try {
            return Integer.parseInt(this.getNrRowsInBloc());
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public void setSplitEvery(int splitEvery) {
        this.setNrRowsInBloc(splitEvery + "");
    }

    public String getOutputValue() {
        return this.outputValue;
    }

    public void setOutputValue(String outputValue) {
        this.outputValue = outputValue;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    public boolean writesToFile() {
        return this.getOperationType() == 1 || this.getOperationType() == 2;
    }
}

