/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsoninput.reader;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.SingleRowRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInputField;
import org.apache.hop.pipeline.transforms.jsoninput.JsonInputMeta;
import org.apache.hop.pipeline.transforms.jsoninput.exception.JsonInputException;
import org.apache.hop.pipeline.transforms.jsoninput.reader.IJsonReader;

public class FastJsonReader
implements IJsonReader {
    private static final Class<?> PKG = JsonInputMeta.class;
    private static final String JSON_CHARSET = "UTF-8";
    private ReadContext jsonReadContext;
    private Configuration jsonConfiguration = Configuration.defaultConfiguration().addOptions(DEFAULT_OPTIONS);
    private boolean ignoreMissingPath = false;
    private boolean defaultPathLeafToNull = true;
    private JsonInputField[] fields;
    private JsonPath[] paths = null;
    private ILogChannel log;
    private static final Option[] DEFAULT_OPTIONS = new Option[]{Option.SUPPRESS_EXCEPTIONS, Option.ALWAYS_RETURN_LIST, Option.DEFAULT_PATH_LEAF_TO_NULL};

    protected FastJsonReader(ILogChannel log) throws HopException {
        this.log = log;
    }

    public FastJsonReader(JsonInputField[] fields, ILogChannel log) throws HopException {
        this(log);
        this.setFields(fields);
    }

    public FastJsonReader(JsonInputField[] fields, boolean defaultPathLeafToNull, ILogChannel log) throws HopException {
        this(fields, log);
        this.setDefaultPathLeafToNull(defaultPathLeafToNull);
    }

    private void setDefaultPathLeafToNull(boolean value) {
        if (value != this.defaultPathLeafToNull) {
            this.defaultPathLeafToNull = value;
            if (!this.defaultPathLeafToNull) {
                this.jsonConfiguration = this.deleteOptionFromConfiguration(this.jsonConfiguration, Option.DEFAULT_PATH_LEAF_TO_NULL);
            }
        }
    }

    public boolean isDefaultPathLeafToNull() {
        return this.defaultPathLeafToNull;
    }

    private Configuration deleteOptionFromConfiguration(Configuration config, Option option) {
        Configuration currentConf = config;
        if (currentConf != null) {
            EnumSet<Option> currentOptions = EnumSet.noneOf(Option.class);
            currentOptions.addAll(currentConf.getOptions());
            if (currentOptions.remove(option)) {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"JsonReader.Debug.Configuration.Option.Delete", (Object[])new Object[]{option}));
                }
                currentConf = Configuration.defaultConfiguration().addOptions(currentOptions.toArray(new Option[currentOptions.size()]));
            }
        }
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"JsonReader.Debug.Configuration.Options", (Object[])new Object[]{currentConf.getOptions()}));
        }
        return currentConf;
    }

    Configuration getJsonConfiguration() {
        return this.jsonConfiguration;
    }

    @Override
    public void setIgnoreMissingPath(boolean value) {
        this.ignoreMissingPath = value;
    }

    private ParseContext getParseContext() {
        return JsonPath.using((Configuration)this.jsonConfiguration);
    }

    private ReadContext getReadContext() {
        return this.jsonReadContext;
    }

    private static JsonPath[] compilePaths(JsonInputField[] fields) {
        JsonPath[] paths = new JsonPath[fields.length];
        int i = 0;
        for (JsonInputField field : fields) {
            paths[i++] = JsonPath.compile((String)field.getPath(), (Predicate[])new Predicate[0]);
        }
        return paths;
    }

    protected void readInput(InputStream is) throws HopException {
        this.jsonReadContext = this.getParseContext().parse(is, JSON_CHARSET);
        if (this.jsonReadContext == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
        }
    }

    @Override
    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }

    @Override
    public void setFields(JsonInputField[] fields) throws HopException {
        this.fields = fields;
        this.paths = FastJsonReader.compilePaths(fields);
    }

    @Override
    public IRowSet parse(InputStream in) throws HopException {
        int len;
        this.readInput(in);
        List<List<?>> results = this.evalCombinedResult();
        int n = len = results.isEmpty() ? 0 : results.get(0).size();
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JsonInput.Log.NrRecords", (Object[])new Object[]{len}));
        }
        if (len == 0) {
            return this.getEmptyResponse();
        }
        return new TransposedRowSet(results);
    }

    private IRowSet getEmptyResponse() {
        SingleRowRowSet nullInputResponse = new SingleRowRowSet();
        nullInputResponse.putRow(null, new Object[this.fields.length]);
        nullInputResponse.setDone();
        return nullInputResponse;
    }

    private List<List<?>> evalCombinedResult() throws JsonInputException {
        int lastSize = -1;
        String prevPath = null;
        ArrayList results = new ArrayList(this.paths.length);
        int i = 0;
        for (JsonPath path : this.paths) {
            List result = (List)this.getReadContext().read(path);
            if (result.size() != lastSize && lastSize > 0 & result.size() != 0) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonInput.Error.BadStructure", (Object[])new Object[]{result.size(), this.fields[i].getPath(), prevPath, lastSize}));
            }
            if (!this.isIgnoreMissingPath() && (FastJsonReader.isAllNull(result) || result.size() == 0)) {
                throw new JsonInputException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{this.fields[i].getPath()}));
            }
            results.add(result);
            lastSize = result.size();
            prevPath = this.fields[i].getPath();
            ++i;
        }
        return results;
    }

    public static boolean isAllNull(Iterable<?> list) {
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    private static class TransposedRowSet
    extends SingleRowRowSet {
        private List<List<?>> results;
        private final int rowCount;
        private int rowNbr;
        private boolean cullNulls = true;

        public TransposedRowSet(List<List<?>> results) {
            this.results = results;
            this.rowCount = results.isEmpty() ? 0 : results.get(0).size();
        }

        public Object[] getRow() {
            boolean allNulls = this.cullNulls && this.rowCount > 1;
            Object[] rowData = null;
            do {
                if (this.rowNbr >= this.rowCount) {
                    this.results.clear();
                    return null;
                }
                rowData = new Object[this.results.size()];
                for (int col = 0; col < this.results.size(); ++col) {
                    if (this.results.get(col).size() == 0) {
                        rowData[col] = null;
                        continue;
                    }
                    Object val = this.results.get(col).get(this.rowNbr);
                    rowData[col] = val;
                    allNulls &= val == null;
                }
                ++this.rowNbr;
            } while (allNulls);
            return rowData;
        }

        public int size() {
            return this.rowCount - this.rowNbr;
        }

        public boolean isDone() {
            return true;
        }

        public void clear() {
            this.results.clear();
        }
    }
}

