/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stringoperations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stringoperations.StringOperationsMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StringOperationsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = StringOperationsMeta.class;
    private TableView wFields;
    private final StringOperationsMeta input;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] ciKey;

    public StringOperationsDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (StringOperationsMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrFieldCols = 11;
        int nrFieldRows = this.input.getFieldInStream() != null ? this.input.getFieldInStream().length : 1;
        this.ciKey = new ColumnInfo[nrFieldCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.InStreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.OutStreamField", (String[])new String[0]), 1, false);
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.Trim", (String[])new String[0]), 2, StringOperationsMeta.trimTypeDesc, true);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.LowerUpper", (String[])new String[0]), 2, StringOperationsMeta.lowerUpperDesc, true);
        this.ciKey[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.Padding", (String[])new String[0]), 2, StringOperationsMeta.paddingDesc, true);
        this.ciKey[5] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.CharPad", (String[])new String[0]), 1, false);
        this.ciKey[6] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.LenPad", (String[])new String[0]), 1, false);
        this.ciKey[7] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.InitCap", (String[])new String[0]), 2, StringOperationsMeta.initCapDesc);
        this.ciKey[8] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.MaskXML", (String[])new String[0]), 2, StringOperationsMeta.maskXMLDesc);
        this.ciKey[9] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.Digits", (String[])new String[0]), 2, StringOperationsMeta.digitsDesc);
        this.ciKey[10] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.RemoveSpecialCharacters", (String[])new String[0]), 2, StringOperationsMeta.removeSpecialCharactersDesc);
        this.ciKey[1].setToolTip(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.OutStreamField.Tooltip", (String[])new String[0]));
        this.ciKey[1].setUsingVariables(true);
        this.ciKey[4].setUsingVariables(true);
        this.ciKey[5].setUsingVariables(true);
        this.ciKey[6].setUsingVariables(true);
        this.ciKey[7].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrFieldRows, lsMod, this.props);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, -margin);
        fdKey.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdKey);
        this.getData();
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    if (row != null) {
                        for (int i = 0; i < row.size(); ++i) {
                            this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        this.setComboBoxes();
                    }
                    display.asyncExec(() -> {
                        if (!this.wFields.isDisposed()) {
                            for (int i = 0; i < this.wFields.table.getItemCount(); ++i) {
                                TableItem it = this.wFields.table.getItem(i);
                                if (Utils.isEmpty((CharSequence)it.getText(1)) || this.inputFields.containsKey(it.getText(1))) continue;
                                it.setBackground(GuiResource.getInstance().getColorRed());
                            }
                        }
                    });
                }
                catch (HopException e) {
                    this.logError("Error getting fields from incoming stream!", e);
                }
            }
        };
        new Thread(runnable).start();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        Set<String> keySet = this.inputFields.keySet();
        ArrayList<String> entries = new ArrayList<String>(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getFieldInStream() != null) {
            for (int i = 0; i < this.input.getFieldInStream().length; ++i) {
                TableItem item = this.wFields.table.getItem(i);
                if (this.input.getFieldInStream()[i] != null) {
                    item.setText(1, this.input.getFieldInStream()[i]);
                }
                if (this.input.getFieldOutStream()[i] != null) {
                    item.setText(2, this.input.getFieldOutStream()[i]);
                }
                item.setText(3, StringOperationsMeta.getTrimTypeDesc(this.input.getTrimType()[i]));
                item.setText(4, StringOperationsMeta.getLowerUpperDesc(this.input.getLowerUpper()[i]));
                item.setText(5, StringOperationsMeta.getPaddingDesc(this.input.getPaddingType()[i]));
                if (this.input.getPadChar()[i] != null) {
                    item.setText(6, this.input.getPadChar()[i]);
                }
                if (this.input.getPadLen()[i] != null) {
                    item.setText(7, this.input.getPadLen()[i]);
                }
                item.setText(8, StringOperationsMeta.getInitCapDesc(this.input.getInitCap()[i]));
                item.setText(9, StringOperationsMeta.getMaskXMLDesc(this.input.getMaskXML()[i]));
                item.setText(10, StringOperationsMeta.getDigitsDesc(this.input.getDigits()[i]));
                item.setText(11, StringOperationsMeta.getRemoveSpecialCharactersDesc(this.input.getRemoveSpecialCharacters()[i]));
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(StringOperationsMeta inf) {
        int nrkeys = this.wFields.nrNonEmpty();
        inf.allocate(nrkeys);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Log.FoundFields", (String[])new String[]{String.valueOf(nrkeys)}));
        }
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            inf.getFieldInStream()[i] = item.getText(1);
            inf.getFieldOutStream()[i] = item.getText(2);
            inf.getTrimType()[i] = StringOperationsMeta.getTrimTypeByDesc(item.getText(3));
            inf.getLowerUpper()[i] = StringOperationsMeta.getLowerUpperByDesc(item.getText(4));
            inf.getPaddingType()[i] = StringOperationsMeta.getPaddingByDesc(item.getText(5));
            inf.getPadChar()[i] = item.getText(6);
            inf.getPadLen()[i] = item.getText(7);
            inf.getInitCap()[i] = StringOperationsMeta.getInitCapByDesc(item.getText(8));
            inf.getMaskXML()[i] = StringOperationsMeta.getMaskXMLByDesc(item.getText(9));
            inf.getDigits()[i] = StringOperationsMeta.getDigitsByDesc(item.getText(10));
            inf.getRemoveSpecialCharacters()[i] = StringOperationsMeta.getRemoveSpecialCharactersByDesc(item.getText(11));
        }
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    if (v.getType() == 2) {
                        tableItem.setText(3, BaseMessages.getString(PKG, (String)"StringOperationsMeta.TrimType.None", (String[])new String[0]));
                        tableItem.setText(4, BaseMessages.getString(PKG, (String)"StringOperationsMeta.LowerUpper.None", (String[])new String[0]));
                        tableItem.setText(5, BaseMessages.getString(PKG, (String)"StringOperationsMeta.Padding.None", (String[])new String[0]));
                        tableItem.setText(8, BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                        tableItem.setText(9, BaseMessages.getString(PKG, (String)"StringOperationsMeta.MaskXML.None", (String[])new String[0]));
                        tableItem.setText(10, BaseMessages.getString(PKG, (String)"StringOperationsMeta.Digits.None", (String[])new String[0]));
                        tableItem.setText(11, BaseMessages.getString(PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.None", (String[])new String[0]));
                        return true;
                    }
                    return false;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StringOperationsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

