/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stringoperations;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stringoperations.StringOperationsData;
import org.apache.hop.pipeline.transforms.stringoperations.StringOperationsMeta;

public class StringOperations
extends BaseTransform<StringOperationsMeta, StringOperationsData>
implements ITransform<StringOperationsMeta, StringOperationsData> {
    private static final Class<?> PKG = StringOperationsMeta.class;

    public StringOperations(TransformMeta transformMeta, StringOperationsMeta meta, StringOperationsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private String processString(String string, int trimType, int lowerUpper, int padType, String padChar, int padLen, int iniCap, int maskHTML, int digits, int removeSpecialCharacters) {
        String rcode = string;
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (trimType) {
                case 2: {
                    rcode = Const.rtrim((String)rcode);
                    break;
                }
                case 1: {
                    rcode = Const.ltrim((String)rcode);
                    break;
                }
                case 3: {
                    rcode = Const.trim((String)rcode);
                    break;
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (lowerUpper) {
                case 1: {
                    rcode = rcode.toLowerCase();
                    break;
                }
                case 2: {
                    rcode = rcode.toUpperCase();
                    break;
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (padType) {
                case 1: {
                    rcode = Const.Lpad((String)rcode, (String)padChar, (int)padLen);
                    break;
                }
                case 2: {
                    rcode = Const.Rpad((String)rcode, (String)padChar, (int)padLen);
                    break;
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (iniCap) {
                case 0: {
                    break;
                }
                case 1: {
                    rcode = ValueDataUtil.initCap(null, (Object)rcode);
                    break;
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (maskHTML) {
                case 1: {
                    rcode = Const.escapeXml((String)rcode);
                    break;
                }
                case 2: {
                    rcode = Const.protectXmlCdata((String)rcode);
                    break;
                }
                case 3: {
                    rcode = Const.unEscapeXml((String)rcode);
                    break;
                }
                case 5: {
                    rcode = Const.escapeHtml((String)rcode);
                    break;
                }
                case 6: {
                    rcode = Const.unEscapeHtml((String)rcode);
                    break;
                }
                case 4: {
                    rcode = Const.escapeSql((String)rcode);
                    break;
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (digits) {
                case 0: {
                    break;
                }
                case 1: {
                    rcode = Const.getDigitsOnly((String)rcode);
                    break;
                }
                case 2: {
                    rcode = Const.removeDigits((String)rcode);
                    break;
                }
            }
        }
        if (!Utils.isEmpty((CharSequence)rcode)) {
            switch (removeSpecialCharacters) {
                case 0: {
                    break;
                }
                case 1: {
                    rcode = Const.removeCR((String)rcode);
                    break;
                }
                case 2: {
                    rcode = Const.removeLF((String)rcode);
                    break;
                }
                case 3: {
                    rcode = Const.removeCRLF((String)rcode);
                    break;
                }
                case 4: {
                    rcode = Const.removeTAB((String)rcode);
                    break;
                }
                case 5: {
                    rcode = rcode.replace(" ", "");
                    break;
                }
            }
        }
        return rcode;
    }

    private Object[] processRow(IRowMeta rowMeta, Object[] row) throws HopException {
        Object[] RowData = new Object[((StringOperationsData)this.data).outputRowMeta.size()];
        System.arraycopy(row, 0, RowData, 0, rowMeta.size());
        int j = 0;
        for (int i = 0; i < ((StringOperationsData)this.data).nrFieldsInStream; ++i) {
            if (((StringOperationsData)this.data).inStreamNrs[i] < 0) continue;
            String value = this.getInputRowMeta().getString(row, ((StringOperationsData)this.data).inStreamNrs[i]);
            value = this.processString(value, ((StringOperationsData)this.data).trimOperators[i], ((StringOperationsData)this.data).lowerUpperOperators[i], ((StringOperationsData)this.data).padType[i], ((StringOperationsData)this.data).padChar[i], ((StringOperationsData)this.data).padLen[i], ((StringOperationsData)this.data).initCap[i], ((StringOperationsData)this.data).maskHTML[i], ((StringOperationsData)this.data).digits[i], ((StringOperationsData)this.data).removeSpecialCharacters[i]);
            if (Utils.isEmpty((CharSequence)((StringOperationsData)this.data).outStreamNrs[i])) {
                RowData[((StringOperationsData)this.data).inStreamNrs[i]] = value;
                ((StringOperationsData)this.data).outputRowMeta.getValueMeta(((StringOperationsData)this.data).inStreamNrs[i]).setStorageType(0);
                continue;
            }
            RowData[((StringOperationsData)this.data).inputFieldsNr + j] = value;
            ++j;
        }
        return RowData;
    }

    public boolean processRow() throws HopException {
        block18: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                ((StringOperationsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((StringOperationsData)this.data).inputFieldsNr = ((StringOperationsData)this.data).outputRowMeta.size();
                ((StringOperationsMeta)this.meta).getFields(((StringOperationsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((StringOperationsData)this.data).nrFieldsInStream = ((StringOperationsMeta)this.meta).getFieldInStream().length;
                ((StringOperationsData)this.data).inStreamNrs = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).inStreamNrs[i] = this.getInputRowMeta().indexOfValue(((StringOperationsMeta)this.meta).getFieldInStream()[i]);
                    if (((StringOperationsData)this.data).inStreamNrs[i] < 0) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"StringOperations.Exception.FieldRequired", (String[])new String[]{((StringOperationsMeta)this.meta).getFieldInStream()[i]}));
                    }
                    if (this.getInputRowMeta().getValueMeta(((StringOperationsData)this.data).inStreamNrs[i]).isString()) continue;
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"StringOperations.Exception.FieldTypeNotString", (String[])new String[]{((StringOperationsMeta)this.meta).getFieldInStream()[i]}));
                }
                ((StringOperationsData)this.data).outStreamNrs = new String[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).outStreamNrs[i] = ((StringOperationsMeta)this.meta).getFieldOutStream()[i];
                }
                ((StringOperationsData)this.data).trimOperators = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).trimOperators[i] = ((StringOperationsMeta)this.meta).getTrimType()[i];
                }
                ((StringOperationsData)this.data).lowerUpperOperators = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).lowerUpperOperators[i] = ((StringOperationsMeta)this.meta).getLowerUpper()[i];
                }
                ((StringOperationsData)this.data).padType = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).padType[i] = ((StringOperationsMeta)this.meta).getPaddingType()[i];
                }
                ((StringOperationsData)this.data).padChar = new String[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).padChar[i] = this.resolve(((StringOperationsMeta)this.meta).getPadChar()[i]);
                }
                ((StringOperationsData)this.data).padLen = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).padLen[i] = Const.toInt((String)this.resolve(((StringOperationsMeta)this.meta).getPadLen()[i]), (int)0);
                }
                ((StringOperationsData)this.data).initCap = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).initCap[i] = ((StringOperationsMeta)this.meta).getInitCap()[i];
                }
                ((StringOperationsData)this.data).maskHTML = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).maskHTML[i] = ((StringOperationsMeta)this.meta).getMaskXML()[i];
                }
                ((StringOperationsData)this.data).digits = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).digits[i] = ((StringOperationsMeta)this.meta).getDigits()[i];
                }
                ((StringOperationsData)this.data).removeSpecialCharacters = new int[((StringOperationsData)this.data).nrFieldsInStream];
                for (i = 0; i < ((StringOperationsMeta)this.meta).getFieldInStream().length; ++i) {
                    ((StringOperationsData)this.data).removeSpecialCharacters[i] = ((StringOperationsMeta)this.meta).getRemoveSpecialCharacters()[i];
                }
            }
            try {
                Object[] output = this.processRow(this.getInputRowMeta(), r);
                this.putRow(((StringOperationsData)this.data).outputRowMeta, output);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"StringOperations.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"StringOperations.Log.ErrorInTransform", (String[])new String[]{e.getMessage()}));
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block18;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "StringOperations001");
            }
        }
        return true;
    }

    public boolean init() {
        boolean rCode = true;
        if (super.init()) {
            return rCode;
        }
        return false;
    }

    public void dispose() {
        super.dispose();
    }
}

