/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.workflow.xp;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.reflection.workflow.meta.WorkflowLog;
import org.apache.hop.reflection.workflow.transform.WorkflowLogging;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@ExtensionPoint(id="WorkflowStartLoggingXp", extensionPointId="WorkflowStart", description="At the start of a workflow, handle any Workflow Log metadata objects")
public class WorkflowStartLoggingXp
implements IExtensionPoint<Workflow> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, Workflow workflow) throws HopException {
        IHopMetadataProvider metadataProvider = workflow.getMetadataProvider();
        IHopMetadataSerializer serializer = metadataProvider.getSerializer(WorkflowLog.class);
        List workflowLogs = serializer.loadAll();
        for (WorkflowLog workflowLog : workflowLogs) {
            this.handleWorkflowLog(log, workflowLog, (IWorkflowEngine<WorkflowMeta>)workflow, variables);
        }
    }

    private void handleWorkflowLog(ILogChannel log, final WorkflowLog workflowLog, final IWorkflowEngine<WorkflowMeta> workflow, final IVariables variables) throws HopException {
        try {
            int intervalInSeconds;
            if (!workflowLog.isEnabled()) {
                return;
            }
            if (workflowLog.isLoggingParentsOnly() && (workflow.getParentPipeline() != null || workflow.getParentWorkflow() != null)) {
                return;
            }
            final String loggingPipelineFilename = variables.resolve(workflowLog.getPipelineFilename());
            FileObject loggingFileObject = HopVfs.getFileObject((String)loggingPipelineFilename);
            if (!loggingFileObject.exists()) {
                log.logBasic("WARNING: The Workflow Log pipeline file '" + loggingPipelineFilename + "' couldn't be found to execute.");
                return;
            }
            Timer timer = new Timer();
            if (workflowLog.isExecutingAtStart()) {
                this.executeLoggingPipeline(workflowLog, "start", loggingPipelineFilename, workflow, variables);
            }
            if (workflowLog.isExecutingAtEnd()) {
                workflow.addWorkflowFinishedListener(engine -> {
                    this.executeLoggingPipeline(workflowLog, "end", loggingPipelineFilename, workflow, variables);
                    timer.cancel();
                });
            }
            if (workflowLog.isExecutingPeriodically() && (intervalInSeconds = Const.toInt((String)variables.resolve(workflowLog.getIntervalInSeconds()), (int)-1)) > 0) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            WorkflowStartLoggingXp.this.executeLoggingPipeline(workflowLog, "interval", loggingPipelineFilename, (IWorkflowEngine<WorkflowMeta>)workflow, variables);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to do interval logging for Workflow Log object '" + workflowLog.getName() + "'", e);
                        }
                    }
                };
                timer.schedule(timerTask, (long)intervalInSeconds * 1000L, (long)intervalInSeconds * 1000L);
            }
        }
        catch (Exception e) {
            workflow.stopExecution();
            throw new HopException("Error handling Workflow Log metadata object '" + workflowLog.getName() + "' at the start of pipeline: " + workflow, (Throwable)e);
        }
    }

    private synchronized void executeLoggingPipeline(WorkflowLog pipelineLog, String loggingPhase, String loggingPipelineFilename, IWorkflowEngine<WorkflowMeta> workflow, IVariables variables) throws HopException {
        PipelineMeta loggingPipelineMeta = new PipelineMeta(loggingPipelineFilename, workflow.getMetadataProvider(), true, variables);
        LocalPipelineEngine loggingPipeline = new LocalPipelineEngine(loggingPipelineMeta, variables, workflow);
        loggingPipeline.getExtensionDataMap().put("PipelineLoggingActive", "Y");
        loggingPipeline.setLogLevel(LogLevel.ERROR);
        loggingPipeline.prepareExecution();
        for (TransformMetaDataCombi combi : loggingPipeline.getTransforms()) {
            if (!(combi.transform instanceof WorkflowLogging)) continue;
            WorkflowLogging workflowLogging = (WorkflowLogging)combi.transform;
            workflowLogging.setLoggingWorkflow(workflow);
            workflowLogging.setLoggingPhase(loggingPhase);
        }
        loggingPipeline.startThreads();
        loggingPipeline.waitUntilFinished();
    }
}

