/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.probe.transform;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.reflection.probe.transform.PipelineDataProbe;
import org.apache.hop.reflection.probe.transform.PipelineDataProbeData;
import org.w3c.dom.Node;

@Transform(id="PipelineDataProbe", name="i18n::PipelineDataProbe.Transform.Name", description="i18n::PipelineDataProbe.Transform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/logging/logging-reflection.html", image="probe.svg", keywords={"audit,log,metrics,profile,probe,stream"})
public class PipelineDataProbeMeta
extends BaseTransformMeta
implements ITransformMeta<PipelineDataProbe, PipelineDataProbeData> {
    private boolean loggingTransforms;

    public void setDefault() {
        this.loggingTransforms = true;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("sourcePipelineName", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("sourceTransformLogChannelId", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("sourceTransformName", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("sourceTransformCopy", 7, 0));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("rowNr", 15, 0));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("fieldName", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("fieldType", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("fieldFormat", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("fieldLength", 7, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("fieldPrecision", 7, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("value", 1000000, -1));
    }

    public String getXml() throws HopException {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)"log_transforms", (boolean)this.loggingTransforms));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.loggingTransforms = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"log_transforms"));
    }

    public PipelineDataProbe createTransform(TransformMeta transformMeta, PipelineDataProbeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new PipelineDataProbe(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public PipelineDataProbeData getTransformData() {
        return new PipelineDataProbeData();
    }

    public boolean isLoggingTransforms() {
        return this.loggingTransforms;
    }

    public void setLoggingTransforms(boolean loggingTransforms) {
        this.loggingTransforms = loggingTransforms;
    }
}

