/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.probe.gui;

import java.util.List;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.reflection.probe.meta.DataProbeLocation;
import org.apache.hop.reflection.probe.meta.PipelineProbe;
import org.apache.hop.reflection.probe.meta.PipelineProbeEditor;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileOpenedExtension;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineTransformContext;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.eclipse.swt.widgets.MessageBox;

@GuiPlugin
public class DataProbeGuiPlugin {
    @GuiContextAction(id="pipeline-graph-transform-9000-add-probe", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Info, name="Add data probe", tooltip="Streams the rows to a pipeline defined in a selected pipeline probe", image="probe.svg", category="Preview", categoryOrder="3")
    public void addDataProbeForTransform(HopGuiPipelineTransformContext context) {
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        HopGui hopGui = HopGui.getInstance();
        try {
            IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(PipelineProbe.class);
            MetadataManager manager = new MetadataManager(hopGui.getVariables(), metadataProvider, PipelineProbe.class);
            PipelineProbe pipelineProbe = null;
            List pipelineProbeNames = serializer.listObjectNames();
            if (pipelineProbeNames.isEmpty()) {
                MessageBox box = new MessageBox(hopGui.getShell(), 196);
                box.setText("No probes available");
                box.setMessage("There are no pipeline probe objects defined yet.  Do you want to create one?");
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    pipelineProbe = new PipelineProbe();
                    this.addLocation(hopGui.getVariables(), pipelineProbe, pipelineMeta, transformMeta);
                    manager.newMetadata((IHopMetadata)pipelineProbe);
                    return;
                }
                return;
            }
            EnterSelectionDialog dialog = new EnterSelectionDialog(hopGui.getShell(), pipelineProbeNames.toArray(new String[0]), "Select pipeline probe", "Select the pipeline probe to add this pipeline transform to");
            String pipelineProbeName = dialog.open();
            if (pipelineProbeName != null) {
                pipelineProbe = (PipelineProbe)serializer.load(pipelineProbeName);
            }
            if (pipelineProbe != null) {
                String key;
                MetadataPerspective perspective = (MetadataPerspective)hopGui.getPerspectiveManager().findPerspective(MetadataPerspective.class);
                PipelineProbeEditor editor = (PipelineProbeEditor)perspective.findEditor(key = PipelineProbe.class.getAnnotation(HopMetadata.class).key(), pipelineProbe.getName());
                if (editor != null) {
                    pipelineProbe = new PipelineProbe();
                    editor.getWidgetsContent(pipelineProbe);
                    this.addLocation(hopGui.getVariables(), pipelineProbe, pipelineMeta, transformMeta);
                    editor.setMetadata(pipelineProbe);
                    editor.setWidgetsContent();
                    editor.setChanged();
                    perspective.activate();
                    perspective.setActiveEditor((MetadataEditor)editor);
                    return;
                }
                this.addLocation(hopGui.getVariables(), pipelineProbe, pipelineMeta, transformMeta);
                serializer.save((IHopMetadata)pipelineProbe);
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error adding pipeline probe to transform '" + transformMeta.getName() + "'", e);
        }
    }

    private void addLocation(IVariables variables, PipelineProbe pipelineProbe, PipelineMeta pipelineMeta, TransformMeta transformMeta) throws HopException {
        String probeFilename = pipelineMeta.getFilename();
        HopGuiFileOpenedExtension ext = new HopGuiFileOpenedExtension(null, variables, probeFilename);
        ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiFileOpenedDialog.id, (Object)ext);
        pipelineProbe.getDataProbeLocations().add(new DataProbeLocation(ext.filename, transformMeta.getName()));
    }
}

