/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.pipeline.transform;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.reflection.pipeline.transform.PipelineLogging;
import org.apache.hop.reflection.pipeline.transform.PipelineLoggingData;
import org.w3c.dom.Node;

@Transform(id="PipelineLogging", name="i18n::PipelineLogging.Transform.Name", description="i18n::PipelineLogging.Transform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", image="pipeline-log.svg", documentationUrl="/logging/logging-reflection.html", keywords={"audit,log,metrics"})
public class PipelineLoggingMeta
extends BaseTransformMeta
implements ITransformMeta<PipelineLogging, PipelineLoggingData> {
    private boolean loggingTransforms;

    public void setDefault() {
        this.loggingTransforms = true;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("loggingDate"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("loggingPhase"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineName", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineFilename", 255, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("pipelineStart"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("pipelineEnd"));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineLogChannelId", 32, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("parentLogChannelId", 32, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineLogging", 1000000, -1));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("pipelineErrorCount", 3, 0));
        inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("pipelineStatusDescription", 32, -1));
        if (this.loggingTransforms) {
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformName"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformCopyNr"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformStatusDescription", 100, -1));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformLogChannelId", 32, -1));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaString("transformLoggingText", 1000000, -1));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesRead", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesWritten", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesInput", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesOutput", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesUpdated", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformLinesRejected", 12, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformErrors", 3, 0));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("transformStart"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaDate("transformEnd"));
            inputRowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("transformDuration", 12, 0));
        }
    }

    public String getXml() throws HopException {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)"log_transforms", (boolean)this.loggingTransforms));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.loggingTransforms = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"log_transforms"));
    }

    public PipelineLogging createTransform(TransformMeta transformMeta, PipelineLoggingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new PipelineLogging(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public PipelineLoggingData getTransformData() {
        return new PipelineLoggingData();
    }

    public boolean isLoggingTransforms() {
        return this.loggingTransforms;
    }

    public void setLoggingTransforms(boolean loggingTransforms) {
        this.loggingTransforms = loggingTransforms;
    }
}

