/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.pipeline.transform;

import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.reflection.pipeline.transform.PipelineLoggingData;
import org.apache.hop.reflection.pipeline.transform.PipelineLoggingMeta;

public class PipelineLogging
extends BaseTransform<PipelineLoggingMeta, PipelineLoggingData>
implements ITransform<PipelineLoggingMeta, PipelineLoggingData> {
    private IPipelineEngine<PipelineMeta> loggingPipeline;
    private String loggingPhase;

    public PipelineLogging(TransformMeta transformMeta, PipelineLoggingMeta meta, PipelineLoggingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        if (this.loggingPipeline == null) {
            this.logBasic("This transform will produce output when called by the Pipeline Log configuration");
            this.setOutputDone();
            return false;
        }
        RowMeta outputRowMeta = new RowMeta();
        ((PipelineLoggingMeta)this.meta).getFields((IRowMeta)outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        PipelineMeta pipelineMeta = this.loggingPipeline.getPipelineMeta();
        Object[] pipelineRow = RowDataUtil.allocateRowData((int)outputRowMeta.size());
        int index = 0;
        pipelineRow[index++] = this.getPipeline().getExecutionStartDate();
        pipelineRow[index++] = this.loggingPhase;
        pipelineRow[index++] = pipelineMeta.getName();
        pipelineRow[index++] = pipelineMeta.getFilename();
        pipelineRow[index++] = this.loggingPipeline.getExecutionStartDate();
        pipelineRow[index++] = this.loggingPipeline.getExecutionEndDate();
        pipelineRow[index++] = this.loggingPipeline.getLogChannelId();
        ILoggingObject parent = this.loggingPipeline.getParent();
        pipelineRow[index++] = parent == null ? null : parent.getLogChannelId();
        pipelineRow[index++] = HopLogStore.getAppender().getBuffer(this.loggingPipeline.getLogChannelId(), false).toString();
        pipelineRow[index++] = (long)this.loggingPipeline.getErrors();
        pipelineRow[index++] = this.loggingPipeline.getStatusDescription();
        int startIndex = index;
        List components = this.loggingPipeline.getComponents();
        if (((PipelineLoggingMeta)this.meta).isLoggingTransforms() && !components.isEmpty()) {
            for (IEngineComponent component : components) {
                index = startIndex;
                Object[] transformRow = RowDataUtil.createResizedCopy((Object[])pipelineRow, (int)outputRowMeta.size());
                transformRow[index++] = component.getName();
                transformRow[index++] = (long)component.getCopyNr();
                transformRow[index++] = component.getStatusDescription();
                transformRow[index++] = component.getLogChannelId();
                transformRow[index++] = component.getLogText();
                transformRow[index++] = component.getLinesRead();
                transformRow[index++] = component.getLinesWritten();
                transformRow[index++] = component.getLinesInput();
                transformRow[index++] = component.getLinesOutput();
                transformRow[index++] = component.getLinesUpdated();
                transformRow[index++] = component.getLinesRejected();
                transformRow[index++] = component.getErrors();
                transformRow[index++] = component.getExecutionStartDate();
                transformRow[index++] = component.getExecutionEndDate();
                transformRow[index] = component.getExecutionDuration();
                this.putRow((IRowMeta)outputRowMeta, transformRow);
            }
        } else {
            this.putRow((IRowMeta)outputRowMeta, pipelineRow);
        }
        this.setOutputDone();
        return false;
    }

    public IPipelineEngine<PipelineMeta> getLoggingPipeline() {
        return this.loggingPipeline;
    }

    public void setLoggingPipeline(IPipelineEngine<PipelineMeta> loggingPipeline) {
        this.loggingPipeline = loggingPipeline;
    }

    public String getLoggingPhase() {
        return this.loggingPhase;
    }

    public void setLoggingPhase(String loggingPhase) {
        this.loggingPhase = loggingPhase;
    }
}

