/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldschangesequence;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fieldschangesequence.FieldsChangeSequence;
import org.apache.hop.pipeline.transforms.fieldschangesequence.FieldsChangeSequenceData;
import org.apache.hop.pipeline.transforms.fieldschangesequence.FieldsChangeSequenceField;

@Transform(id="FieldsChangeSequence", image="fieldschangesequence.svg", name="i18n::FieldsChangeSequence.Name", description="i18n::FieldsChangeSequence.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/addfieldschangesequence.html")
public class FieldsChangeSequenceMeta
extends BaseTransformMeta
implements ITransformMeta<FieldsChangeSequence, FieldsChangeSequenceData> {
    private static final Class<?> PKG = FieldsChangeSequenceMeta.class;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupDescription="FieldsChangeSequenceMeta.Injection.Fields", injectionKeyDescription="FieldsChangeSequenceMeta.Injection.Field")
    private List<FieldsChangeSequenceField> fields;
    @HopMetadataProperty(key="resultfieldName", injectionKeyDescription="FieldsChangeSequenceMeta.Injection.ResultFieldName")
    private String resultFieldName;
    @HopMetadataProperty(key="start", injectionKeyDescription="FieldsChangeSequenceMeta.Injection.Start")
    private String start;
    @HopMetadataProperty(key="increment", injectionKeyDescription="FieldsChangeSequenceMeta.Injection.Increment")
    private String increment;

    public FieldsChangeSequenceMeta() {
        this.fields = new ArrayList<FieldsChangeSequenceField>();
    }

    public FieldsChangeSequenceMeta(FieldsChangeSequenceMeta meta) {
        this.start = meta.getStart();
        this.increment = meta.getIncrement();
        this.resultFieldName = meta.getResultFieldName();
        this.fields = new ArrayList<FieldsChangeSequenceField>();
        for (FieldsChangeSequenceField field : meta.getFields()) {
            this.fields.add(new FieldsChangeSequenceField(field.getName()));
        }
    }

    public String getStart() {
        return this.start;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String resultfieldName) {
        this.resultFieldName = resultfieldName;
    }

    public Object clone() {
        return new FieldsChangeSequenceMeta(this);
    }

    public List<FieldsChangeSequenceField> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldsChangeSequenceField> fieldName) {
        this.fields = fieldName;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setIncrement(String increment) {
        this.increment = increment;
    }

    public String getIncrement() {
        return this.increment;
    }

    public void setDefault() {
        this.resultFieldName = null;
        this.start = "1";
        this.increment = "1";
        this.fields = new ArrayList<FieldsChangeSequenceField>();
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (!Utils.isEmpty((CharSequence)this.resultFieldName)) {
            ValueMetaInteger v = new ValueMetaInteger(this.resultFieldName);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.resultFieldName)) {
            errorMessage = BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
        }
        remarks.add((ICheckResult)cr);
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.TransformRecevingData", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            boolean errorFound = false;
            errorMessage = "";
            for (FieldsChangeSequenceField field : this.fields) {
                int idx = prev.indexOfValue(field.getName());
                if (idx >= 0) continue;
                errorMessage = errorMessage + "\t\t" + field.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.FieldsFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (this.fields.isEmpty()) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public FieldsChangeSequence createTransform(TransformMeta transformMeta, FieldsChangeSequenceData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new FieldsChangeSequence(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public FieldsChangeSequenceData getTransformData() {
        return new FieldsChangeSequenceData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

