/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.workflow;

import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.Workflow;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engines.local.LocalWorkflowEngine;

public class ActionWorkflowRunner
implements Runnable {
    private static final Class<?> PKG = Workflow.class;
    private IWorkflowEngine<WorkflowMeta> workflow;
    private Result result;
    private ILogChannel log;
    private int entryNr;
    private boolean finished;

    public ActionWorkflowRunner(IWorkflowEngine<WorkflowMeta> workflow, Result result, int entryNr, ILogChannel log) {
        this.workflow = workflow;
        this.result = result;
        this.log = log;
        this.entryNr = entryNr;
        this.finished = false;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block15: {
            block14: {
                if (!this.workflow.isStopped() && (this.workflow.getParentWorkflow() == null || !this.workflow.getParentWorkflow().isStopped())) break block14;
                this.workflow.setResult(this.result);
                try {
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, this.workflow, (String)HopExtensionPoint.WorkflowFinish.id, this.workflow);
                    this.workflow.fireWorkflowFinishListeners();
                }
                catch (Exception e) {
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"Action.Log.ErrorExecWorkflow", (String[])new String[]{e.getMessage()}), (Throwable)e);
                }
                this.workflow.setFinished(true);
                return;
            }
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, this.workflow, (String)HopExtensionPoint.WorkflowStart.id, this.workflow);
            if (this.workflow instanceof LocalWorkflowEngine) {
                ((LocalWorkflowEngine)this.workflow).setInitializingVariablesOnStart(false);
            }
            this.result = this.workflow.startExecution();
            this.workflow.setResult(this.result);
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, this.workflow, (String)HopExtensionPoint.WorkflowFinish.id, this.workflow);
                this.workflow.fireWorkflowFinishListeners();
            }
            catch (Exception e) {
                this.result.setNrErrors(1L);
                this.result.setResult(false);
                this.log.logError(BaseMessages.getString(PKG, (String)"Action.Log.ErrorExecWorkflow", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            this.workflow.setFinished(true);
            break block15;
            catch (HopException e) {
                try {
                    e.printStackTrace();
                    this.log.logError("An error occurred executing this action : ", (Throwable)e);
                    this.result.setResult(false);
                    this.result.setNrErrors(1L);
                }
                catch (Throwable throwable) {
                    this.workflow.setResult(this.result);
                    try {
                        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, this.workflow, (String)HopExtensionPoint.WorkflowFinish.id, this.workflow);
                        this.workflow.fireWorkflowFinishListeners();
                    }
                    catch (Exception e2) {
                        this.result.setNrErrors(1L);
                        this.result.setResult(false);
                        this.log.logError(BaseMessages.getString(PKG, (String)"Action.Log.ErrorExecWorkflow", (String[])new String[]{e2.getMessage()}), (Throwable)e2);
                    }
                    this.workflow.setFinished(true);
                    throw throwable;
                }
                this.workflow.setResult(this.result);
                try {
                    ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, this.workflow, (String)HopExtensionPoint.WorkflowFinish.id, this.workflow);
                    this.workflow.fireWorkflowFinishListeners();
                }
                catch (Exception e3) {
                    this.result.setNrErrors(1L);
                    this.result.setResult(false);
                    this.log.logError(BaseMessages.getString(PKG, (String)"Action.Log.ErrorExecWorkflow", (String[])new String[]{e3.getMessage()}), (Throwable)e3);
                }
                this.workflow.setFinished(true);
            }
        }
        this.finished = true;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public ILogChannel getLog() {
        return this.log;
    }

    public void setLog(ILogChannel log) {
        this.log = log;
    }

    public IWorkflowEngine<WorkflowMeta> getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(IWorkflowEngine<WorkflowMeta> workflow) {
        this.workflow = workflow;
    }

    public int getEntryNr() {
        return this.entryNr;
    }

    public void setEntryNr(int entryNr) {
        this.entryNr = entryNr;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void waitUntilFinished() {
        while (!this.isFinished() && !this.workflow.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

