/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pipeline;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.ui.workflow.actions.ActionBaseDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.pipeline.ActionPipeline;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class ActionPipelineDialog
extends ActionBaseDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionPipeline.class;
    protected ActionPipeline action;
    private static final String[] FILE_FILTERLOGNAMES = new String[]{BaseMessages.getString(PKG, (String)"ActionPipeline.Fileformat.TXT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionPipeline.Fileformat.LOG", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionPipeline.Fileformat.All", (String[])new String[0])};

    public ActionPipelineDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, action, workflowMeta, variables);
        this.action = (ActionPipeline)action;
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        this.backupChanged = this.action.hasChanged();
        this.createElements();
        this.getData();
        this.setActive();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    protected void createElements() {
        super.createElements();
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.Header", (String[])new String[0]));
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.PipelineFile.Label", (String[])new String[0]));
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.PassAllParameters.Label", (String[])new String[0]));
        this.wClearRows = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wClearRows);
        this.wClearRows.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.ClearResultList.Label", (String[])new String[0]));
        FormData fdbClearRows = new FormData();
        fdbClearRows.left = new FormAttachment(0, 0);
        fdbClearRows.top = new FormAttachment((Control)this.wEveryRow, 10);
        this.wClearRows.setLayoutData((Object)fdbClearRows);
        this.wClearFiles = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wClearFiles);
        this.wClearFiles.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.ClearResultFiles.Label", (String[])new String[0]));
        FormData fdbClearFiles = new FormData();
        fdbClearFiles.left = new FormAttachment(0, 0);
        fdbClearFiles.top = new FormAttachment((Control)this.wClearRows, 10);
        this.wClearFiles.setLayoutData((Object)fdbClearFiles);
        this.wWaitingToFinish = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wWaitingToFinish);
        this.wWaitingToFinish.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.WaitToFinish.Label", (String[])new String[0]));
        FormData fdWait = new FormData();
        fdWait.top = new FormAttachment((Control)this.wClearFiles, 10);
        fdWait.left = new FormAttachment(0, 0);
        this.wWaitingToFinish.setLayoutData((Object)fdWait);
        this.wFollowingAbortRemotely = new Button((Composite)this.gExecution, 32);
        this.props.setLook((Control)this.wFollowingAbortRemotely);
        this.wFollowingAbortRemotely.setText(BaseMessages.getString(PKG, (String)"ActionPipeline.AbortRemote.Label", (String[])new String[0]));
        FormData fdFollow = new FormData();
        fdFollow.top = new FormAttachment((Control)this.wWaitingToFinish, 10);
        fdFollow.left = new FormAttachment(0, 0);
        this.wFollowingAbortRemotely.setLayoutData((Object)fdFollow);
        this.wbGetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ActionPipelineDialog.this.getParameters(null);
            }
        });
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionPipelineDialog.this.pickFileVFS();
            }
        });
        this.wbLogFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionPipelineDialog.this.selectLogFile(FILE_FILTERLOGNAMES);
            }
        });
    }

    protected ActionBase getAction() {
        return this.action;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ui/images/pipeline.svg", (int)48, (int)48);
    }

    protected String[] getParameters() {
        return this.action.parameters;
    }

    private void getParameters(PipelineMeta inputPipelineMeta) {
        try {
            if (inputPipelineMeta == null) {
                ActionPipeline jet = new ActionPipeline();
                this.getInfo(jet);
                inputPipelineMeta = jet.getPipelineMeta(this.getMetadataProvider(), this.variables);
            }
            String[] parameters = inputPipelineMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ActionPipelineDialog.Exception.UnableToLoadPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionPipelineDialog.Exception.UnableToLoadPipeline.Message", (String[])new String[0]), e);
        }
    }

    protected void pickFileVFS() {
        HopPipelineFileType pipelineFileType = new HopPipelineFileType();
        String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])pipelineFileType.getFilterExtensions(), (String[])pipelineFileType.getFilterNames(), (boolean)true);
        if (filename != null) {
            this.replaceNameWithBaseFilename(filename);
        }
    }

    public String getEntryName(String name) {
        return "${Internal.Entry.Current.Folder}/" + name;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.action.getName(), (String)""));
        this.wPath.setText(Const.NVL((String)this.action.getFilename(), (String)""));
        if (this.action.parameters != null) {
            for (int i = 0; i < this.action.parameters.length; ++i) {
                TableItem ti = this.wParameters.table.getItem(i);
                if (Utils.isEmpty((CharSequence)this.action.parameters[i])) continue;
                ti.setText(1, Const.NVL((String)this.action.parameters[i], (String)""));
                ti.setText(2, Const.NVL((String)this.action.parameterFieldNames[i], (String)""));
                ti.setText(3, Const.NVL((String)this.action.parameterValues[i], (String)""));
            }
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(this.action.isPassingAllParameters());
        if (this.action.logfile != null) {
            this.wLogfile.setText(this.action.logfile);
        }
        if (this.action.logext != null) {
            this.wLogext.setText(this.action.logext);
        }
        this.wPrevToParams.setSelection(this.action.paramsFromPrevious);
        this.wEveryRow.setSelection(this.action.execPerRow);
        this.wSetLogfile.setSelection(this.action.setLogfile);
        this.wAddDate.setSelection(this.action.addDate);
        this.wAddTime.setSelection(this.action.addTime);
        this.wClearRows.setSelection(this.action.clearResultRows);
        this.wClearFiles.setSelection(this.action.clearResultFiles);
        this.wWaitingToFinish.setSelection(this.action.isWaitingToFinish());
        this.wFollowingAbortRemotely.setSelection(this.action.isFollowingAbortRemotely());
        this.wAppendLogfile.setSelection(this.action.setAppendLogfile);
        this.wbLogFilename.setSelection(this.action.setAppendLogfile);
        this.wCreateParentFolder.setSelection(this.action.createParentFolder);
        if (this.action.logFileLevel != null) {
            this.wLoglevel.select(this.action.logFileLevel.getLevel());
        }
        try {
            List runConfigurations = this.getMetadataProvider().getSerializer(PipelineRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.action.getRunConfiguration(), (String)""));
            if (Utils.isEmpty((CharSequence)this.action.getRunConfiguration())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.action.getRunConfiguration());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting pipeline run configurations", (Throwable)e);
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    protected void cancel() {
        this.action.setChanged(this.backupChanged);
        this.action = null;
        this.dispose();
    }

    private void getInfo(ActionPipeline actionPipeline) throws HopException {
        String param;
        int i;
        actionPipeline.setName(this.wName.getText());
        actionPipeline.setRunConfiguration(this.wRunConfiguration.getText());
        actionPipeline.setFileName(this.wPath.getText());
        if (actionPipeline.getFilename().isEmpty()) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionPipeline.Dialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
        }
        int nrItems = this.wParameters.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nrItems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            if (param == null || param.length() == 0) continue;
            ++nr;
        }
        actionPipeline.parameters = new String[nrItems];
        actionPipeline.parameterFieldNames = new String[nrItems];
        actionPipeline.parameterValues = new String[nrItems];
        nr = 0;
        for (i = 0; i < nrItems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            String fieldName = this.wParameters.getNonEmpty(i).getText(2);
            String value = this.wParameters.getNonEmpty(i).getText(3);
            actionPipeline.parameters[nr] = param;
            actionPipeline.parameterFieldNames[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)fieldName)) ? fieldName : "";
            actionPipeline.parameterValues[nr] = !Utils.isEmpty((CharSequence)Const.trim((String)value)) ? value : "";
            ++nr;
        }
        actionPipeline.setPassingAllParameters(this.wPassParams.getSelection());
        actionPipeline.logfile = this.wLogfile.getText();
        actionPipeline.logext = this.wLogext.getText();
        actionPipeline.logFileLevel = this.wLoglevel.getSelectionIndex() >= 0 ? LogLevel.values()[this.wLoglevel.getSelectionIndex()] : LogLevel.BASIC;
        actionPipeline.paramsFromPrevious = this.wPrevToParams.getSelection();
        actionPipeline.execPerRow = this.wEveryRow.getSelection();
        actionPipeline.setLogfile = this.wSetLogfile.getSelection();
        actionPipeline.addDate = this.wAddDate.getSelection();
        actionPipeline.addTime = this.wAddTime.getSelection();
        actionPipeline.clearResultRows = this.wClearRows.getSelection();
        actionPipeline.clearResultFiles = this.wClearFiles.getSelection();
        actionPipeline.createParentFolder = this.wCreateParentFolder.getSelection();
        actionPipeline.setRunConfiguration(this.wRunConfiguration.getText());
        actionPipeline.setAppendLogfile = this.wAppendLogfile.getSelection();
        actionPipeline.setWaitingToFinish(this.wWaitingToFinish.getSelection());
        actionPipeline.setFollowingAbortRemotely(this.wFollowingAbortRemotely.getSelection());
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox box = new MessageBox(this.shell, 33);
            box.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            box.open();
            return;
        }
        this.action.setName(this.wName.getText());
        try {
            this.getInfo(this.action);
        }
        catch (HopException hopException) {
            // empty catch block
        }
        this.action.setChanged();
        this.dispose();
    }
}

