/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.truncatetables;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.w3c.dom.Node;

@Action(id="TRUNCATE_TABLES", name="i18n::ActionTruncateTables.Name", description="i18n::ActionTruncateTables.Description", image="TruncateTables.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", documentationUrl="/workflow/actions/truncatetables.html")
public class ActionTruncateTables
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionTruncateTables.class;
    private boolean argFromPrevious = false;
    private DatabaseMeta connection = null;
    private String[] tableNames = null;
    private String[] schemaNames = null;
    private int nrErrors = 0;
    private int nrSuccess = 0;
    private boolean continueProcess = true;

    public ActionTruncateTables(String name) {
        super(name, "");
    }

    public ActionTruncateTables() {
        this("");
    }

    public void allocate(int nrFields) {
        this.tableNames = new String[nrFields];
        this.schemaNames = new String[nrFields];
    }

    public Object clone() {
        ActionTruncateTables je = (ActionTruncateTables)super.clone();
        if (this.tableNames != null) {
            int nrFields = this.tableNames.length;
            je.allocate(nrFields);
            System.arraycopy(this.tableNames, 0, je.tableNames, 0, nrFields);
            System.arraycopy(this.schemaNames, 0, je.schemaNames, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        retval.append("      <fields>").append(Const.CR);
        if (this.tableNames != null) {
            for (int i = 0; i < this.tableNames.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.tableNames[i]));
                retval.append("          ").append(XmlHandler.addTagValue((String)"schemaname", (String)this.schemaNames[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            String dbname = XmlHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.tableNames[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.schemaNames[i] = XmlHandler.getTagValue((Node)fnode, (String)"schemaname");
            }
        }
        catch (HopException e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionTruncateTables.UnableLoadXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    private boolean truncateTables(String tableName, String schemaname, Database db) {
        boolean retval = false;
        try {
            if (db.checkTableExists(schemaname, tableName)) {
                if (!Utils.isEmpty((CharSequence)schemaname)) {
                    db.truncateTable(schemaname, tableName);
                } else {
                    db.truncateTable(tableName);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Log.TableTruncated", (String[])new String[]{tableName}));
                }
                retval = true;
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Error.CanNotFindTable", (String[])new String[]{tableName}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionTruncateTables.Error.CanNotTruncateTables", (String[])new String[]{tableName, e.toString()}));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        result = previousResult;
        rows = result.getRows();
        resultRow = null;
        result.setResult(true);
        this.nrErrors = 0;
        this.continueProcess = true;
        this.nrSuccess = 0;
        if (this.argFromPrevious) {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (rows.isEmpty()) {
                return result;
            }
        }
        if (this.connection != null) {
            db = new Database((ILoggingObject)this, (IVariables)this, this.connection);
            try {
                db.connect();
                if (this.argFromPrevious && rows != null) {
                    for (iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped() && this.continueProcess; ++iteration) {
                        resultRow = (RowMetaAndData)rows.get(iteration);
                        tableNamePrevious = resultRow.getString(0, null);
                        schemaNamePrevious = resultRow.getString(1, null);
                        if (!Utils.isEmpty((CharSequence)tableNamePrevious)) {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.ProcessingRow", (String[])new String[]{tableNamePrevious, schemaNamePrevious}));
                            }
                            if (this.truncateTables(tableNamePrevious, schemaNamePrevious, db)) {
                                this.updateSuccess();
                                continue;
                            }
                            this.updateErrors();
                            continue;
                        }
                        this.logError(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.RowEmpty", (String[])new String[0]));
                    }
                }
                if (this.tableNames == null) ** GOTO lbl58
                for (i = 0; i < this.tableNames.length && !this.parentWorkflow.isStopped() && this.continueProcess; ++i) {
                    realTablename = this.resolve(this.tableNames[i]);
                    realSchemaname = this.resolve(this.schemaNames[i]);
                    if (!Utils.isEmpty((CharSequence)realTablename)) {
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.ProcessingArg", (String[])new String[]{this.tableNames[i], this.schemaNames[i]}));
                        }
                        if (this.truncateTables(realTablename, realSchemaname, db)) {
                            this.updateSuccess();
                            continue;
                        }
                        this.updateErrors();
                        continue;
                    }
                    this.logError(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.ArgEmpty", (String[])new String[]{this.tableNames[i], this.schemaNames[i]}));
                }
            }
            catch (Exception dbe) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.Error.RunningEntry", (String[])new String[]{dbe.getMessage()}));
            }
            finally {
                if (db != null) {
                    db.disconnect();
                }
            }
        } else {
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(ActionTruncateTables.PKG, (String)"ActionTruncateTables.NoDbConnection", (String[])new String[0]));
        }
lbl58:
        // 5 sources

        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesDeleted((long)this.nrSuccess);
        result.setResult(this.nrErrors == 0);
        return result;
    }

    private void updateErrors() {
        ++this.nrErrors;
        this.continueProcess = false;
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.tableNames.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.tableNames != null) {
            ResourceReference reference = null;
            for (int i = 0; i < this.tableNames.length; ++i) {
                String filename = this.resolve(this.tableNames[i]);
                if (reference == null) {
                    reference = new ResourceReference((IResourceHolder)this);
                    references.add(reference);
                }
                reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
            }
        }
        return references;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public void setTableNames(String[] tableNames) {
        this.tableNames = tableNames;
    }

    public String[] getSchemaNames() {
        return this.schemaNames;
    }

    public void setSchemaNames(String[] schemaNames) {
        this.schemaNames = schemaNames;
    }
}

