/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.copyfiles;

import java.util.HashMap;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ITextVarButtonRenderCallback;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.copyfiles.ActionCopyFiles;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ActionCopyFilesDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionCopyFiles.class;
    protected static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionCopyFiles.Filetype.All", (String[])new String[0])};
    public static final String LOCAL_ENVIRONMENT = "Local";
    public static final String STATIC_ENVIRONMENT = "<Static>";
    protected Text wName;
    protected Button wPrevious;
    protected Button wCopyEmptyFolders;
    protected Button wOverwriteFiles;
    protected Button wIncludeSubfolders;
    protected Button wRemoveSourceFiles;
    protected Button wAddFileToResult;
    protected Button wDestinationIsAFile;
    protected Button wCreateDestinationFolder;
    protected ActionCopyFiles action;
    protected Shell shell;
    protected boolean changed;
    private Label wlFields;
    protected TableView wFields;
    private ToolItem deleteToolItem;

    public ActionCopyFilesDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionCopyFiles)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Name.Default", (String[])new String[0]));
        }
    }

    protected void initUi() {
        int rows;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 16384);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(0, 0);
        fdName.top = new FormAttachment((Control)wlName, margin);
        fdName.right = new FormAttachment(40, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin * 3);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wFilesTab = new CTabItem(wTabFolder, 0);
        wFilesTab.setText(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Tab.Files.Label", (String[])new String[0]));
        Composite wFilesComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFilesComp);
        FormLayout filesLayout = new FormLayout();
        filesLayout.marginWidth = 3;
        filesLayout.marginHeight = 3;
        wFilesComp.setLayout((Layout)filesLayout);
        FormData fdFilesComp = new FormData();
        fdFilesComp.left = new FormAttachment(0, 0);
        fdFilesComp.top = new FormAttachment(0, 0);
        fdFilesComp.right = new FormAttachment(100, 0);
        fdFilesComp.bottom = new FormAttachment(100, 0);
        wFilesComp.setLayoutData((Object)fdFilesComp);
        wFilesComp.layout();
        wFilesTab.setControl((Control)wFilesComp);
        CTabItem wSettingsTab = new CTabItem(wTabFolder, 0);
        wSettingsTab.setText(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Settings.Label", (String[])new String[0]));
        Composite wSettingsComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wSettingsComp);
        FormLayout settingsLayout = new FormLayout();
        settingsLayout.marginWidth = 3;
        settingsLayout.marginHeight = 3;
        wSettingsComp.setLayout((Layout)settingsLayout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionCopyFilesDialog.this.action.setChanged();
            }
        };
        this.wIncludeSubfolders = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.IncludeSubfolders.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.IncludeSubfolders.Tooltip", (String[])new String[0]), null, listener);
        this.wDestinationIsAFile = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.DestinationIsAFile.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.DestinationIsAFile.Tooltip", (String[])new String[0]), (Control)this.wIncludeSubfolders, listener);
        this.wCopyEmptyFolders = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.CopyEmptyFolders.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.CopyEmptyFolders.Tooltip", (String[])new String[0]), (Control)this.wDestinationIsAFile, listener);
        this.wCreateDestinationFolder = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.CreateDestinationFolder.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.CreateDestinationFolder.Tooltip", (String[])new String[0]), (Control)this.wCopyEmptyFolders, listener);
        this.wOverwriteFiles = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.OverwriteFiles.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.OverwriteFiles.Tooltip", (String[])new String[0]), (Control)this.wCreateDestinationFolder, listener);
        this.wRemoveSourceFiles = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.RemoveSourceFiles.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.RemoveSourceFiles.Tooltip", (String[])new String[0]), (Control)this.wOverwriteFiles, listener);
        this.wPrevious = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.Previous.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.Previous.Tooltip", (String[])new String[0]), (Control)this.wRemoveSourceFiles, listener);
        this.wAddFileToResult = this.createSettingsButton(wSettingsComp, BaseMessages.getString(PKG, (String)"ActionCopyFiles.AddFileToResult.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCopyFiles.AddFileToResult.Tooltip", (String[])new String[0]), (Control)this.wPrevious, listener);
        FormData fdSettingsComp = new FormData();
        fdSettingsComp.left = new FormAttachment(0, 0);
        fdSettingsComp.top = new FormAttachment(0, 0);
        fdSettingsComp.right = new FormAttachment(100, 0);
        fdSettingsComp.bottom = new FormAttachment(100, 0);
        wSettingsComp.setLayoutData((Object)fdSettingsComp);
        wSettingsComp.layout();
        wSettingsTab.setControl((Control)wSettingsComp);
        this.props.setLook((Control)wSettingsComp);
        ToolBar tb = new ToolBar(wFilesComp, 0x800100);
        this.props.setLook((Control)tb);
        FormData fdTb = new FormData();
        fdTb.right = new FormAttachment(100, 0);
        fdTb.top = new FormAttachment((Control)wFilesComp, margin);
        tb.setLayoutData((Object)fdTb);
        this.deleteToolItem = new ToolItem(tb, 8);
        this.deleteToolItem.setImage(GuiResource.getInstance().getImageDelete());
        this.deleteToolItem.setToolTipText(BaseMessages.getString(PKG, (String)"ActionCopyFiles.FilenameDelete.Tooltip", (String[])new String[0]));
        this.deleteToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = ActionCopyFilesDialog.this.wFields.getSelectionIndices();
                ActionCopyFilesDialog.this.wFields.remove(idx);
                ActionCopyFilesDialog.this.wFields.removeEmptyRows();
                ActionCopyFilesDialog.this.wFields.setRowNums();
            }
        });
        this.wlFields = new Label(wFilesComp, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, margin);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)wFilesComp, 15);
        this.wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = rows = this.action.sourceFileFolder == null ? 1 : (this.action.sourceFileFolder.length == 0 ? 0 : this.action.sourceFileFolder.length);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.SourceEnvironment.Label", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.SourceFileFolder.Label", (String[])new String[0]), 6, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.Wildcard.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.DestinationEnvironment.Label", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.DestinationFileFolder.Label", (String[])new String[0]), 6, false)};
        this.setComboValues(colinf[0]);
        ITextVarButtonRenderCallback callback = () -> {
            String envType = this.wFields.getActiveTableItem().getText(this.wFields.getActiveTableColumn() - 1);
            return !STATIC_ENVIRONMENT.equalsIgnoreCase(envType);
        };
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.SourceFileFolder.Tooltip", (String[])new String[0]));
        colinf[1].setTextVarButtonSelectionListener((SelectionListener)this.getFileSelectionAdapter());
        colinf[1].setRenderTextVarButtonCallback(callback);
        colinf[2].setUsingVariables(true);
        colinf[2].setToolTip(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.Wildcard.Tooltip", (String[])new String[0]));
        this.setComboValues(colinf[3]);
        colinf[4].setUsingVariables(true);
        colinf[4].setToolTip(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Fields.DestinationFileFolder.Tooltip", (String[])new String[0]));
        colinf[4].setTextVarButtonSelectionListener((SelectionListener)this.getFileSelectionAdapter());
        this.wFields = new TableView(this.variables, wFilesComp, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, margin);
        fdFields.top = new FormAttachment((Control)tb, margin);
        fdFields.right = new FormAttachment(100, -margin);
        fdFields.bottom = new FormAttachment(100, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.refreshArgFromPrevious();
        this.getData();
        wTabFolder.setSelection(0);
    }

    public IAction open() {
        this.initUi();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    protected Button createSettingsButton(Composite p, String text, String title, Control top, SelectionAdapter sa) {
        Button button = new Button(p, 32);
        button.setText(text);
        button.setToolTipText(title);
        this.props.setLook((Control)button);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 8);
        fd.top = top == null ? new FormAttachment(0, 10) : new FormAttachment(top, 5);
        fd.right = new FormAttachment(100, 0);
        button.setLayoutData((Object)fd);
        button.addSelectionListener((SelectionListener)sa);
        return button;
    }

    protected SelectionAdapter getFileSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename = BaseDialog.presentFileDialog((Shell)ActionCopyFilesDialog.this.shell, null, null, (boolean)true);
                if (filename != null) {
                    ActionCopyFilesDialog.this.wFields.getActiveTableItem().setText(ActionCopyFilesDialog.this.wFields.getActiveTableColumn(), filename);
                }
            }
        };
    }

    private void refreshArgFromPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
        this.deleteToolItem.setEnabled(!this.wPrevious.getSelection());
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        this.wCopyEmptyFolders.setSelection(this.action.copyEmptyFolders);
        if (this.action.sourceFileFolder != null) {
            for (int i = 0; i < this.action.sourceFileFolder.length; ++i) {
                String clusterName;
                TableItem ti = this.wFields.table.getItem(i);
                if (this.action.sourceFileFolder[i] != null) {
                    String sourceUrl = this.action.sourceFileFolder[i];
                    clusterName = this.action.getConfigurationBy(sourceUrl);
                    if (clusterName != null) {
                        clusterName = clusterName.startsWith("LOCAL-SOURCE-FILE-") ? LOCAL_ENVIRONMENT : clusterName;
                        clusterName = clusterName.startsWith("STATIC-SOURCE-FILE-") ? STATIC_ENVIRONMENT : clusterName;
                        ti.setText(1, clusterName);
                        sourceUrl = clusterName.equals(LOCAL_ENVIRONMENT) || clusterName.equals(STATIC_ENVIRONMENT) ? sourceUrl : this.action.getUrlPath(sourceUrl);
                    }
                    sourceUrl = sourceUrl != null ? sourceUrl.replace("EMPTY_SOURCE_URL-" + i + "-", "") : "";
                    ti.setText(2, sourceUrl);
                }
                if (this.action.wildcard[i] != null) {
                    ti.setText(3, this.action.wildcard[i]);
                }
                if (this.action.destinationFileFolder[i] == null) continue;
                String destinationURL = this.action.destinationFileFolder[i];
                clusterName = this.action.getConfigurationBy(destinationURL);
                if (clusterName != null) {
                    clusterName = clusterName.startsWith("LOCAL-DEST-FILE-") ? LOCAL_ENVIRONMENT : clusterName;
                    clusterName = clusterName.startsWith("STATIC-DEST-FILE-") ? STATIC_ENVIRONMENT : clusterName;
                    ti.setText(4, clusterName);
                    destinationURL = clusterName.equals(LOCAL_ENVIRONMENT) || clusterName.equals(STATIC_ENVIRONMENT) ? destinationURL : this.action.getUrlPath(destinationURL);
                }
                destinationURL = destinationURL != null ? destinationURL.replace("EMPTY_DEST_URL-" + i + "-", "") : "";
                ti.setText(5, destinationURL);
            }
            this.wFields.optimizeTableView();
        }
        this.wPrevious.setSelection(this.action.argFromPrevious);
        this.wOverwriteFiles.setSelection(this.action.overwriteFiles);
        this.wIncludeSubfolders.setSelection(this.action.includeSubFolders);
        this.wRemoveSourceFiles.setSelection(this.action.removeSourceFiles);
        this.wDestinationIsAFile.setSelection(this.action.destinationIsAFile);
        this.wCreateDestinationFolder.setSelection(this.action.createDestinationFolder);
        this.wAddFileToResult.setSelection(this.action.addResultFilenames);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setCopyEmptyFolders(this.wCopyEmptyFolders.getSelection());
        this.action.setOverwriteFiles(this.wOverwriteFiles.getSelection());
        this.action.setIncludeSubFolders(this.wIncludeSubfolders.getSelection());
        this.action.setArgFromPrevious(this.wPrevious.getSelection());
        this.action.setRemoveSourceFiles(this.wRemoveSourceFiles.getSelection());
        this.action.setAddResultFilenames(this.wAddFileToResult.getSelection());
        this.action.setDestinationIsAFile(this.wDestinationIsAFile.getSelection());
        this.action.setCreateDestinationFolder(this.wCreateDestinationFolder.getSelection());
        int nrItems = this.wFields.nrNonEmpty();
        HashMap<String, String> sourceDestinationMappings = new HashMap<String, String>();
        this.action.sourceFileFolder = new String[nrItems];
        this.action.destinationFileFolder = new String[nrItems];
        this.action.wildcard = new String[nrItems];
        for (int i = 0; i < nrItems; ++i) {
            String sourceNc = this.wFields.getNonEmpty(i).getText(1);
            sourceNc = sourceNc.equals(LOCAL_ENVIRONMENT) ? "LOCAL-SOURCE-FILE-" + i : sourceNc;
            sourceNc = sourceNc.equals(STATIC_ENVIRONMENT) ? "STATIC-SOURCE-FILE-" + i : sourceNc;
            String source = this.wFields.getNonEmpty(i).getText(2);
            String wild = this.wFields.getNonEmpty(i).getText(3);
            String destNc = this.wFields.getNonEmpty(i).getText(4);
            destNc = destNc.equals(LOCAL_ENVIRONMENT) ? "LOCAL-DEST-FILE-" + i : destNc;
            destNc = destNc.equals(STATIC_ENVIRONMENT) ? "STATIC-DEST-FILE-" + i : destNc;
            String dest = this.wFields.getNonEmpty(i).getText(5);
            source = "EMPTY_SOURCE_URL-" + i + "-" + source;
            dest = "EMPTY_DEST_URL-" + i + "-" + dest;
            this.action.sourceFileFolder[i] = this.action.loadURL(source, sourceNc, this.getMetadataProvider(), sourceDestinationMappings);
            this.action.destinationFileFolder[i] = this.action.loadURL(dest, destNc, this.getMetadataProvider(), sourceDestinationMappings);
            this.action.wildcard[i] = wild;
        }
        this.action.setConfigurationMappings(sourceDestinationMappings);
        this.dispose();
    }

    public boolean showFileButtons() {
        return true;
    }

    protected void setComboValues(ColumnInfo colInfo) {
        String[] values = new String[]{LOCAL_ENVIRONMENT, STATIC_ENVIRONMENT};
        colInfo.setComboValues(values);
    }
}

