/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.pgpverify;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.pgpencryptfiles.GPG;
import org.w3c.dom.Node;

@Action(id="PGP_VERIFY_FILES", name="i18n::ActionPGPVerify.Name", description="i18n::ActionPGPVerify.Description", image="PGPVerify.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileEncryption", documentationUrl="/workflow/actions/pgpverify.html")
public class ActionPGPVerify
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionPGPVerify.class;
    private String gpgLocation = null;
    private String filename = null;
    private String detachedfilename = null;
    private boolean useDetachedSignature = false;

    public ActionPGPVerify(String n) {
        super(n, "");
    }

    public ActionPGPVerify() {
        this("");
    }

    public Object clone() {
        ActionPGPVerify je = (ActionPGPVerify)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(100);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"gpglocation", (String)this.gpgLocation));
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"detachedfilename", (String)this.detachedfilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"useDetachedSignature", (boolean)this.useDetachedSignature));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.gpgLocation = XmlHandler.getTagValue((Node)entrynode, (String)"gpglocation");
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.detachedfilename = XmlHandler.getTagValue((Node)entrynode, (String)"detachedfilename");
            this.useDetachedSignature = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"useDetachedSignature"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionPGPVerify.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    public void setGPGLocation(String gpgLocation) {
        this.gpgLocation = gpgLocation;
    }

    public String getGPGLocation() {
        return this.gpgLocation;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setDetachedfilename(String detachedfilename) {
        this.detachedfilename = detachedfilename;
    }

    public String getDetachedfilename() {
        return this.detachedfilename;
    }

    public void setUseDetachedfilename(boolean useDetachedSignature) {
        this.useDetachedSignature = useDetachedSignature;
    }

    public boolean useDetachedfilename() {
        return this.useDetachedSignature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        FileObject file = null;
        FileObject detachedSignature = null;
        try {
            String realFilename = this.resolve(this.getFilename());
            if (Utils.isEmpty((CharSequence)realFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionPGPVerify.FilenameMissing", (String[])new String[0]));
                Result result2 = result;
                return result2;
            }
            file = HopVfs.getFileObject((String)realFilename);
            GPG gpg = new GPG(this.resolve(this.getGPGLocation()), this.log);
            if (this.useDetachedfilename()) {
                String signature = this.resolve(this.getDetachedfilename());
                if (Utils.isEmpty((CharSequence)signature)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionPGPVerify.DetachedSignatureMissing", (String[])new String[0]));
                    Result result3 = result;
                    return result3;
                }
                detachedSignature = HopVfs.getFileObject((String)signature);
                gpg.verifyDetachedSignature(detachedSignature, file);
            } else {
                gpg.verifySignature(file);
            }
            result.setNrErrors(0L);
            result.setResult(true);
            return result;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionPGPVerify.Error", (String[])new String[0]), e);
            return result;
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
                if (detachedSignature != null) {
                    detachedSignature.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.gpgLocation)) {
            String realFileName = this.resolve(this.gpgLocation);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "gpglocation", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject;
            if (!Utils.isEmpty((CharSequence)this.gpgLocation) && (fileObject = HopVfs.getFileObject((String)variables.resolve(this.gpgLocation))).exists()) {
                this.gpgLocation = namingInterface.nameResource(fileObject, variables, true);
                return this.gpgLocation;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

