/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo;

import com.mongodb.MongoClientOptions;
import javax.net.ssl.SSLSocketFactory;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoPropToOption;
import org.apache.hop.mongo.MongoProperties;

public enum MongoProp {
    AUTH_DATABASE,
    USERNAME,
    PASSWORD,
    USE_KERBEROS,
    HOP_JAAS_AUTH_MODE,
    HOP_JAAS_KEYTAB_FILE,
    DBNAME,
    HOST,
    PORT,
    JOURNALED,
    USE_ALL_REPLICA_SET_MEMBERS,
    connectionsPerHost{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.connectionsPerHost(propToOption.intValue(props.get(connectionsPerHost), 100));
        }
    }
    ,
    connectTimeout{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.connectTimeout(propToOption.intValue(props.get(connectTimeout), 10000));
        }
    }
    ,
    maxWaitTime{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.maxWaitTime(propToOption.intValue(props.get(maxWaitTime), 120000));
        }
    }
    ,
    cursorFinalizerEnabled{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.cursorFinalizerEnabled(propToOption.boolValue(props.get(cursorFinalizerEnabled), true));
        }
    }
    ,
    socketKeepAlive{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.socketKeepAlive(propToOption.boolValue(props.get(socketKeepAlive), false));
        }
    }
    ,
    socketTimeout{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            builder.socketTimeout(propToOption.intValue(props.get(socketTimeout), 0));
        }
    }
    ,
    useSSL{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) {
            if ("true".equalsIgnoreCase(props.get(useSSL))) {
                builder.socketFactory(SSLSocketFactory.getDefault());
            }
        }
    }
    ,
    readPreference{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) throws MongoDbException {
            builder.readPreference(propToOption.readPrefValue(props));
        }
    }
    ,
    tagSet,
    writeConcern{

        @Override
        public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) throws MongoDbException {
            builder.writeConcern(propToOption.writeConcernValue(props));
        }
    }
    ,
    wTimeout,
    AUTH_MECHA;


    public void setOption(MongoClientOptions.Builder builder, MongoProperties props, MongoPropToOption propToOption) throws MongoDbException {
    }
}

