/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.randomvalue;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValue;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueData;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueMetaFunction;
import org.w3c.dom.Node;

@Transform(id="RandomValue", image="randomvalue.svg", name="i18n::BaseTransform.TypeTooltipDesc.RandomValue", description="i18n::BaseTransform.TypeLongDesc.RandomValue", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/generaterandomvalue.html")
public class RandomValueMeta
extends BaseTransformMeta
implements ITransformMeta<RandomValue, RandomValueData> {
    private static final Class<?> PKG = RandomValueMeta.class;
    public static final int TYPE_RANDOM_NONE = 0;
    public static final int TYPE_RANDOM_NUMBER = 1;
    public static final int TYPE_RANDOM_INTEGER = 2;
    public static final int TYPE_RANDOM_STRING = 3;
    public static final int TYPE_RANDOM_UUID = 4;
    public static final int TYPE_RANDOM_UUID4 = 5;
    public static final int TYPE_RANDOM_MAC_HMACMD5 = 6;
    public static final int TYPE_RANDOM_MAC_HMACSHA1 = 7;
    protected static final RandomValueMetaFunction[] functions = new RandomValueMetaFunction[]{null, new RandomValueMetaFunction(1, "random number", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomNumber", (String[])new String[0])), new RandomValueMetaFunction(2, "random integer", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomInteger", (String[])new String[0])), new RandomValueMetaFunction(3, "random string", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomString", (String[])new String[0])), new RandomValueMetaFunction(4, "random uuid", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID", (String[])new String[0])), new RandomValueMetaFunction(5, "random uuid4", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID4", (String[])new String[0])), new RandomValueMetaFunction(6, "random machmacmd5", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACMD5", (String[])new String[0])), new RandomValueMetaFunction(7, "random machmacsha1", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA1", (String[])new String[0]))};
    private String[] fieldName;
    private int[] fieldType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new int[count];
    }

    public Object clone() {
        RandomValueMeta retval = (RandomValueMeta)((Object)super.clone());
        int count = this.fieldName.length;
        retval.allocate(count);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, count);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, count);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                String type = XmlHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldType[i] = RandomValueMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read transform information from XML", (Throwable)e);
        }
    }

    public static final int getType(String type) {
        for (int i = 1; i < functions.length; ++i) {
            if (functions[i].getCode().equalsIgnoreCase(type)) {
                return i;
            }
            if (!functions[i].getDescription().equalsIgnoreCase(type)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int t) {
        if (t < 0 || t >= functions.length || functions[t] == null) {
            return null;
        }
        return functions[t].getDescription();
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 1;
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMetaNone v;
            switch (this.fieldType[i]) {
                case 1: {
                    v = new ValueMetaNumber(this.fieldName[i], 10, 5);
                    break;
                }
                case 2: {
                    v = new ValueMetaInteger(this.fieldName[i], 10, 0);
                    break;
                }
                case 3: {
                    v = new ValueMetaString(this.fieldName[i], 13, 0);
                    break;
                }
                case 4: {
                    v = new ValueMetaString(this.fieldName[i], 36, 0);
                    break;
                }
                case 5: {
                    v = new ValueMetaString(this.fieldName[i], 36, 0);
                    break;
                }
                case 6: {
                    v = new ValueMetaString(this.fieldName[i], 100, 0);
                    break;
                }
                case 7: {
                    v = new ValueMetaString(this.fieldName[i], 100, 0);
                    break;
                }
                default: {
                    v = new ValueMetaNone(this.fieldName[i]);
                }
            }
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)(functions[this.fieldType[i]] != null ? functions[this.fieldType[i]].getCode() : "")));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldType[i] > 0) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.FieldHasNoType", (String[])new String[]{this.fieldName[i]}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, RandomValueData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new RandomValue(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public RandomValueData getTransformData() {
        return new RandomValueData();
    }
}

