/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.randomvalue;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Uuid4Util;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueData;
import org.apache.hop.pipeline.transforms.randomvalue.RandomValueMeta;

public class RandomValue
extends BaseTransform<RandomValueMeta, RandomValueData>
implements ITransform<RandomValueMeta, RandomValueData> {
    private static final Class<?> PKG = RandomValueMeta.class;

    public RandomValue(TransformMeta transformMeta, RandomValueMeta meta, RandomValueData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] getRandomValue(IRowMeta inputRowMeta, Object[] inputRowData) {
        int i;
        Object[] row = new Object[((RandomValueData)this.data).outputRowMeta.size()];
        for (i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        i = 0;
        int index = inputRowMeta.size();
        while (i < ((RandomValueMeta)this.meta).getFieldName().length) {
            switch (((RandomValueMeta)this.meta).getFieldType()[i]) {
                case 1: {
                    row[index] = ((RandomValueData)this.data).randomgen.nextDouble();
                    break;
                }
                case 2: {
                    row[index] = (long)((RandomValueData)this.data).randomgen.nextInt();
                    break;
                }
                case 3: {
                    row[index] = Long.toString(Math.abs(((RandomValueData)this.data).randomgen.nextLong()), 32);
                    break;
                }
                case 4: {
                    row[index] = UUID.randomUUID().toString();
                    break;
                }
                case 5: {
                    row[index] = ((RandomValueData)this.data).u4.getUUID4AsString();
                    break;
                }
                case 6: {
                    try {
                        row[index] = this.generateRandomMACHash(6);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACMD5", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
                case 7: {
                    try {
                        row[index] = this.generateRandomMACHash(7);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.ErrorGettingRandomHMACSHA1", (String[])new String[]{e.getMessage()}));
                        this.setErrors(1L);
                        this.stopAll();
                    }
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    private String generateRandomMACHash(int algorithm) throws Exception {
        Key sk = null;
        switch (algorithm) {
            case 6: {
                sk = ((RandomValueData)this.data).keyGenHmacMD5.generateKey();
                break;
            }
            case 7: {
                sk = ((RandomValueData)this.data).keyGenHmacSHA1.generateKey();
                break;
            }
        }
        if (sk == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"RandomValue.Log.SecretKeyNull", (String[])new String[0]));
        }
        Mac mac = Mac.getInstance(sk.getAlgorithm());
        mac.init(sk);
        byte[] hashCode = mac.doFinal();
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < hashCode.length; ++i) {
            String b = Integer.toHexString(hashCode[i]);
            if (b.length() == 1) {
                b = "0" + b;
            }
            encoded.append(b.substring(b.length() - 2));
        }
        return encoded.toString();
    }

    public boolean processRow() throws HopException {
        IRowMeta imeta;
        Object[] row;
        if (((RandomValueData)this.data).readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((RandomValueData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((RandomValueMeta)this.meta).getFields(((RandomValueData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                ((RandomValueData)this.data).outputRowMeta = new RowMeta();
                ((RandomValueMeta)this.meta).getFields(((RandomValueData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getRandomValue(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"RandomValue.Log.ValueReturned", (String[])new String[]{((RandomValueData)this.data).outputRowMeta.getString(row)}));
        }
        this.putRow(((RandomValueData)this.data).outputRowMeta, row);
        if (!((RandomValueData)this.data).readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            List previous = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
            if (previous != null && !previous.isEmpty()) {
                ((RandomValueData)this.data).readsRows = true;
            }
            boolean genHmacMD5 = false;
            boolean genHmacSHA1 = false;
            boolean uuid4 = false;
            block9: for (int i = 0; i < ((RandomValueMeta)this.meta).getFieldName().length; ++i) {
                switch (((RandomValueMeta)this.meta).getFieldType()[i]) {
                    case 6: {
                        genHmacMD5 = true;
                        continue block9;
                    }
                    case 7: {
                        genHmacSHA1 = true;
                        continue block9;
                    }
                    case 5: {
                        uuid4 = true;
                        continue block9;
                    }
                }
            }
            if (genHmacMD5) {
                try {
                    ((RandomValueData)this.data).keyGenHmacMD5 = KeyGenerator.getInstance("HmacMD5");
                }
                catch (NoSuchAlgorithmException s) {
                    this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacMD5AlgorithmException", (String[])new String[]{s.getMessage()}));
                    return false;
                }
            }
            if (genHmacSHA1) {
                try {
                    ((RandomValueData)this.data).keyGenHmacSHA1 = KeyGenerator.getInstance("HmacSHA1");
                }
                catch (NoSuchAlgorithmException s) {
                    this.logError(BaseMessages.getString(PKG, (String)"RandomValue.Log.HmacSHA1AlgorithmException", (String[])new String[]{s.getMessage()}));
                    return false;
                }
            }
            if (uuid4) {
                ((RandomValueData)this.data).u4 = new Uuid4Util();
            }
            return true;
        }
        return false;
    }
}

