/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeinput;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInput;
import org.apache.hop.pipeline.transforms.cubeinput.CubeInputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="CubeInput", image="cubeinput.svg", name="i18n::CubeInput.Name", description="i18n::CubeInput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/cubeinput.html")
public class CubeInputMeta
extends BaseTransformMeta
implements ITransformMeta<CubeInput, CubeInputData> {
    private static final Class<?> PKG = CubeInputMeta.class;
    private String filename;
    private String rowLimit;
    private boolean addfilenameresult;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public boolean isAddResultFile() {
        return this.addfilenameresult;
    }

    public void setAddResultFile(boolean addfilenameresult) {
        this.addfilenameresult = addfilenameresult;
    }

    public Object clone() {
        CubeInputMeta retval = (CubeInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.filename = XmlHandler.getTagValue((Node)transformNode, (String)"file", (String)"name");
            this.rowLimit = XmlHandler.getTagValue((Node)transformNode, (String)"limit");
            this.addfilenameresult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"addfilenameresult"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.filename = "file";
        this.rowLimit = "0";
        this.addfilenameresult = false;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        GZIPInputStream fis = null;
        FilterInputStream dis = null;
        try {
            InputStream is = HopVfs.getInputStream((String)variables.resolve(this.filename));
            fis = new GZIPInputStream(is);
            dis = new DataInputStream(fis);
            RowMeta add = new RowMeta((DataInputStream)dis);
            for (int i = 0; i < add.size(); ++i) {
                add.getValueMeta(i).setOrigin(name);
            }
            r.mergeRowMeta((IRowMeta)add);
        }
        catch (HopFileException kfe) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToReadMetaData", (String[])new String[0]), (Throwable)kfe);
        }
        catch (IOException e) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.ErrorOpeningOrReadingCubeFile", (String[])new String[0]), (Throwable)e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException ioe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CubeInputMeta.Exception.UnableToCloseCubeFile", (String[])new String[0]), (Throwable)ioe);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.filename));
        retval.append("    </file>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (String)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"addfilenameresult", (boolean)this.addfilenameresult));
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"CubeInputMeta.CheckResult.FileSpecificationsNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public CubeInput createTransform(TransformMeta transformMeta, CubeInputData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new CubeInput(transformMeta, this, data, cnr, tr, pipeline);
    }

    public CubeInputData getTransformData() {
        return new CubeInputData();
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.filename));
            if (fileObject.exists()) {
                this.filename = iResourceNaming.nameResource(fileObject, variables, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

