/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.joinrows;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.joinrows.JoinRowsData;
import org.apache.hop.pipeline.transforms.joinrows.JoinRowsMeta;

public class JoinRows
extends BaseTransform<JoinRowsMeta, JoinRowsData>
implements ITransform<JoinRowsMeta, JoinRowsData> {
    private static final Class<?> PKG = JoinRowsMeta.class;

    public JoinRows(TransformMeta transformMeta, JoinRowsMeta meta, JoinRowsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public void initialize() throws HopException {
        try {
            ((JoinRowsData)this.data).caching = true;
            ((JoinRowsData)this.data).filenr = 1;
            this.swapFirstInputRowSetIfExists(((JoinRowsMeta)this.meta).getMainTransformName());
            List inputRowSets = this.getInputRowSets();
            int rowSetsSize = inputRowSets.size();
            ((JoinRowsData)this.data).file = new File[rowSetsSize];
            ((JoinRowsData)this.data).fileInputStream = new FileInputStream[rowSetsSize];
            ((JoinRowsData)this.data).dataInputStream = new DataInputStream[rowSetsSize];
            ((JoinRowsData)this.data).size = new int[rowSetsSize];
            ((JoinRowsData)this.data).fileRowMeta = new IRowMeta[rowSetsSize];
            ((JoinRowsData)this.data).joinrow = new Object[rowSetsSize][];
            ((JoinRowsData)this.data).rs = new IRowSet[rowSetsSize];
            ((JoinRowsData)this.data).cache = new List[rowSetsSize];
            ((JoinRowsData)this.data).position = new int[rowSetsSize];
            ((JoinRowsData)this.data).fileOutputStream = new FileOutputStream[rowSetsSize];
            ((JoinRowsData)this.data).dataOutputStream = new DataOutputStream[rowSetsSize];
            ((JoinRowsData)this.data).restart = new boolean[rowSetsSize];
            for (int i = 1; i < rowSetsSize; ++i) {
                String directoryName = this.resolve(((JoinRowsMeta)this.meta).getDirectory());
                File file = null;
                if (directoryName != null) {
                    file = new File(directoryName);
                }
                ((JoinRowsData)this.data).file[i] = File.createTempFile(((JoinRowsMeta)this.meta).getPrefix(), ".tmp", file);
                ((JoinRowsData)this.data).size[i] = 0;
                ((JoinRowsData)this.data).rs[i] = (IRowSet)inputRowSets.get(i);
                ((JoinRowsData)this.data).cache[i] = null;
                ((JoinRowsData)this.data).position[i] = 0;
                ((JoinRowsData)this.data).dataInputStream[i] = null;
                ((JoinRowsData)this.data).dataOutputStream[i] = null;
                ((JoinRowsData)this.data).joinrow[i] = null;
                ((JoinRowsData)this.data).restart[i] = false;
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"JoinRows.Log.ErrorCreatingTemporaryFiles", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object[] getRowData(int filenr) throws HopException {
        ((JoinRowsData)this.data).restart[filenr] = false;
        Object[] rowData = null;
        if (filenr == 0) {
            IRowSet rowSet = this.getFirstInputRowSet();
            rowData = this.getRowFrom(rowSet);
            if (rowData != null) {
                ((JoinRowsData)this.data).fileRowMeta[0] = rowSet.getRowMeta();
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"JoinRows.Log.ReadRowFromStream", (String[])new String[0]) + (rowData == null ? "<null>" : ((JoinRowsData)this.data).fileRowMeta[0].getString(rowData)));
            }
        } else if (((JoinRowsData)this.data).cache[filenr] == null) {
            if (((JoinRowsData)this.data).dataInputStream[filenr] == null) {
                try {
                    ((JoinRowsData)this.data).fileInputStream[filenr] = new FileInputStream(((JoinRowsData)this.data).file[filenr]);
                    ((JoinRowsData)this.data).dataInputStream[filenr] = new DataInputStream(((JoinRowsData)this.data).fileInputStream[filenr]);
                }
                catch (FileNotFoundException fnfe) {
                    this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToFindOrOpenTemporaryFile", (String[])new String[0]) + ((JoinRowsData)this.data).file[filenr] + "] : " + fnfe.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
            if (((JoinRowsData)this.data).size[filenr] == 0) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JoinRows.Log.NoRowsComingFromTransform", (String[])new String[0]) + ((JoinRowsData)this.data).rs[filenr].getOriginTransformName() + "]");
                }
                return null;
            }
            try {
                rowData = ((JoinRowsData)this.data).fileRowMeta[filenr].readData(((JoinRowsData)this.data).dataInputStream[filenr]);
            }
            catch (HopFileException e) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToReadDataFromTempFile", (String[])new String[0]) + filenr + " [" + ((JoinRowsData)this.data).file[filenr] + "]");
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            catch (SocketTimeoutException e) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToReadDataFromTempFile", (String[])new String[0]) + filenr + " [" + ((JoinRowsData)this.data).file[filenr] + "]");
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"JoinRows.Log.ReadRowFromFile", (String[])new String[0]) + filenr + " : " + ((JoinRowsData)this.data).fileRowMeta[filenr].getString(rowData));
            }
            int n = filenr;
            ((JoinRowsData)this.data).position[n] = ((JoinRowsData)this.data).position[n] + 1;
            if (((JoinRowsData)this.data).position[filenr] >= ((JoinRowsData)this.data).size[filenr]) {
                try {
                    ((JoinRowsData)this.data).dataInputStream[filenr].close();
                    ((JoinRowsData)this.data).fileInputStream[filenr].close();
                    ((JoinRowsData)this.data).dataInputStream[filenr] = null;
                    ((JoinRowsData)this.data).fileInputStream[filenr] = null;
                    ((JoinRowsData)this.data).position[filenr] = 0;
                    ((JoinRowsData)this.data).restart[filenr] = true;
                }
                catch (IOException ioe) {
                    this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToCloseInputStream", (String[])new String[0]) + ((JoinRowsData)this.data).file[filenr] + "] : " + ioe.toString());
                    this.setErrors(1L);
                    this.stopAll();
                    return null;
                }
            }
        } else {
            if (((JoinRowsData)this.data).size[filenr] == 0) {
                if (this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"JoinRows.Log.NoRowsComingFromTransform", (String[])new String[0]) + ((JoinRowsData)this.data).rs[filenr].getOriginTransformName() + "]");
                }
                return null;
            }
            rowData = ((JoinRowsData)this.data).cache[filenr].get(((JoinRowsData)this.data).position[((JoinRowsData)this.data).filenr]);
            rowData = ((JoinRowsData)this.data).fileRowMeta[filenr].cloneRow(rowData);
            int n = filenr;
            ((JoinRowsData)this.data).position[n] = ((JoinRowsData)this.data).position[n] + 1;
            if (((JoinRowsData)this.data).position[filenr] >= ((JoinRowsData)this.data).size[filenr]) {
                ((JoinRowsData)this.data).position[filenr] = 0;
                ((JoinRowsData)this.data).restart[filenr] = true;
            }
        }
        return rowData;
    }

    public boolean processRow() throws HopException {
        if (this.first) {
            this.first = false;
            this.initialize();
        }
        return !(((JoinRowsData)this.data).caching ? !this.cacheInputRow() : !this.outputRow());
    }

    private boolean outputRow() throws HopException {
        ((JoinRowsData)this.data).joinrow[((JoinRowsData)this.data).filenr] = this.getRowData(((JoinRowsData)this.data).filenr);
        if (((JoinRowsData)this.data).joinrow[((JoinRowsData)this.data).filenr] == null) {
            while (this.getRow() != null && !this.isStopped()) {
            }
            this.setOutputDone();
            return false;
        }
        if (((JoinRowsData)this.data).filenr >= ((JoinRowsData)this.data).file.length - 1) {
            if (((JoinRowsData)this.data).outputRowMeta == null) {
                ((JoinRowsData)this.data).outputRowMeta = this.createOutputRowMeta(((JoinRowsData)this.data).fileRowMeta);
            }
            Object[] sum = new Object[((JoinRowsData)this.data).outputRowMeta.size()];
            int sumIndex = 0;
            for (int f = 0; f <= ((JoinRowsData)this.data).filenr; ++f) {
                for (int c = 0; c < ((JoinRowsData)this.data).fileRowMeta[f].size(); ++c) {
                    sum[sumIndex] = ((JoinRowsData)this.data).joinrow[f][c];
                    ++sumIndex;
                }
            }
            if (((JoinRowsMeta)this.meta).getCondition() != null && !((JoinRowsMeta)this.meta).getCondition().isEmpty()) {
                if (((JoinRowsMeta)this.meta).getCondition().evaluate(((JoinRowsData)this.data).outputRowMeta, sum)) {
                    this.putRow(((JoinRowsData)this.data).outputRowMeta, sum);
                }
            } else {
                this.putRow(((JoinRowsData)this.data).outputRowMeta, sum);
            }
            while (((JoinRowsData)this.data).restart[((JoinRowsData)this.data).filenr]) {
                --((JoinRowsData)this.data).filenr;
            }
        } else {
            ++((JoinRowsData)this.data).filenr;
        }
        return true;
    }

    private boolean cacheInputRow() throws HopException {
        IRowSet rowSet;
        Object[] rowData;
        if (((JoinRowsData)this.data).filenr >= ((JoinRowsData)this.data).file.length) {
            ((JoinRowsData)this.data).caching = false;
            ((JoinRowsData)this.data).filenr = 0;
            return true;
        }
        if (((JoinRowsData)this.data).dataOutputStream[((JoinRowsData)this.data).filenr] == null) {
            try {
                ((JoinRowsData)this.data).fileOutputStream[((JoinRowsData)this.data).filenr] = new FileOutputStream(((JoinRowsData)this.data).file[((JoinRowsData)this.data).filenr]);
                ((JoinRowsData)this.data).dataOutputStream[((JoinRowsData)this.data).filenr] = new DataOutputStream(((JoinRowsData)this.data).fileOutputStream[((JoinRowsData)this.data).filenr]);
            }
            catch (FileNotFoundException fnfe) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.UnableToOpenOutputstream", (String[])new String[0]) + ((JoinRowsData)this.data).file[((JoinRowsData)this.data).filenr].toString() + "] : " + fnfe.toString());
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
        }
        if ((rowData = this.getRowFrom(rowSet = ((JoinRowsData)this.data).rs[((JoinRowsData)this.data).filenr])) != null) {
            if (((JoinRowsData)this.data).fileRowMeta[((JoinRowsData)this.data).filenr] == null) {
                ((JoinRowsData)this.data).fileRowMeta[((JoinRowsData)this.data).filenr] = rowSet.getRowMeta().clone();
            }
            ((JoinRowsData)this.data).fileRowMeta[((JoinRowsData)this.data).filenr].writeData(((JoinRowsData)this.data).dataOutputStream[((JoinRowsData)this.data).filenr], rowData);
            int n = ((JoinRowsData)this.data).filenr;
            ((JoinRowsData)this.data).size[n] = ((JoinRowsData)this.data).size[n] + 1;
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"JoinRows.Log.ReadRowFromStreamN", (Object[])new Object[]{((JoinRowsData)this.data).filenr, ((JoinRowsData)this.data).fileRowMeta[((JoinRowsData)this.data).filenr].getString(rowData)}));
            }
            if (((JoinRowsData)this.data).size[((JoinRowsData)this.data).filenr] <= ((JoinRowsMeta)this.meta).getCacheSize()) {
                if (((JoinRowsData)this.data).cache[((JoinRowsData)this.data).filenr] == null) {
                    ((JoinRowsData)this.data).cache[((JoinRowsData)this.data).filenr] = new ArrayList<Object[]>();
                }
                ((JoinRowsData)this.data).cache[((JoinRowsData)this.data).filenr].add(rowData);
            } else {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JoinRows.Log.RowsFound", (String[])new String[]{((JoinRowsMeta)this.meta).getCacheSize() + "", ((JoinRowsData)this.data).rs[((JoinRowsData)this.data).filenr].getOriginTransformName()}));
                }
                ((JoinRowsData)this.data).cache[((JoinRowsData)this.data).filenr] = null;
            }
        } else {
            try {
                ((JoinRowsData)this.data).dataOutputStream[((JoinRowsData)this.data).filenr].close();
                ((JoinRowsData)this.data).fileOutputStream[((JoinRowsData)this.data).filenr].close();
                ((JoinRowsData)this.data).dataOutputStream[((JoinRowsData)this.data).filenr] = null;
                ((JoinRowsData)this.data).fileOutputStream[((JoinRowsData)this.data).filenr] = null;
            }
            catch (IOException ioe) {
                this.logError(BaseMessages.getString(PKG, (String)"JoinRows.Log.ErrorInClosingOutputStream", (String[])new String[0]) + ((JoinRowsData)this.data).filenr + " : [" + ((JoinRowsData)this.data).file[((JoinRowsData)this.data).filenr].toString() + "] : " + ioe.toString());
            }
            ++((JoinRowsData)this.data).filenr;
        }
        return true;
    }

    private IRowMeta createOutputRowMeta(IRowMeta[] fileRowMeta) {
        RowMeta outputRowMeta = new RowMeta();
        for (int i = 0; i < ((JoinRowsData)this.data).fileRowMeta.length; ++i) {
            outputRowMeta.mergeRowMeta(((JoinRowsData)this.data).fileRowMeta[i], ((JoinRowsMeta)this.meta).getName());
        }
        return outputRowMeta;
    }

    public void dispose() {
        if (((JoinRowsData)this.data).file != null) {
            for (int i = 1; i < ((JoinRowsData)this.data).file.length; ++i) {
                if (((JoinRowsData)this.data).file[i] == null) continue;
                ((JoinRowsData)this.data).file[i].delete();
            }
        }
        super.dispose();
    }

    public void batchComplete() throws HopException {
        int i;
        IRowSet rowSet = this.getFirstInputRowSet();
        int repeats = 0;
        for (i = 0; i < ((JoinRowsData)this.data).cache.length; ++i) {
            if (repeats == 0) {
                repeats = 1;
            }
            if (((JoinRowsData)this.data).cache[i] == null) continue;
            repeats *= ((JoinRowsData)this.data).cache[i].size();
        }
        while (rowSet.size() > 0 && !this.isStopped()) {
            this.init();
        }
        for (i = 0; i < repeats; ++i) {
            this.init();
        }
    }
}

