/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.util.guava;

import cc.blynk.clickhouse.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final int BUF_SIZE = 4096;

    private StreamUtils() {
    }

    public static String toString(InputStream in) throws IOException {
        return new String(StreamUtils.toByteArray(in), StandardCharsets.UTF_8);
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamUtils.copy(in, out);
        return out.toByteArray();
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        byte[] buffer = new byte[4096];
        int len = from.read(buffer);
        while (len != -1) {
            to.write(buffer, 0, len);
            len = from.read(buffer);
        }
    }

    public static void copy(Reader from, Writer to) throws IOException {
        int len;
        char[] buffer = new char[4096];
        while ((len = from.read(buffer)) >= 0) {
            to.write(buffer, 0, len);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            log.error("can not closeClient stream: {}", (Object)e.getMessage());
        }
    }

    static long longFromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    static byte[] longToByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    static int intFromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }
}

