/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.util;

import java.util.ArrayList;
import java.util.List;
import net.jpountz.lz4.LZ4Factory;

public final class Utils {
    protected static final LZ4Factory factory = LZ4Factory.fastestInstance();

    private Utils() {
    }

    public static String retainUnquoted(String haystack, char quoteChar) {
        if (haystack.isEmpty()) {
            return "";
        }
        int startIndex = haystack.indexOf(quoteChar);
        if (startIndex == -1) {
            return haystack;
        }
        StringBuilder sb = new StringBuilder();
        List<String> split = Utils.splitWithoutEscaped(haystack, startIndex, quoteChar);
        for (int i = 0; i < split.size(); i += 2) {
            String s = split.get(i);
            sb.append(s);
        }
        return sb.toString();
    }

    private static List<String> splitWithoutEscaped(String str, int start, char separatorChar) {
        ArrayList<String> list = new ArrayList<String>();
        int i = start;
        start = 0;
        int strLen = str.length();
        while (i < strLen) {
            if (str.charAt(i) == '\\') {
                i += 2;
                continue;
            }
            if (str.charAt(i) == separatorChar) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        list.add(str.substring(start, i));
        return list;
    }
}

