/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse.response;

import cc.blynk.clickhouse.response.ByteFragment;
import cc.blynk.clickhouse.response.ClickHouseResultSet;
import cc.blynk.clickhouse.settings.ClickHouseProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;

public final class ClickHouseResultBuilder {
    private final int columnsNum;
    private List<String> names;
    private List<String> types;
    private final List<List<?>> rows = new ArrayList();
    private TimeZone timezone = TimeZone.getTimeZone("UTC");
    private boolean usesWithTotals;
    private ClickHouseProperties properties = new ClickHouseProperties();

    public static ClickHouseResultBuilder builder(int columnsNum) {
        return new ClickHouseResultBuilder(columnsNum);
    }

    private ClickHouseResultBuilder(int columnsNum) {
        this.columnsNum = columnsNum;
    }

    public ClickHouseResultBuilder names(String ... names) {
        return this.names(Arrays.asList(names));
    }

    public ClickHouseResultBuilder types(String ... types) {
        return this.types(Arrays.asList(types));
    }

    public ClickHouseResultBuilder addRow(Object ... row) {
        return this.addRow(Arrays.asList(row));
    }

    public ClickHouseResultBuilder withTotals(boolean usesWithTotals) {
        this.usesWithTotals = usesWithTotals;
        return this;
    }

    public ClickHouseResultBuilder names(List<String> names) {
        if (names.size() != this.columnsNum) {
            throw new IllegalArgumentException("size mismatch, req: " + this.columnsNum + " got: " + names.size());
        }
        this.names = names;
        return this;
    }

    public ClickHouseResultBuilder types(List<String> types) {
        if (types.size() != this.columnsNum) {
            throw new IllegalArgumentException("size mismatch, req: " + this.columnsNum + " got: " + types.size());
        }
        this.types = types;
        return this;
    }

    public ClickHouseResultBuilder addRow(List<?> row) {
        if (row.size() != this.columnsNum) {
            throw new IllegalArgumentException("size mismatch, req: " + this.columnsNum + " got: " + row.size());
        }
        this.rows.add(row);
        return this;
    }

    public ClickHouseResultBuilder timeZone(TimeZone timezone) {
        this.timezone = timezone;
        return this;
    }

    public ClickHouseResultBuilder properties(ClickHouseProperties properties) {
        this.properties = properties;
        return this;
    }

    public ClickHouseResultSet build() {
        try {
            if (this.names == null) {
                throw new IllegalStateException("names == null");
            }
            if (this.types == null) {
                throw new IllegalStateException("types == null");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.appendRow(this.names, baos);
            this.appendRow(this.types, baos);
            for (List<?> row : this.rows) {
                this.appendRow(row, baos);
            }
            byte[] bytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            return new ClickHouseResultSet(inputStream, 1024, "system", "unknown", this.usesWithTotals, null, this.timezone, this.properties);
        }
        catch (IOException e) {
            throw new RuntimeException("Never happens", e);
        }
    }

    private void appendRow(List<?> row, ByteArrayOutputStream baos) throws IOException {
        for (int i = 0; i < row.size(); ++i) {
            if (i != 0) {
                baos.write(9);
            }
            this.appendObject(row.get(i), baos);
        }
        baos.write(10);
    }

    private void appendObject(Object o, ByteArrayOutputStream baos) throws IOException {
        if (o == null) {
            baos.write(92);
            baos.write(78);
        } else {
            String value = o instanceof Boolean ? (((Boolean)o).booleanValue() ? "1" : "0") : o.toString();
            ByteFragment.escape(value.getBytes(StandardCharsets.UTF_8), baos);
        }
    }
}

