/*
 * Decompiled with CFR 0.152.
 */
package cc.blynk.clickhouse;

import cc.blynk.clickhouse.ClickHouseConnection;
import cc.blynk.clickhouse.ClickHouseExternalData;
import cc.blynk.clickhouse.ClickHouseStatement;
import cc.blynk.clickhouse.ClickHouseUtil;
import cc.blynk.clickhouse.domain.ClickHouseFormat;
import cc.blynk.clickhouse.except.ClickHouseException;
import cc.blynk.clickhouse.except.ClickHouseExceptionSpecifier;
import cc.blynk.clickhouse.http.HttpConnector;
import cc.blynk.clickhouse.response.AbstractResultSet;
import cc.blynk.clickhouse.response.ClickHouseJsonResultSet;
import cc.blynk.clickhouse.response.ClickHouseResultSet;
import cc.blynk.clickhouse.response.ClickHouseScrollableResultSet;
import cc.blynk.clickhouse.settings.ClickHouseProperties;
import cc.blynk.clickhouse.settings.ClickHouseQueryParam;
import cc.blynk.clickhouse.util.ClickHouseRowBinaryInputStream;
import cc.blynk.clickhouse.util.ClickHouseRowBinaryStream;
import cc.blynk.clickhouse.util.ClickHouseStreamCallback;
import cc.blynk.clickhouse.util.Utils;
import cc.blynk.clickhouse.util.guava.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseStatementImpl
implements ClickHouseStatement {
    private static final Logger log = LoggerFactory.getLogger(ClickHouseStatementImpl.class);
    final HttpConnector httpConnector;
    protected final ClickHouseProperties properties;
    private final ClickHouseConnection connection;
    private AbstractResultSet currentResult;
    private ClickHouseRowBinaryInputStream currentRowBinaryResult;
    private int currentUpdateCount = -1;
    private int queryTimeout = -1;
    private int maxRows;
    private boolean closeOnCompletion;
    private final boolean isResultSetScrollable;
    private volatile String queryId;
    private Boolean isSelect;
    private ClickHouseFormat selectFormat;
    private final String initialDatabase;
    private static final String[] selectKeywords = new String[]{"SELECT", "WITH", "SHOW", "DESC", "EXISTS"};
    private static final String databaseKeyword = "CREATE DATABASE";

    ClickHouseStatementImpl(HttpConnector connector, ClickHouseConnection connection, ClickHouseProperties properties, int resultSetType) {
        this.connection = connection;
        this.properties = properties == null ? new ClickHouseProperties() : properties;
        this.initialDatabase = this.properties.getDatabase();
        this.isResultSetScrollable = resultSetType != 1003;
        this.httpConnector = connector;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    String addFormat(String cleanSQL, ClickHouseFormat format) {
        StringBuilder sb = new StringBuilder();
        int idx = cleanSQL.endsWith(";") ? cleanSQL.length() - 1 : cleanSQL.length();
        sb.append(cleanSQL, 0, idx).append(" FORMAT ").append(format.name());
        return sb.toString();
    }

    boolean isSelect(String sql) {
        if (this.isSelect == null) {
            this.isSelect = ClickHouseStatementImpl.detectQueryType(sql);
        }
        return this.isSelect;
    }

    private static boolean detectQueryType(String sql) {
        for (int i = 0; i < sql.length(); ++i) {
            String nextTwo = sql.substring(i, Math.min(i + 2, sql.length()));
            if ("--".equals(nextTwo)) {
                i = Math.max(i, sql.indexOf("\n", i));
                continue;
            }
            if ("/*".equals(nextTwo)) {
                i = Math.max(i, sql.indexOf("*/", i));
                continue;
            }
            if (!Character.isLetter(sql.charAt(i))) continue;
            String trimmed = sql.substring(i, Math.min(sql.length(), Math.max(i, sql.indexOf(" ", i))));
            for (String keyword : selectKeywords) {
                if (!trimmed.regionMatches(true, 0, keyword, 0, keyword.length())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQuery(sql, additionalDBParams, null);
    }

    @Override
    public ClickHouseRowBinaryInputStream executeQueryClickhouseRowBinaryStream(String sql) throws SQLException {
        return this.executeQueryClickhouseRowBinaryStream(sql, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData) throws SQLException {
        return this.executeQuery(sql, additionalDBParams, externalData, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws SQLException {
        InputStream is = this.sendRequest(sql, additionalDBParams, externalData, additionalRequestParams);
        try {
            if (this.isSelect.booleanValue()) {
                this.currentUpdateCount = -1;
                this.currentResult = this.createResultSet(is, this.properties.getBufferSize(), this.extractDBName(sql), this.extractTableName(sql), this.extractWithTotals(sql), this, this.getConnection().getTimeZone(), this.properties);
                this.currentResult.setMaxRows(this.maxRows);
                return this.currentResult;
            }
            this.currentUpdateCount = 0;
            StreamUtils.close(is);
            return null;
        }
        catch (Exception e) {
            StreamUtils.close(is);
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try (InputStream is = this.sendRequest(sql, null, null, null);){
            StreamUtils.toByteArray(is);
        }
        catch (IOException ioe) {
            log.error("Error on executeUpdate() for {}.", (Object)sql, (Object)ioe);
        }
        return 1;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeQuery(sql);
        return this.isSelect(sql);
    }

    @Override
    public void close() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
        }
        if (this.currentRowBinaryResult != null) {
            StreamUtils.close(this.currentRowBinaryResult);
        }
    }

    @Override
    public int getMaxFieldSize() {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) {
    }

    @Override
    public int getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException(String.format("Illegal maxRows value: %d", max));
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.queryTimeout = seconds;
    }

    @Override
    public ClickHouseRowBinaryInputStream executeQueryClickhouseRowBinaryStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws SQLException {
        return this.executeQueryClickhouseRowBinaryStream(sql, additionalDBParams, null);
    }

    @Override
    public void cancel() throws SQLException {
        if (this.queryId != null && !this.isClosed()) {
            this.executeQuery("KILL QUERY WHERE query_id='" + this.queryId + "'");
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void setCursorName(String name) {
    }

    @Override
    public ResultSet getResultSet() {
        return this.currentResult;
    }

    @Override
    public int getUpdateCount() {
        return this.currentUpdateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.currentResult != null) {
            this.currentResult.close();
            this.currentResult = null;
        }
        this.currentUpdateCount = -1;
        return false;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchDirection() {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() {
        return 0;
    }

    @Override
    public int getResultSetType() {
        return 0;
    }

    @Override
    public void addBatch(String sql) {
    }

    @Override
    public void clearBatch() {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return new int[0];
    }

    @Override
    public ClickHouseConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) {
        return false;
    }

    @Override
    public int getResultSetHoldability() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) {
    }

    @Override
    public boolean isPoolable() {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public ClickHouseRowBinaryInputStream executeQueryClickhouseRowBinaryStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, Map<String, String> additionalRequestParams) throws SQLException {
        String cleanSql = sql.trim();
        this.isSelect = ClickHouseStatementImpl.detectQueryType(cleanSql);
        this.selectFormat = ClickHouseFormat.detectFormat(cleanSql);
        if (this.isSelect.booleanValue() && this.selectFormat == null) {
            cleanSql = this.addFormat(cleanSql, ClickHouseFormat.RowBinary);
        }
        InputStream is = this.sendRequest(cleanSql, additionalDBParams, null, additionalRequestParams);
        try {
            if (this.isSelect.booleanValue()) {
                this.currentUpdateCount = -1;
                this.currentRowBinaryResult = new ClickHouseRowBinaryInputStream(is, this.getConnection().getTimeZone(), this.properties);
                return this.currentRowBinaryResult;
            }
            this.currentUpdateCount = 0;
            StreamUtils.close(is);
            return null;
        }
        catch (Exception e) {
            StreamUtils.close(is);
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    private String extractTableName(String sql) {
        String s = this.extractDBAndTableName(sql);
        if (s.contains(".")) {
            return s.substring(s.indexOf(".") + 1);
        }
        return s;
    }

    private String extractDBName(String sql) {
        String s = this.extractDBAndTableName(sql);
        if (s.contains(".")) {
            return s.substring(0, s.indexOf("."));
        }
        return this.properties.getDatabase();
    }

    private String extractDBAndTableName(String sql) {
        if (sql.regionMatches(true, 0, "select", 0, "select".length())) {
            String withoutStrings = Utils.retainUnquoted(sql, '\'');
            int fromIndex = withoutStrings.indexOf("from");
            if (fromIndex == -1) {
                fromIndex = withoutStrings.indexOf("FROM");
            }
            if (fromIndex != -1) {
                String fromFrom = withoutStrings.substring(fromIndex);
                String fromTable = fromFrom.substring("from".length()).trim();
                return fromTable.split(" ")[0];
            }
        }
        if (sql.regionMatches(true, 0, "desc", 0, "desc".length())) {
            return "system.columns";
        }
        if (sql.regionMatches(true, 0, "show", 0, "show".length())) {
            return "system.tables";
        }
        return "system.unknown";
    }

    private boolean extractWithTotals(String sql) {
        if (sql.regionMatches(true, 0, "select", 0, "select".length())) {
            String withoutStrings = Utils.retainUnquoted(sql, '\'');
            return withoutStrings.toLowerCase().contains(" with totals");
        }
        return false;
    }

    @Override
    public void sendRowBinaryStream(String sql, ClickHouseStreamCallback callback) throws SQLException {
        this.sendRowBinaryStream(sql, null, callback);
    }

    @Override
    public void sendRowBinaryStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, ClickHouseStreamCallback callback) throws SQLException {
        URI uri = this.buildRequestUri(null, null, additionalDBParams, null, false);
        sql = sql + " FORMAT " + (Object)((Object)ClickHouseFormat.RowBinary);
        this.sendStream(sql, callback, uri);
    }

    @Override
    public void sendNativeStream(String sql, ClickHouseStreamCallback callback) throws SQLException {
        this.sendNativeStream(sql, null, callback);
    }

    @Override
    public void sendNativeStream(String sql, Map<ClickHouseQueryParam, String> additionalDBParams, ClickHouseStreamCallback callback) throws SQLException {
        URI uri = this.buildRequestUri(null, null, additionalDBParams, null, false);
        sql = sql + " FORMAT " + (Object)((Object)ClickHouseFormat.Native);
        this.sendStream(sql, callback, uri);
    }

    private void sendStream(String sql, ClickHouseStreamCallback callback, URI uri) throws ClickHouseException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TimeZone timeZone = this.getConnection().getTimeZone();
            ClickHouseRowBinaryStream stream = new ClickHouseRowBinaryStream(out, timeZone, this.properties);
            callback.writeTo(stream);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            this.httpConnector.post(sql, in, uri);
        }
        catch (IOException e) {
            throw ClickHouseExceptionSpecifier.specify(e, this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public void sendStream(InputStream content, String table) throws ClickHouseException {
        this.sendStream(content, table, null);
    }

    @Override
    public void sendStream(InputStream stream, String table, Map<ClickHouseQueryParam, String> additionalDBParams) throws ClickHouseException {
        String sql = "INSERT INTO " + table + " FORMAT " + (Object)((Object)ClickHouseFormat.TabSeparated);
        URI uri = this.buildRequestUri(null, null, additionalDBParams, null, false);
        this.httpConnector.post(sql, stream, uri);
    }

    @Override
    public void sendStreamSQL(InputStream content, String sql) throws ClickHouseException {
        this.sendStreamSQL(content, sql, null);
    }

    @Override
    public void sendStreamSQL(InputStream content, String sql, Map<ClickHouseQueryParam, String> additionalDBParams) throws ClickHouseException {
        URI uri = this.buildRequestUri(null, null, additionalDBParams, null, false);
        this.httpConnector.post(sql, content, uri);
    }

    @Override
    public void sendStreamSQL(String sql, OutputStream responseContent) {
        this.sendStreamSQL(sql, responseContent, null);
    }

    @Override
    public void sendStreamSQL(String sql, OutputStream responseContent, Map<ClickHouseQueryParam, String> additionalDBParams) {
        URI uri = this.buildRequestUri(null, null, additionalDBParams, null, false);
        try (InputStream is = this.httpConnector.post(sql, uri);){
            StreamUtils.copy(is, responseContent);
        }
        catch (Exception e) {
            log.error("Error on sendStreamSQL()", e);
        }
    }

    @Override
    public void closeOnCompletion() {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.closeOnCompletion;
    }

    private AbstractResultSet createResultSet(InputStream is, int bufferSize, String db, String table, boolean usesWithTotals, ClickHouseStatement statement, TimeZone timezone, ClickHouseProperties properties) throws IOException {
        if (this.isResultSetScrollable) {
            return new ClickHouseScrollableResultSet(is, bufferSize, db, table, usesWithTotals, statement, timezone, properties);
        }
        if (this.selectFormat == ClickHouseFormat.JSON || this.selectFormat == ClickHouseFormat.JSONCompact) {
            return new ClickHouseJsonResultSet(is, bufferSize, statement, properties);
        }
        return new ClickHouseResultSet(is, bufferSize, db, table, usesWithTotals, statement, timezone, properties);
    }

    private void addQueryIdTo(Map<ClickHouseQueryParam, String> parameters) {
        if (this.queryId == null && this.properties.isEnableQueryId()) {
            String queryId = parameters.get((Object)ClickHouseQueryParam.QUERY_ID);
            if (queryId == null) {
                this.queryId = ClickHouseUtil.generateQueryId();
                parameters.put(ClickHouseQueryParam.QUERY_ID, this.queryId);
            } else {
                this.queryId = queryId;
            }
        }
    }

    private InputStream sendRequest(String sql, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, List<ClickHouseExternalData> externalData, Map<String, String> additionalRequestParams) throws ClickHouseException {
        String cleanSql = sql.trim();
        this.isSelect = ClickHouseStatementImpl.detectQueryType(cleanSql);
        this.selectFormat = ClickHouseFormat.detectFormat(cleanSql);
        if (this.isSelect.booleanValue() && this.selectFormat == null) {
            cleanSql = this.addFormat(cleanSql, ClickHouseFormat.TabSeparatedWithNamesAndTypes);
        }
        if (additionalClickHouseDBParams == null) {
            additionalClickHouseDBParams = new EnumMap<ClickHouseQueryParam, String>(ClickHouseQueryParam.class);
        }
        this.addQueryIdTo(additionalClickHouseDBParams);
        boolean ignoreDatabase = cleanSql.regionMatches(true, 0, databaseKeyword, 0, databaseKeyword.length());
        if (externalData == null || externalData.isEmpty()) {
            URI uri = this.buildRequestUri(null, null, additionalClickHouseDBParams, additionalRequestParams, ignoreDatabase);
            log.debug("Executing SQL: \"{}\", url: {}", (Object)cleanSql, (Object)uri);
            return this.httpConnector.post(cleanSql, uri);
        }
        URI uri = this.buildRequestUri(cleanSql, externalData, additionalClickHouseDBParams, additionalRequestParams, ignoreDatabase);
        log.debug("Executing SQL: \"{}\", url: {}", (Object)cleanSql, (Object)uri);
        return this.httpConnector.post(externalData, uri);
    }

    URI buildRequestUri(String sql, List<ClickHouseExternalData> externalData, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, Map<String, String> additionalRequestParams, boolean ignoreDatabase) {
        try {
            String queryParams = ClickHouseStatementImpl.toParamsString(ClickHouseStatementImpl.getUrlQueryParams(sql, externalData, additionalClickHouseDBParams, additionalRequestParams, ignoreDatabase, this.properties, this.initialDatabase, this.maxRows, this.queryTimeout));
            return ClickHouseUtil.buildURI(this.properties, queryParams);
        }
        catch (URISyntaxException e) {
            log.error("Mailformed URL: {}", (Object)e.getMessage());
            throw new IllegalStateException("illegal configuration of db");
        }
    }

    private static String toParamsString(List<AbstractMap.SimpleImmutableEntry<String, String>> queryParams) {
        if (queryParams.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (AbstractMap.SimpleImmutableEntry<String, String> pair : queryParams) {
            sb.append(pair.getKey()).append("=").append(pair.getValue()).append("&");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private static List<AbstractMap.SimpleImmutableEntry<String, String>> getUrlQueryParams(String sql, List<ClickHouseExternalData> externalData, Map<ClickHouseQueryParam, String> additionalClickHouseDBParams, Map<String, String> additionalRequestParams, boolean ignoreDatabase, ClickHouseProperties properties, String initialDatabase, int maxRows, int queryTimeout) {
        String s;
        ArrayList<AbstractMap.SimpleImmutableEntry<String, String>> result = new ArrayList<AbstractMap.SimpleImmutableEntry<String, String>>();
        if (sql != null) {
            result.add(new AbstractMap.SimpleImmutableEntry<String, String>("query", sql));
        }
        if (externalData != null) {
            for (ClickHouseExternalData externalDataItem : externalData) {
                String string = externalDataItem.getName();
                String format = externalDataItem.getFormat();
                String types = externalDataItem.getTypes();
                String structure = externalDataItem.getStructure();
                if (format != null && !format.isEmpty()) {
                    result.add(new AbstractMap.SimpleImmutableEntry<String, String>(string + "_format", format));
                }
                if (types != null && !types.isEmpty()) {
                    result.add(new AbstractMap.SimpleImmutableEntry<String, String>(string + "_types", types));
                }
                if (structure == null || structure.isEmpty()) continue;
                result.add(new AbstractMap.SimpleImmutableEntry<String, String>(string + "_structure", structure));
            }
        }
        Map<ClickHouseQueryParam, String> params = properties.buildQueryParams(true);
        if (!ignoreDatabase && !"default".equals(initialDatabase)) {
            params.put(ClickHouseQueryParam.DATABASE, initialDatabase);
        }
        if (additionalClickHouseDBParams != null && !additionalClickHouseDBParams.isEmpty()) {
            params.putAll(additionalClickHouseDBParams);
        }
        if (maxRows > 0) {
            params.put(ClickHouseQueryParam.MAX_RESULT_ROWS, String.valueOf(maxRows));
            params.put(ClickHouseQueryParam.RESULT_OVERFLOW_MODE, "break");
        }
        if (queryTimeout > 0) {
            params.put(ClickHouseQueryParam.MAX_EXECUTION_TIME, String.valueOf(queryTimeout));
        }
        for (Map.Entry<ClickHouseQueryParam, String> entry : params.entrySet()) {
            s = entry.getValue();
            if (s == null || s.isEmpty()) continue;
            result.add(new AbstractMap.SimpleImmutableEntry<String, String>(entry.getKey().toString(), entry.getValue()));
        }
        if (additionalRequestParams != null) {
            for (Map.Entry<Object, String> entry : additionalRequestParams.entrySet()) {
                s = entry.getValue();
                if (s == null || s.isEmpty()) continue;
                result.add(new AbstractMap.SimpleImmutableEntry<Object, String>(entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }
}

