/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.sybaseiq;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="SYBASEIQ", typeDescription="Sybase IQ")
@GuiPlugin(id="GUI-SybaseIQDatabaseMeta")
public class SybaseIQDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 2638;
        }
        return -1;
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.supportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "com.sybase.jdbc3.jdbc.SybDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:sybase:Tds:" + hostname + ":" + port + "/" + databaseName;
    }

    public String getSchemaTableCombination(String schemaName, String tablePart) {
        return schemaName + "." + tablePart;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "DATETIME NULL";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = retval + "INTEGER IDENTITY NOT NULL";
                        break;
                    }
                    retval = retval + "INTEGER NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision != 0 || precision == 0 && length > 9) {
                    if (precision > 0 && length > 0) {
                        retval = retval + "DECIMAL(" + length + ", " + precision + ") NULL";
                        break;
                    }
                    retval = retval + "DOUBLE PRECISION NULL";
                    break;
                }
                if (length < 3) {
                    retval = retval + "TINYINT NULL";
                    break;
                }
                if (length < 5) {
                    retval = retval + "SMALLINT NULL";
                    break;
                }
                retval = retval + "INTEGER NULL";
                break;
            }
            case 2: {
                if (length >= 2048) {
                    retval = retval + "TEXT NULL";
                    break;
                }
                retval = retval + "VARCHAR";
                if (length > 0) {
                    retval = retval + "(" + length + ")";
                }
                retval = retval + " NULL";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getExtraOptionsHelpText() {
        return "http://jtds.sourceforge.net/faq.html#urlFormat";
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " WHERE 1=2";
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

