/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webserviceavailable;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.webserviceavailable.WebServiceAvailableMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WebServiceAvailableDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = WebServiceAvailableMeta.class;
    private CCombo wURL;
    private TextVar wResult;
    private TextVar wConnectTimeOut;
    private TextVar wReadTimeOut;
    private final WebServiceAvailableMeta input;
    private boolean gotPreviousFields = false;

    public WebServiceAvailableDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (WebServiceAvailableMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlURL = new Label((Composite)this.shell, 131072);
        wlURL.setText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.URL.Label", (String[])new String[0]));
        this.props.setLook((Control)wlURL);
        FormData fdlURL = new FormData();
        fdlURL.left = new FormAttachment(0, 0);
        fdlURL.right = new FormAttachment(middle, -margin);
        fdlURL.top = new FormAttachment((Control)this.wTransformName, margin);
        wlURL.setLayoutData((Object)fdlURL);
        this.wURL = new CCombo((Composite)this.shell, 2056);
        this.wURL.setEditable(true);
        this.props.setLook((Control)this.wURL);
        this.wURL.addModifyListener(lsMod);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(middle, 0);
        fdURL.top = new FormAttachment((Control)this.wTransformName, margin);
        fdURL.right = new FormAttachment(100, -margin);
        this.wURL.setLayoutData((Object)fdURL);
        this.wURL.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                WebServiceAvailableDialog.this.get();
            }
        });
        Label wlConnectTimeOut = new Label((Composite)this.shell, 131072);
        wlConnectTimeOut.setText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.ConnectTimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)wlConnectTimeOut);
        FormData fdlConnectTimeOut = new FormData();
        fdlConnectTimeOut.left = new FormAttachment(0, 0);
        fdlConnectTimeOut.top = new FormAttachment((Control)this.wURL, margin);
        fdlConnectTimeOut.right = new FormAttachment(middle, -margin);
        wlConnectTimeOut.setLayoutData((Object)fdlConnectTimeOut);
        this.wConnectTimeOut = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wConnectTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.ConnectTimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wConnectTimeOut);
        this.wConnectTimeOut.addModifyListener(lsMod);
        FormData fdConnectTimeOut = new FormData();
        fdConnectTimeOut.left = new FormAttachment(middle, 0);
        fdConnectTimeOut.top = new FormAttachment((Control)this.wURL, margin);
        fdConnectTimeOut.right = new FormAttachment(100, -margin);
        this.wConnectTimeOut.setLayoutData((Object)fdConnectTimeOut);
        this.wConnectTimeOut.addModifyListener(e -> this.wConnectTimeOut.setToolTipText(this.variables.resolve(this.wConnectTimeOut.getText())));
        Label wlReadTimeOut = new Label((Composite)this.shell, 131072);
        wlReadTimeOut.setText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.ReadTimeOut.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReadTimeOut);
        FormData fdlReadTimeOut = new FormData();
        fdlReadTimeOut.left = new FormAttachment(0, 0);
        fdlReadTimeOut.top = new FormAttachment((Control)this.wConnectTimeOut, margin);
        fdlReadTimeOut.right = new FormAttachment(middle, -margin);
        wlReadTimeOut.setLayoutData((Object)fdlReadTimeOut);
        this.wReadTimeOut = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wReadTimeOut.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.ReadTimeOut.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReadTimeOut);
        this.wReadTimeOut.addModifyListener(lsMod);
        FormData fdReadTimeOut = new FormData();
        fdReadTimeOut.left = new FormAttachment(middle, 0);
        fdReadTimeOut.top = new FormAttachment((Control)this.wConnectTimeOut, margin);
        fdReadTimeOut.right = new FormAttachment(100, -margin);
        this.wReadTimeOut.setLayoutData((Object)fdReadTimeOut);
        this.wReadTimeOut.addModifyListener(e -> this.wReadTimeOut.setToolTipText(this.variables.resolve(this.wReadTimeOut.getText())));
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.ResultField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wReadTimeOut, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.ResultField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wReadTimeOut, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wResult);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getUrlField() != null) {
            this.wURL.setText(this.input.getUrlField());
        }
        if (this.input.getConnectTimeOut() != null) {
            this.wConnectTimeOut.setText(this.input.getConnectTimeOut());
        }
        if (this.input.getReadTimeOut() != null) {
            this.wReadTimeOut.setText(this.input.getReadTimeOut());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setUrlField(this.wURL.getText());
        this.input.setConnectTimeOut(this.wConnectTimeOut.getText());
        this.input.setReadTimeOut(this.wReadTimeOut.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String filefield = this.wURL.getText();
                this.wURL.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wURL.setItems(r.getFieldNames());
                }
                if (filefield != null) {
                    this.wURL.setText(filefield);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebServiceAvailableDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }
}

