/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webserviceavailable;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.webserviceavailable.WebServiceAvailableData;
import org.apache.hop.pipeline.transforms.webserviceavailable.WebServiceAvailableMeta;

public class WebServiceAvailable
extends BaseTransform<WebServiceAvailableMeta, WebServiceAvailableData>
implements ITransform<WebServiceAvailableMeta, WebServiceAvailableData> {
    private static final Class<?> PKG = WebServiceAvailableMeta.class;

    public WebServiceAvailable(TransformMeta transformMeta, WebServiceAvailableMeta meta, WebServiceAvailableData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        block24: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((WebServiceAvailableData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((WebServiceAvailableData)this.data).NrPrevFields = ((WebServiceAvailableData)this.data).previousRowMeta.size();
                ((WebServiceAvailableData)this.data).outputRowMeta = ((WebServiceAvailableData)this.data).previousRowMeta;
                ((WebServiceAvailableMeta)this.meta).getFields(((WebServiceAvailableData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((WebServiceAvailableMeta)this.meta).getUrlField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.FilenameFieldMissing", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.FilenameFieldMissing", (String[])new String[0]));
                }
                ((WebServiceAvailableData)this.data).indexOfURL = ((WebServiceAvailableData)this.data).previousRowMeta.indexOfValue(((WebServiceAvailableMeta)this.meta).getUrlField());
                if (((WebServiceAvailableData)this.data).indexOfURL < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Exception.CouldnotFindField", (String[])new String[0]) + "[" + ((WebServiceAvailableMeta)this.meta).getUrlField() + "]");
                    throw new HopException(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Exception.CouldnotFindField", (String[])new String[]{((WebServiceAvailableMeta)this.meta).getUrlField()}));
                }
            }
            try {
                String url = ((WebServiceAvailableData)this.data).previousRowMeta.getString(r, ((WebServiceAvailableData)this.data).indexOfURL);
                if (Utils.isEmpty((CharSequence)url)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.URLEmpty", (String[])new String[0]));
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Log.CheckingURL", (String[])new String[]{url}));
                }
                boolean webServiceAvailable = false;
                InputStream in = null;
                try {
                    URLConnection conn = new URL(url).openConnection();
                    conn.setConnectTimeout(((WebServiceAvailableData)this.data).connectTimeOut);
                    conn.setReadTimeout(((WebServiceAvailableData)this.data).readTimeOut);
                    in = conn.getInputStream();
                    webServiceAvailable = true;
                }
                catch (Exception e) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.ServiceNotReached", (String[])new String[]{url, e.toString()}));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.putRow(((WebServiceAvailableData)this.data).outputRowMeta, RowDataUtil.addValueData((Object[])r, (int)((WebServiceAvailableData)this.data).NrPrevFields, (Object)webServiceAvailable));
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"FileExists.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block24;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((WebServiceAvailableMeta)this.meta).getResultFieldName(), "WebServiceAvailable001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((WebServiceAvailableMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            ((WebServiceAvailableData)this.data).connectTimeOut = Const.toInt((String)this.resolve(((WebServiceAvailableMeta)this.meta).getConnectTimeOut()), (int)0);
            ((WebServiceAvailableData)this.data).readTimeOut = Const.toInt((String)this.resolve(((WebServiceAvailableMeta)this.meta).getReadTimeOut()), (int)0);
            return true;
        }
        return false;
    }
}

