/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.memgroupby;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupBy;
import org.apache.hop.pipeline.transforms.memgroupby.MemoryGroupByData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="MemoryGroupBy.Injection.", groups={"FIELDS", "AGGREGATES"})
@Transform(id="MemoryGroupBy", image="memorygroupby.svg", name="i18n::BaseTransform.TypeLongDesc.MemoryGroupBy", description="i18n::BaseTransform.TypeTooltipDesc.MemoryGroupBy", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", documentationUrl="/pipeline/transforms/memgroupby.html")
public class MemoryGroupByMeta
extends BaseTransformMeta
implements ITransformMeta<MemoryGroupBy, MemoryGroupByData> {
    private static final Class<?> PKG = MemoryGroupByMeta.class;
    public static final int TYPE_GROUP_NONE = 0;
    public static final int TYPE_GROUP_SUM = 1;
    public static final int TYPE_GROUP_AVERAGE = 2;
    public static final int TYPE_GROUP_MEDIAN = 3;
    public static final int TYPE_GROUP_PERCENTILE = 4;
    public static final int TYPE_GROUP_MIN = 5;
    public static final int TYPE_GROUP_MAX = 6;
    public static final int TYPE_GROUP_COUNT_ALL = 7;
    public static final int TYPE_GROUP_CONCAT_COMMA = 8;
    public static final int TYPE_GROUP_FIRST = 9;
    public static final int TYPE_GROUP_LAST = 10;
    public static final int TYPE_GROUP_FIRST_INCL_NULL = 11;
    public static final int TYPE_GROUP_LAST_INCL_NULL = 12;
    public static final int TYPE_GROUP_STANDARD_DEVIATION = 13;
    public static final int TYPE_GROUP_CONCAT_STRING = 14;
    public static final int TYPE_GROUP_COUNT_DISTINCT = 15;
    public static final int TYPE_GROUP_COUNT_ANY = 16;
    public static final String[] typeGroupCode = new String[]{"-", "SUM", "AVERAGE", "MEDIAN", "PERCENTILE", "MIN", "MAX", "COUNT_ALL", "CONCAT_COMMA", "FIRST", "LAST", "FIRST_INCL_NULL", "LAST_INCL_NULL", "STD_DEV", "CONCAT_STRING", "COUNT_DISTINCT", "COUNT_ANY"};
    public static final String[] typeGroupLongDesc = new String[]{"-", BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MEDIAN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.PERCENTILE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MIN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.MAX", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_ALL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_COMMA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.FIRST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.LAST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.FIRST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.LAST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.CONCAT_STRING", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.COUNT_DISTINCT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.TypeGroupLongDesc.COUNT_ANY", (String[])new String[0])};
    @Injection(name="GROUPFIELD", group="FIELDS")
    private String[] groupField;
    @Injection(name="AGGREGATEFIELD", group="AGGREGATES")
    private String[] aggregateField;
    @Injection(name="SUBJECTFIELD", group="AGGREGATES")
    private String[] subjectField;
    @Injection(name="AGGREGATETYPE", group="AGGREGATES")
    private int[] aggregateType;
    @Injection(name="VALUEFIELD", group="AGGREGATES")
    private String[] valueField;
    @Injection(name="ALWAYSGIVINGBACKONEROW", group="FIELDS")
    private boolean alwaysGivingBackOneRow;

    public String[] getAggregateField() {
        return this.aggregateField;
    }

    public void setAggregateField(String[] aggregateField) {
        this.aggregateField = aggregateField;
    }

    public int[] getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(int[] aggregateType) {
        this.aggregateType = aggregateType;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public String[] getSubjectField() {
        return this.subjectField;
    }

    public void setSubjectField(String[] subjectField) {
        this.subjectField = subjectField;
    }

    public String[] getValueField() {
        return this.valueField;
    }

    public void setValueField(String[] valueField) {
        this.valueField = valueField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int sizegroup, int nrFields) {
        this.groupField = new String[sizegroup];
        this.aggregateField = new String[nrFields];
        this.subjectField = new String[nrFields];
        this.aggregateType = new int[nrFields];
        this.valueField = new String[nrFields];
    }

    public Object clone() {
        MemoryGroupByMeta retval = (MemoryGroupByMeta)((Object)super.clone());
        int nrFields = this.aggregateField.length;
        int nrGroups = this.groupField.length;
        retval.allocate(nrGroups, nrFields);
        System.arraycopy(this.groupField, 0, retval.groupField, 0, nrGroups);
        System.arraycopy(this.aggregateField, 0, retval.aggregateField, 0, nrFields);
        System.arraycopy(this.subjectField, 0, retval.subjectField, 0, nrFields);
        System.arraycopy(this.aggregateType, 0, retval.aggregateType, 0, nrFields);
        System.arraycopy(this.valueField, 0, retval.valueField, 0, nrFields);
        return retval;
    }

    public MemoryGroupBy createTransform(TransformMeta transformMeta, MemoryGroupByData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new MemoryGroupBy(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node groupn = XmlHandler.getSubNode((Node)transformNode, (String)"group");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int sizegroup = XmlHandler.countNodes((Node)groupn, (String)"field");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(sizegroup, nrFields);
            for (int i = 0; i < sizegroup; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)groupn, (String)"field", (int)i);
                this.groupField[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
            boolean hasNumberOfValues = false;
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.aggregateField[i] = XmlHandler.getTagValue((Node)fnode, (String)"aggregate");
                this.subjectField[i] = XmlHandler.getTagValue((Node)fnode, (String)"subject");
                this.aggregateType[i] = MemoryGroupByMeta.getType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
                if (this.aggregateType[i] == 7 || this.aggregateType[i] == 15 || this.aggregateType[i] == 16) {
                    hasNumberOfValues = true;
                }
                this.valueField[i] = XmlHandler.getTagValue((Node)fnode, (String)"valuefield");
            }
            String giveBackRow = XmlHandler.getTagValue((Node)transformNode, (String)"give_back_row");
            this.alwaysGivingBackOneRow = Utils.isEmpty((CharSequence)giveBackRow) ? hasNumberOfValues : "Y".equalsIgnoreCase(giveBackRow);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public static final int getType(String desc) {
        int i;
        for (i = 0; i < typeGroupCode.length; ++i) {
            if (!typeGroupCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= typeGroupCode.length) {
            return null;
        }
        return typeGroupCode[i];
    }

    public static final String getTypeDescLong(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }

    public void setDefault() {
        int sizegroup = 0;
        int nrFields = 0;
        this.allocate(sizegroup, nrFields);
    }

    public void getFields(IRowMeta r, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        int i;
        boolean compatibilityMode = ValueMetaBase.convertStringToBoolean((String)variables.getVariable("HOP_COMPATIBILITY_MEMORY_GROUP_BY_SUM_AVERAGE_RETURN_NUMBER_TYPE", "N"));
        RowMeta fields = new RowMeta();
        for (i = 0; i < this.groupField.length; ++i) {
            IValueMeta valueMeta = r.searchValueMeta(this.groupField[i]);
            if (valueMeta == null) continue;
            valueMeta.setStorageType(0);
            fields.addValueMeta(valueMeta);
        }
        for (i = 0; i < this.subjectField.length; ++i) {
            IValueMeta v;
            IValueMeta subj = r.searchValueMeta(this.subjectField[i]);
            if (subj == null && this.aggregateType[i] != 16) continue;
            String valueName = this.aggregateField[i];
            int valueType = 0;
            int length = -1;
            int precision = -1;
            switch (this.aggregateType[i]) {
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    valueType = subj.getType();
                    break;
                }
                case 7: 
                case 15: 
                case 16: {
                    valueType = 5;
                    break;
                }
                case 8: {
                    valueType = 2;
                    break;
                }
                case 1: 
                case 2: {
                    if (!compatibilityMode && subj.isNumeric()) {
                        valueType = subj.getType();
                        break;
                    }
                    valueType = 1;
                    break;
                }
                case 3: 
                case 4: 
                case 13: {
                    valueType = 1;
                    break;
                }
                case 14: {
                    valueType = 2;
                    break;
                }
            }
            if (this.aggregateType[i] == 1 && valueType != 5 && valueType != 1 && valueType != 6) {
                valueType = 1;
                precision = -1;
                length = -1;
            }
            if (valueType == 0) continue;
            try {
                v = ValueMetaFactory.createValueMeta((String)valueName, (int)valueType);
            }
            catch (HopPluginException e) {
                this.log.logError(BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.Exception.UnknownValueMetaType", (String[])new String[0]), new Object[]{valueType, e});
                v = new ValueMetaNone(valueName);
            }
            v.setOrigin(origin);
            v.setLength(length, precision);
            if (subj != null) {
                v.setConversionMask(subj.getConversionMask());
            }
            fields.addValueMeta(v);
        }
        r.clear();
        r.addRowMeta((IRowMeta)fields);
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(500);
        retval.append("      ").append(XmlHandler.addTagValue((String)"give_back_row", (boolean)this.alwaysGivingBackOneRow));
        retval.append("      <group>").append(Const.CR);
        for (i = 0; i < this.groupField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.groupField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </group>").append(Const.CR);
        retval.append("      <fields>").append(Const.CR);
        for (i = 0; i < this.subjectField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XmlHandler.addTagValue((String)"aggregate", (String)this.aggregateField[i]));
            retval.append("          ").append(XmlHandler.addTagValue((String)"subject", (String)this.subjectField[i]));
            retval.append("          ").append(XmlHandler.addTagValue((String)"type", (String)MemoryGroupByMeta.getTypeDesc(this.aggregateType[i])));
            retval.append("          ").append(XmlHandler.addTagValue((String)"valuefield", (String)this.valueField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MemoryGroupByMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public MemoryGroupByData getTransformData() {
        return new MemoryGroupByData();
    }

    public boolean isAlwaysGivingBackOneRow() {
        return this.alwaysGivingBackOneRow;
    }

    public void setAlwaysGivingBackOneRow(boolean alwaysGivingBackOneRow) {
        this.alwaysGivingBackOneRow = alwaysGivingBackOneRow;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.subjectField == null ? -1 : this.subjectField.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] normalizedStringArrays = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.aggregateField, this.valueField});
        this.aggregateField = normalizedStringArrays[0];
        this.valueField = normalizedStringArrays[1];
        int[][] normalizedIntArrays = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.aggregateType});
        this.aggregateType = normalizedIntArrays[0];
    }
}

