/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.concatfields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsMeta;
import org.apache.hop.pipeline.transforms.textfileoutput.TextFileField;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ConcatFieldsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ConcatFieldsMeta.class;
    private TextVar wTargetFieldName;
    private Text wTargetFieldLength;
    private TextVar wSeparator;
    private TextVar wEnclosure;
    private TableView wFields;
    private ConcatFieldsMeta input;
    private boolean gotEncodings = false;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;

    public ConcatFieldsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ConcatFieldsMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatFieldsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlTargetFieldName = new Label((Composite)this.shell, 131072);
        wlTargetFieldName.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldName.Label", (String[])new String[0]));
        wlTargetFieldName.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlTargetFieldName);
        FormData fdlTargetFieldName = new FormData();
        fdlTargetFieldName.left = new FormAttachment(0, 0);
        fdlTargetFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlTargetFieldName.right = new FormAttachment(middle, -margin);
        wlTargetFieldName.setLayoutData((Object)fdlTargetFieldName);
        this.wTargetFieldName = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wTargetFieldName.setText("");
        this.props.setLook((Control)this.wTargetFieldName);
        this.wTargetFieldName.addModifyListener(lsMod);
        FormData fdTargetFieldName = new FormData();
        fdTargetFieldName.left = new FormAttachment(middle, 0);
        fdTargetFieldName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTargetFieldName.right = new FormAttachment(100, 0);
        this.wTargetFieldName.setLayoutData((Object)fdTargetFieldName);
        Label wlTargetFieldLength = new Label((Composite)this.shell, 131072);
        wlTargetFieldLength.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldLength.Label", (String[])new String[0]));
        wlTargetFieldLength.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TargetFieldLength.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlTargetFieldLength);
        FormData fdlTargetFieldLength = new FormData();
        fdlTargetFieldLength.left = new FormAttachment(0, 0);
        fdlTargetFieldLength.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        fdlTargetFieldLength.right = new FormAttachment(middle, -margin);
        wlTargetFieldLength.setLayoutData((Object)fdlTargetFieldLength);
        this.wTargetFieldLength = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTargetFieldLength);
        this.wTargetFieldLength.addModifyListener(lsMod);
        FormData fdTargetFieldLength = new FormData();
        fdTargetFieldLength.left = new FormAttachment(middle, 0);
        fdTargetFieldLength.top = new FormAttachment((Control)this.wTargetFieldName, margin);
        fdTargetFieldLength.right = new FormAttachment(100, 0);
        this.wTargetFieldLength.setLayoutData((Object)fdTargetFieldLength);
        Label wlSeparator = new Label((Composite)this.shell, 131072);
        wlSeparator.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Separator.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSeparator);
        FormData fdlSeparator = new FormData();
        fdlSeparator.left = new FormAttachment(0, 0);
        fdlSeparator.top = new FormAttachment((Control)this.wTargetFieldLength, margin);
        fdlSeparator.right = new FormAttachment(middle, -margin);
        wlSeparator.setLayoutData((Object)fdlSeparator);
        Button wbSeparator = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbSeparator);
        wbSeparator.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Separator.Button", (String[])new String[0]));
        FormData fdbSeparator = new FormData();
        fdbSeparator.right = new FormAttachment(100, 0);
        fdbSeparator.top = new FormAttachment((Control)this.wTargetFieldLength, margin);
        wbSeparator.setLayoutData((Object)fdbSeparator);
        wbSeparator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ConcatFieldsDialog.this.wSeparator.getTextWidget().insert("\t");
            }
        });
        this.wSeparator = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSeparator);
        this.wSeparator.addModifyListener(lsMod);
        FormData fdSeparator = new FormData();
        fdSeparator.left = new FormAttachment(middle, 0);
        fdSeparator.top = new FormAttachment((Control)this.wTargetFieldLength, margin);
        fdSeparator.right = new FormAttachment((Control)wbSeparator, -margin);
        this.wSeparator.setLayoutData((Object)fdSeparator);
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.Enclosure.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.top = new FormAttachment((Control)this.wSeparator, margin);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.top = new FormAttachment((Control)this.wSeparator, margin);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData((Object)fdEnclosure);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        Button wMinWidth = new Button(wFieldsComp, 8);
        wMinWidth.setText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.MinWidth.Button", (String[])new String[0]));
        wMinWidth.setToolTipText(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.MinWidth.Tooltip", (String[])new String[0]));
        wMinWidth.addListener(13, e -> this.setMinimalWidth());
        this.setButtonPositions(new Button[]{this.wGet, wMinWidth}, margin, null);
        int FieldsCols = 10;
        int FieldsRows = this.input.getOutputFields().length;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        this.colinf = new ColumnInfo[10];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.NameColumn.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TypeColumn.Column", (String[])new String[0]), 2, ValueMetaBase.getTypes());
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.FormatColumn.Column", (String[])new String[0]), 2, formats);
        this.colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.LengthColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[5] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.CurrencyColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[6] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.DecimalColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[7] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.GroupColumn.Column", (String[])new String[0]), 1, false);
        this.colinf[8] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.TrimTypeColumn.Column", (String[])new String[0]), 2, ValueMetaBase.trimTypeDesc, true);
        this.colinf[9] = new ColumnInfo(BaseMessages.getString(PKG, (String)"ConcatFieldsDialog.NullColumn.Column", (String[])new String[0]), 1, false);
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = ConcatFieldsDialog.this.pipelineMeta.findTransform(ConcatFieldsDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta row = ConcatFieldsDialog.this.pipelineMeta.getPrevTransformFields(ConcatFieldsDialog.this.variables, transformMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            ConcatFieldsDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        ConcatFieldsDialog.this.setComboBoxes();
                    }
                    catch (HopException e) {
                        ConcatFieldsDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wEnclosure, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wTargetFieldName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConcatFieldsDialog.this.wTargetFieldName.setToolTipText(ConcatFieldsDialog.this.variables.resolve(ConcatFieldsDialog.this.wTargetFieldName.getText()));
            }
        });
        this.lsResize = event -> {
            Point size = this.shell.getSize();
            this.wFields.setSize(size.x - 10, size.y - 50);
            this.wFields.table.setSize(size.x - 10, size.y - 50);
            this.wFields.redraw();
        };
        this.shell.addListener(11, this.lsResize);
        wTabFolder.setSelection(0);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getTargetFieldName() != null) {
            this.wTargetFieldName.setText(this.input.getTargetFieldName());
        }
        this.wTargetFieldLength.setText("" + this.input.getTargetFieldLength());
        this.wSeparator.setText(Const.NVL((String)this.input.getSeparator(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)this.input.getEnclosure(), (String)""));
        this.logDebug("getting fields info...");
        for (int i = 0; i < this.input.getOutputFields().length; ++i) {
            String trim;
            TextFileField field = this.input.getOutputFields()[i];
            TableItem item = this.wFields.table.getItem(i);
            if (field.getName() != null) {
                item.setText(1, field.getName());
            }
            item.setText(2, field.getTypeDesc());
            if (field.getFormat() != null) {
                item.setText(3, field.getFormat());
            }
            if (field.getLength() >= 0) {
                item.setText(4, "" + field.getLength());
            }
            if (field.getPrecision() >= 0) {
                item.setText(5, "" + field.getPrecision());
            }
            if (field.getCurrencySymbol() != null) {
                item.setText(6, field.getCurrencySymbol());
            }
            if (field.getDecimalSymbol() != null) {
                item.setText(7, field.getDecimalSymbol());
            }
            if (field.getGroupingSymbol() != null) {
                item.setText(8, field.getGroupingSymbol());
            }
            if ((trim = field.getTrimTypeDesc()) != null) {
                item.setText(9, trim);
            }
            if (field.getNullString() == null) continue;
            item.setText(10, field.getNullString());
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(ConcatFieldsMeta tfoi) {
        tfoi.setTargetFieldName(this.wTargetFieldName.getText());
        tfoi.setTargetFieldLength(Const.toInt((String)this.wTargetFieldLength.getText(), (int)0));
        tfoi.setSeparator(this.wSeparator.getText());
        tfoi.setEnclosure(this.wEnclosure.getText());
        int nrFields = this.wFields.nrNonEmpty();
        tfoi.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TextFileField field = new TextFileField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setType(item.getText(2));
            field.setFormat(item.getText(3));
            field.setLength(Const.toInt((String)item.getText(4), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(5), (int)-1));
            field.setCurrencySymbol(item.getText(6));
            field.setDecimalSymbol(item.getText(7));
            field.setGroupingSymbol(item.getText(8));
            field.setTrimType(ValueMetaBase.getTrimTypeByDesc((String)item.getText(9)));
            field.setNullString(item.getText(10));
            tfoi.getOutputFields()[i] = field;
        }
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = new ITableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, IValueMeta v) {
                        if (v.isNumber() && v.getLength() > 0) {
                            int m;
                            int le = v.getLength();
                            int pr = v.getPrecision();
                            if (v.getPrecision() <= 0) {
                                pr = 0;
                            }
                            String mask = "";
                            for (m = 0; m < le - pr; ++m) {
                                mask = mask + "0";
                            }
                            if (pr > 0) {
                                mask = mask + ".";
                            }
                            for (m = 0; m < pr; ++m) {
                                mask = mask + "0";
                            }
                            tableItem.setText(3, mask);
                        }
                        return true;
                    }
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{2}, (int)4, (int)5, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void setMinimalWidth() {
        int i;
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        block6: for (i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            item.setText(4, "");
            item.setText(5, "");
            item.setText(9, ValueMetaBase.getTrimTypeDesc((int)3));
            int type = ValueMetaBase.getType((String)item.getText(2));
            switch (type) {
                case 2: {
                    item.setText(3, "");
                    continue block6;
                }
                case 5: {
                    item.setText(3, "0");
                    continue block6;
                }
                case 1: {
                    item.setText(3, "0.#####");
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
        }
        for (i = 0; i < this.input.getOutputFields().length; ++i) {
            this.input.getOutputFields()[i].setTrimType(3);
        }
        this.wFields.optWidth(true);
    }
}

