/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.concatfields;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsData;
import org.apache.hop.pipeline.transforms.concatfields.ConcatFieldsMeta;

public class ConcatFields
extends BaseTransform<ConcatFieldsMeta, ConcatFieldsData>
implements ITransform<ConcatFieldsMeta, ConcatFieldsData> {
    private static final Class<?> PKG = ConcatFields.class;

    public ConcatFields(TransformMeta transformMeta, ConcatFieldsMeta meta, ConcatFieldsData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public synchronized boolean processRow() throws HopException {
        boolean result = true;
        boolean bEndedLineWrote = false;
        Object[] r = this.getRow();
        if (r != null && this.first) {
            this.first = false;
            ((ConcatFieldsData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((ConcatFieldsMeta)this.meta).getFields(((ConcatFieldsData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((ConcatFieldsData)this.data).inputRowMetaModified = this.getInputRowMeta().clone();
            ((ConcatFieldsMeta)this.meta).getFieldsModifyInput(((ConcatFieldsData)this.data).inputRowMetaModified, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((ConcatFieldsData)this.data).posTargetField = ((ConcatFieldsData)this.data).outputRowMeta.indexOfValue(((ConcatFieldsMeta)this.meta).getTargetFieldName());
            if (((ConcatFieldsData)this.data).posTargetField < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.TargetFieldNotFoundOutputStream", (String[])new String[]{"" + ((ConcatFieldsMeta)this.meta).getTargetFieldName()}));
            }
            ((ConcatFieldsData)this.data).fieldnrs = new int[((ConcatFieldsMeta)this.meta).getOutputFields().length];
            for (int i = 0; i < ((ConcatFieldsMeta)this.meta).getOutputFields().length; ++i) {
                ((ConcatFieldsData)this.data).fieldnrs[i] = ((ConcatFieldsData)this.data).inputRowMetaModified.indexOfValue(((ConcatFieldsMeta)this.meta).getOutputFields()[i].getName());
                if (((ConcatFieldsData)this.data).fieldnrs[i] >= 0) continue;
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.FieldNotFoundInputStream", (String[])new String[]{"" + ((ConcatFieldsMeta)this.meta).getOutputFields()[i].getName()}));
            }
            ((ConcatFieldsData)this.data).targetFieldLengthFastDataDump = ((ConcatFieldsMeta)this.meta).getTargetFieldLength();
            if (((ConcatFieldsData)this.data).targetFieldLengthFastDataDump <= 0) {
                ((ConcatFieldsData)this.data).targetFieldLengthFastDataDump = ((ConcatFieldsMeta)this.meta).getOutputFields().length == 0 ? 50 * this.getInputRowMeta().size() : 50 * ((ConcatFieldsMeta)this.meta).getOutputFields().length;
            }
            this.prepareForReMap();
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        r = this.putRowFastDataDump(r);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"ConcatFields.Log.WriteRow", (String[])new String[0]) + this.getLinesWritten() + " : " + ((ConcatFieldsData)this.data).outputRowMeta.getString(r));
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ConcatFields.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return result;
    }

    void prepareForReMap() throws HopTransformException {
        if (((ConcatFieldsMeta)this.meta).isRemoveSelectedFields()) {
            ((ConcatFieldsData)this.data).remainingFieldsInputOutputMapping = new int[((ConcatFieldsData)this.data).outputRowMeta.size() - 1];
            String[] fieldNames = ((ConcatFieldsData)this.data).outputRowMeta.getFieldNames();
            for (int i = 0; i < fieldNames.length - 1; ++i) {
                ((ConcatFieldsData)this.data).remainingFieldsInputOutputMapping[i] = ((ConcatFieldsData)this.data).inputRowMetaModified.indexOfValue(fieldNames[i]);
                if (((ConcatFieldsData)this.data).remainingFieldsInputOutputMapping[i] >= 0) continue;
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"ConcatFields.Error.RemainingFieldNotFoundInputStream", (String[])new String[]{"" + fieldNames[i]}));
            }
        }
    }

    Object[] putRowFromStream(Object[] r) throws HopTransformException {
        Object[] outputRowData = this.prepareOutputRow(r);
        outputRowData[((ConcatFieldsData)this.data).posTargetField] = null;
        this.putRow(((ConcatFieldsData)this.data).outputRowMeta, outputRowData);
        return outputRowData;
    }

    Object[] putRowFastDataDump(Object[] r) throws HopException {
        Object[] outputRowData = this.prepareOutputRow(r);
        StringBuilder targetString = new StringBuilder(((ConcatFieldsData)this.data).targetFieldLengthFastDataDump);
        if (((ConcatFieldsMeta)this.meta).getOutputFields() == null || ((ConcatFieldsMeta)this.meta).getOutputFields().length == 0) {
            for (int i = 0; i < this.getInputRowMeta().size(); ++i) {
                if (i > 0) {
                    targetString.append(((ConcatFieldsData)this.data).stringSeparator);
                }
                IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(((ConcatFieldsData)this.data).fieldnrs[i]);
                this.concatFieldFastDataDump(targetString, valueMeta, r[i], "");
            }
        } else {
            for (int i = 0; i < ((ConcatFieldsData)this.data).fieldnrs.length; ++i) {
                if (i > 0) {
                    targetString.append(((ConcatFieldsData)this.data).stringSeparator);
                }
                IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(((ConcatFieldsData)this.data).fieldnrs[i]);
                this.concatFieldFastDataDump(targetString, valueMeta, r[((ConcatFieldsData)this.data).fieldnrs[i]], ((ConcatFieldsData)this.data).stringNullValue[i]);
            }
        }
        outputRowData[((ConcatFieldsData)this.data).posTargetField] = new String(targetString);
        this.putRow(((ConcatFieldsData)this.data).outputRowMeta, outputRowData);
        return outputRowData;
    }

    private void concatFieldFastDataDump(StringBuilder targetField, IValueMeta valueMeta, Object valueData, String nullString) throws HopValueException {
        if (valueMeta.isNull(valueData)) {
            targetField.append(nullString);
        } else {
            targetField.append(valueMeta.getString(valueData));
        }
    }

    private Object[] prepareOutputRow(Object[] r) {
        Object[] outputRowData = null;
        if (!((ConcatFieldsMeta)this.meta).isRemoveSelectedFields()) {
            outputRowData = RowDataUtil.resizeArray((Object[])r, (int)((ConcatFieldsData)this.data).outputRowMeta.size());
        } else {
            outputRowData = new Object[((ConcatFieldsData)this.data).outputRowMeta.size() + RowDataUtil.OVER_ALLOCATE_SIZE];
            if (r != null) {
                for (int i = 0; i < ((ConcatFieldsData)this.data).remainingFieldsInputOutputMapping.length; ++i) {
                    outputRowData[i] = r[((ConcatFieldsData)this.data).remainingFieldsInputOutputMapping[i]];
                }
            }
        }
        return outputRowData;
    }

    public boolean init() {
        this.initStringDataFields();
        return super.init();
    }

    private void initStringDataFields() {
        ((ConcatFieldsData)this.data).stringSeparator = "";
        ((ConcatFieldsData)this.data).stringEnclosure = "";
        if (!StringUtil.isEmpty((String)((ConcatFieldsMeta)this.meta).getSeparator())) {
            ((ConcatFieldsData)this.data).stringSeparator = this.resolve(((ConcatFieldsMeta)this.meta).getSeparator());
        }
        if (!StringUtil.isEmpty((String)((ConcatFieldsMeta)this.meta).getEnclosure())) {
            ((ConcatFieldsData)this.data).stringEnclosure = this.resolve(((ConcatFieldsMeta)this.meta).getEnclosure());
        }
        ((ConcatFieldsData)this.data).stringNullValue = new String[((ConcatFieldsMeta)this.meta).getOutputFields().length];
        for (int i = 0; i < ((ConcatFieldsMeta)this.meta).getOutputFields().length; ++i) {
            ((ConcatFieldsData)this.data).stringNullValue[i] = "";
            String nullString = ((ConcatFieldsMeta)this.meta).getOutputFields()[i].getNullString();
            if (StringUtil.isEmpty((String)nullString)) continue;
            ((ConcatFieldsData)this.data).stringNullValue[i] = nullString;
        }
    }

    public void dispose() {
        super.dispose();
    }
}

