/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.multimerge;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transform.errorhandling.Stream;
import org.apache.hop.pipeline.transform.errorhandling.StreamIcon;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoin;
import org.apache.hop.pipeline.transforms.multimerge.MultiMergeJoinData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="MultiMergeJoin.Injection.")
@Transform(id="MultiwayMergeJoin", image="multimergejoin.svg", name="i18n::MultiwayMergeJoin.Name", description="i18n::MultiwayMergeJoin.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", documentationUrl="/pipeline/transforms/multimerge.html")
public class MultiMergeJoinMeta
extends BaseTransformMeta
implements ITransformMeta<MultiMergeJoin, MultiMergeJoinData> {
    private static final Class<?> PKG = MultiMergeJoinMeta.class;
    public static final String[] joinTypes = new String[]{"INNER", "FULL OUTER"};
    public static final boolean[] optionals = new boolean[]{false, true};
    @Injection(name="JOIN_TYPE")
    private String joinType;
    @Injection(name="KEY_FIELDS")
    private String[] keyFields;
    @Injection(name="INPUT_TRANSFORMS")
    private String[] inputTransforms;

    public ITransform createTransform(TransformMeta transformMeta, MultiMergeJoinData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new MultiMergeJoin(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public String getJoinType() {
        return this.joinType;
    }

    public void setJoinType(String joinType) {
        this.joinType = joinType;
    }

    public String[] getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(String[] keyFields) {
        this.keyFields = keyFields;
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocateKeys(int nrKeys) {
        this.keyFields = new String[nrKeys];
    }

    public Object clone() {
        MultiMergeJoinMeta retval = (MultiMergeJoinMeta)((Object)super.clone());
        int nrKeys = this.keyFields == null ? 0 : this.keyFields.length;
        int nrTransforms = this.inputTransforms == null ? 0 : this.inputTransforms.length;
        retval.allocateKeys(nrKeys);
        retval.allocateInputTransforms(nrTransforms);
        System.arraycopy(this.keyFields, 0, retval.keyFields, 0, nrKeys);
        System.arraycopy(this.inputTransforms, 0, retval.inputTransforms, 0, nrTransforms);
        return retval;
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder();
        String[] inputTransformsNames = this.inputTransforms != null ? this.inputTransforms : ArrayUtils.EMPTY_STRING_ARRAY;
        retval.append("    ").append(XmlHandler.addTagValue((String)"join_type", (String)this.getJoinType()));
        for (i = 0; i < inputTransformsNames.length; ++i) {
            retval.append("    ").append(XmlHandler.addTagValue((String)("transform" + i), (String)inputTransformsNames[i]));
        }
        retval.append("    ").append(XmlHandler.addTagValue((String)"number_input", (int)inputTransformsNames.length));
        retval.append("    ").append(XmlHandler.openTag((String)"keys")).append(Const.CR);
        for (i = 0; i < this.keyFields.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"key", (String)this.keyFields[i]));
        }
        retval.append("    ").append(XmlHandler.closeTag((String)"keys")).append(Const.CR);
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node keysNode = XmlHandler.getSubNode((Node)transformNode, (String)"keys");
            int nrKeys = XmlHandler.countNodes((Node)keysNode, (String)"key");
            this.allocateKeys(nrKeys);
            for (int i = 0; i < nrKeys; ++i) {
                Node keynode = XmlHandler.getSubNodeByNr((Node)keysNode, (String)"key", (int)i);
                this.keyFields[i] = XmlHandler.getNodeValue((Node)keynode);
            }
            int nInputStreams = Integer.parseInt(XmlHandler.getTagValue((Node)transformNode, (String)"number_input"));
            this.allocateInputTransforms(nInputStreams);
            for (int i = 0; i < nInputStreams; ++i) {
                this.inputTransforms[i] = XmlHandler.getTagValue((Node)transformNode, (String)("transform" + i));
            }
            this.joinType = XmlHandler.getTagValue((Node)transformNode, (String)"join_type");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.joinType = joinTypes[0];
        this.allocateKeys(0);
        this.allocateInputTransforms(0);
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        ITransformIOMeta ioMeta = this.getTransformIOMeta();
        ioMeta.getInfoStreams().clear();
        for (int i = 0; i < this.inputTransforms.length; ++i) {
            String inputTransformName = this.inputTransforms[i];
            if (i < ioMeta.getInfoStreams().size()) continue;
            ioMeta.addStream((IStream)new Stream(IStream.StreamType.INFO, TransformMeta.findTransform(transforms, (String)inputTransformName), BaseMessages.getString(PKG, (String)"MultiMergeJoin.InfoStream.Description", (String[])new String[0]), StreamIcon.INFO, inputTransformName));
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"MultiMergeJoinMeta.CheckResult.TransformNotVerified", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int i;
        if (info != null) {
            for (i = 0; i < info.length; ++i) {
                if (info[i] == null) continue;
                r.mergeRowMeta(info[i]);
            }
        }
        for (i = 0; i < r.size(); ++i) {
            r.getValueMeta(i).setOrigin(name);
        }
    }

    public MultiMergeJoinData getTransformData() {
        return new MultiMergeJoinData();
    }

    public void resetTransformIoMeta() {
    }

    public void setInputTransforms(String[] inputTransforms) {
        this.inputTransforms = inputTransforms;
    }

    public String[] getInputTransforms() {
        return this.inputTransforms;
    }

    public void allocateInputTransforms(int count) {
        this.inputTransforms = new String[count];
    }
}

