/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.hop.vfs.azure.AzureFileName;

public class AzureFileNameParser
extends HostFileNameParser {
    private static final AzureFileNameParser instance = new AzureFileNameParser();

    public static AzureFileNameParser getInstance() {
        return instance;
    }

    public AzureFileNameParser() {
        super(443);
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        FileType fileType;
        String scheme;
        StringBuilder name = new StringBuilder();
        HostFileNameParser.Authority auth = null;
        String path = null;
        int eidx = filename.indexOf("@/");
        if (eidx != -1) {
            filename = filename.substring(0, eidx + 1) + "windowsazure.com" + filename.substring(eidx + 1);
        }
        try {
            auth = this.extractToPath(filename, name);
            if (auth.getUserName() == null) {
                scheme = UriParser.extractScheme((String)filename, (StringBuilder)name);
                UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
                UriParser.fixSeparators((StringBuilder)name);
            } else {
                scheme = auth.getScheme();
            }
            fileType = UriParser.normalisePath((StringBuilder)name);
            path = name.toString();
            if (path.equals("")) {
                path = "/";
            }
        }
        catch (FileSystemException fse) {
            scheme = UriParser.extractScheme((String)filename, (StringBuilder)name);
            UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
            UriParser.fixSeparators((StringBuilder)name);
            fileType = UriParser.normalisePath((StringBuilder)name);
            path = name.toString();
        }
        return new AzureFileName(scheme, path, fileType);
    }
}

