/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.write;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.write.AzureWrite;
import org.apache.hop.pipeline.transforms.eventhubs.write.AzureWriterData;
import org.w3c.dom.Node;

@Transform(id="AzureWriter", name="Azure Event Hubs Writer", description="Write data to a Microsoft Azure Event Hub", image="event-hubs-writer.svg", categoryDescription="Streaming", documentationUrl="/pipeline/transforms/azure-event-hubs-writer.html")
public class AzureWriterMeta
extends BaseTransformMeta
implements ITransformMeta<AzureWrite, AzureWriterData> {
    public static final String NAMESPACE = "namespace";
    public static final String EVENT_HUB_NAME = "event_hub_name";
    public static final String SAS_KEY_NAME = "sas_key_name";
    public static final String SAS_KEY = "sas_key";
    public static final String BATCH_SIZE = "batch_size";
    public static final String MESSAGE_FIELD = "message_field";
    private String namespace;
    private String eventHubName;
    private String sasKeyName;
    private String sasKey;
    private String batchSize;
    private String messageField;

    public void setDefault() {
    }

    public ITransform createTransform(TransformMeta transformMeta, AzureWriterData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new AzureWrite(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public AzureWriterData getTransformData() {
        return new AzureWriterData();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.addTagValue((String)NAMESPACE, (String)this.namespace));
        xml.append(XmlHandler.addTagValue((String)EVENT_HUB_NAME, (String)this.eventHubName));
        xml.append(XmlHandler.addTagValue((String)SAS_KEY_NAME, (String)this.sasKeyName));
        xml.append(XmlHandler.addTagValue((String)SAS_KEY, (String)Encr.encryptPasswordIfNotUsingVariables((String)this.sasKey)));
        xml.append(XmlHandler.addTagValue((String)BATCH_SIZE, (String)this.batchSize));
        xml.append(XmlHandler.addTagValue((String)MESSAGE_FIELD, (String)this.messageField));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.namespace = XmlHandler.getTagValue((Node)transformNode, (String)NAMESPACE);
        this.eventHubName = XmlHandler.getTagValue((Node)transformNode, (String)EVENT_HUB_NAME);
        this.sasKeyName = XmlHandler.getTagValue((Node)transformNode, (String)SAS_KEY_NAME);
        this.sasKey = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)SAS_KEY));
        this.batchSize = XmlHandler.getTagValue((Node)transformNode, (String)BATCH_SIZE);
        this.messageField = XmlHandler.getTagValue((Node)transformNode, (String)MESSAGE_FIELD);
        super.loadXml(transformNode, metadataProvider);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public void setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
    }

    public String getSasKeyName() {
        return this.sasKeyName;
    }

    public void setSasKeyName(String sasKeyName) {
        this.sasKeyName = sasKeyName;
    }

    public String getSasKey() {
        return this.sasKey;
    }

    public void setSasKey(String sasKey) {
        this.sasKey = sasKey;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }
}

