/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.write;

import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventhubs.EventHubException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.write.AzureWriterData;
import org.apache.hop.pipeline.transforms.eventhubs.write.AzureWriterMeta;

public class AzureWrite
extends BaseTransform<AzureWriterMeta, AzureWriterData>
implements ITransform<AzureWriterMeta, AzureWriterData> {
    public AzureWrite(TransformMeta TransformMeta2, AzureWriterMeta meta, AzureWriterData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(TransformMeta2, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((AzureWriterData)this.data).batchSize = Const.toLong((String)this.resolve(((AzureWriterMeta)this.meta).getBatchSize()), (long)1L);
        ((AzureWriterData)this.data).list = new LinkedList();
        return super.init();
    }

    public void dispose() {
        ((AzureWriterData)this.data).executorService.shutdown();
        super.dispose();
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            if (((AzureWriterData)this.data).batchSize > 1L && ((AzureWriterData)this.data).list.size() > 0) {
                try {
                    ((AzureWriterData)this.data).eventHubClient.sendSync(((AzureWriterData)this.data).list);
                }
                catch (EventHubException e) {
                    throw new HopTransformException("Unable to send messages", (Throwable)e);
                }
                ((AzureWriterData)this.data).list = null;
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((AzureWriterData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((AzureWriterMeta)this.meta).getFields(((AzureWriterData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            ((AzureWriterData)this.data).fieldIndex = this.getInputRowMeta().indexOfValue(((AzureWriterMeta)this.meta).getMessageField());
            if (((AzureWriterData)this.data).fieldIndex < 0) {
                throw new HopTransformException("Unable to find field '" + ((AzureWriterMeta)this.meta).getMessageField() + "' in the Transform input");
            }
            this.log.logBasic("Creating connection string");
            String namespace = this.resolve(((AzureWriterMeta)this.meta).getNamespace());
            String eventHubName = this.resolve(((AzureWriterMeta)this.meta).getEventHubName());
            String sasKeyName = this.resolve(((AzureWriterMeta)this.meta).getSasKeyName());
            String sasKey = this.resolve(((AzureWriterMeta)this.meta).getSasKey());
            ((AzureWriterData)this.data).connectionStringBuilder = new ConnectionStringBuilder().setNamespaceName(namespace).setEventHubName(eventHubName).setSasKeyName(sasKeyName).setSasKey(sasKey);
            this.log.logBasic("Opening new executor service");
            ((AzureWriterData)this.data).executorService = Executors.newSingleThreadScheduledExecutor();
            this.log.logBasic("Creating event hub client");
            try {
                ((AzureWriterData)this.data).eventHubClient = EventHubClient.createFromConnectionStringSync((String)((AzureWriterData)this.data).connectionStringBuilder.toString(), (ScheduledExecutorService)((AzureWriterData)this.data).executorService);
            }
            catch (Exception e) {
                throw new HopTransformException("Unable to create event hub client", (Throwable)e);
            }
        }
        String message = this.getInputRowMeta().getString(row, ((AzureWriterData)this.data).fieldIndex);
        byte[] payloadBytes = message.getBytes(StandardCharsets.UTF_8);
        EventData sendEvent = EventData.create((byte[])payloadBytes);
        try {
            if (((AzureWriterData)this.data).batchSize <= 1L) {
                ((AzureWriterData)this.data).eventHubClient.sendSync(sendEvent);
            } else {
                ((AzureWriterData)this.data).list.add(sendEvent);
                if ((long)((AzureWriterData)this.data).list.size() >= ((AzureWriterData)this.data).batchSize) {
                    ((AzureWriterData)this.data).eventHubClient.sendSync(((AzureWriterData)this.data).list);
                    ((AzureWriterData)this.data).list.clear();
                }
            }
        }
        catch (EventHubException e) {
            throw new HopTransformException("Unable to send message to event hubs", (Throwable)e);
        }
        this.putRow(((AzureWriterData)this.data).outputRowMeta, row);
        return true;
    }
}

