/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.listen;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventprocessorhost.CloseReason;
import com.microsoft.azure.eventprocessorhost.IEventProcessor;
import com.microsoft.azure.eventprocessorhost.PartitionContext;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListener;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerData;

public class AzureListenerEventProcessor
implements IEventProcessor {
    private final AzureListener azureTransform;
    private final AzureListenerData azureData;
    private int checkpointBatchingSize;
    private int checkpointBatchingCount;
    private long lastIterationTime = -1L;
    private long passedRowsCount;
    private AtomicBoolean wait = new AtomicBoolean(false);
    private PartitionContext lastContext;
    private EventData lastData;

    public AzureListenerEventProcessor(AzureListener Transform2, AzureListenerData data, int checkpointBatchingSize) {
        this.azureTransform = Transform2;
        this.azureData = data;
        this.checkpointBatchingSize = checkpointBatchingSize;
        this.passedRowsCount = 0L;
    }

    public void onOpen(PartitionContext context) {
        if (this.azureTransform.isDebug()) {
            this.azureTransform.logDebug("Partition " + context.getPartitionId() + " is opening");
        }
    }

    public void onClose(PartitionContext context, CloseReason reason) {
        if (this.azureTransform.isDebug()) {
            this.azureTransform.logDebug("Partition " + context.getPartitionId() + " is closing for reason " + reason.toString());
        }
    }

    public void onError(PartitionContext context, Throwable error) {
        this.azureTransform.logError("Error on partition id " + context.getPartitionId() + " : " + error.toString(), error);
    }

    public void onEvents(PartitionContext context, Iterable<EventData> events) throws Exception {
        if (this.lastIterationTime < 0L) {
            this.lastIterationTime = System.currentTimeMillis();
        }
        while (this.wait.get() && !this.azureTransform.isStopped()) {
            Thread.sleep(10L);
        }
        int eventCount = 0;
        for (EventData data : events) {
            this.azureTransform.incrementLinesInput();
            try {
                Object[] row = RowDataUtil.allocateRowData((int)this.azureData.outputRowMeta.size());
                int index = 0;
                if (StringUtils.isNotEmpty((String)this.azureData.outputField)) {
                    row[index++] = new String(data.getBytes(), "UTF-8");
                }
                if (StringUtils.isNotEmpty((String)this.azureData.partitionIdField)) {
                    row[index++] = context.getPartitionId();
                }
                if (StringUtils.isNotEmpty((String)this.azureData.offsetField)) {
                    row[index++] = data.getSystemProperties().getOffset();
                }
                if (StringUtils.isNotEmpty((String)this.azureData.sequenceNumberField)) {
                    row[index++] = data.getSystemProperties().getSequenceNumber();
                }
                if (StringUtils.isNotEmpty((String)this.azureData.hostField)) {
                    row[index++] = context.getOwner();
                }
                if (StringUtils.isNotEmpty((String)this.azureData.enqueuedTimeField)) {
                    Instant enqueuedTime = data.getSystemProperties().getEnqueuedTime();
                    row[index++] = Timestamp.from(enqueuedTime);
                }
                if (this.azureData.stt) {
                    this.azureData.sttRowProducer.putRow(this.azureData.outputRowMeta, row);
                    ++this.passedRowsCount;
                    this.lastContext = context;
                    this.lastData = data;
                } else {
                    this.azureTransform.putRow(this.azureData.outputRowMeta, row);
                }
                if (this.azureTransform.isDebug()) {
                    this.azureTransform.logDebug("Event read and passed for PartitionId (" + context.getPartitionId() + "," + data.getSystemProperties().getOffset() + "," + data.getSystemProperties().getSequenceNumber() + "): " + new String(data.getBytes(), "UTF8") + " (" + index + " values in row)");
                }
                ++eventCount;
                ++this.checkpointBatchingCount;
                if (this.checkpointBatchingCount % this.checkpointBatchingSize != 0) continue;
                if (this.azureTransform.isDebug()) {
                    this.azureTransform.logDebug("Partition " + context.getPartitionId() + " checkpointing at " + data.getSystemProperties().getOffset() + "," + data.getSystemProperties().getSequenceNumber());
                }
                if (this.azureData.stt) {
                    if (this.azureTransform.isDetailed()) {
                        this.azureTransform.logDetailed("Processing the rows sent to the batch transformation at event count " + this.checkpointBatchingCount);
                    }
                    this.doOneIteration();
                    continue;
                }
                context.checkpoint(data).get();
            }
            catch (Exception e) {
                this.azureTransform.logError("Processing failed for an event: " + e.toString(), e);
                this.azureTransform.setErrors(1L);
                this.azureTransform.stopAll();
            }
        }
        if (this.azureTransform.isDebug()) {
            this.azureTransform.logDebug("Partition " + context.getPartitionId() + " batch size was " + eventCount + " for host " + context.getOwner());
        }
    }

    public synchronized void doOneIteration() throws HopException {
        this.azureData.sttExecutor.oneIteration();
        this.passedRowsCount = 0L;
        this.lastIterationTime = System.currentTimeMillis();
        if (this.azureData.sttExecutor.isStopped() || this.azureData.sttExecutor.getErrors() > 0L) {
            this.azureData.sttPipeline.stopAll();
            this.azureTransform.setErrors(1L);
            this.azureTransform.setStopped(true);
            this.azureTransform.stopAll();
            throw new HopException("Error in batch transformation, halting");
        }
        try {
            this.lastContext.checkpoint(this.lastData).get();
        }
        catch (Exception e) {
            throw new HopException("Failed to do checkpoint", (Throwable)e);
        }
    }

    public int getCheckpointBatchingSize() {
        return this.checkpointBatchingSize;
    }

    public void setCheckpointBatchingSize(int checkpointBatchingSize) {
        this.checkpointBatchingSize = checkpointBatchingSize;
    }

    public int getCheckpointBatchingCount() {
        return this.checkpointBatchingCount;
    }

    public void setCheckpointBatchingCount(int checkpointBatchingCount) {
        this.checkpointBatchingCount = checkpointBatchingCount;
    }

    public AzureListener getAzureTransform() {
        return this.azureTransform;
    }

    public AzureListenerData getAzureData() {
        return this.azureData;
    }

    public long getLastIterationTime() {
        return this.lastIterationTime;
    }

    public void setLastIterationTime(long lastIterationTime) {
        this.lastIterationTime = lastIterationTime;
    }

    public long getPassedRowsCount() {
        return this.passedRowsCount;
    }

    public void setPassedRowsCount(long passedRowsCount) {
        this.passedRowsCount = passedRowsCount;
    }

    public void startWait() {
        this.wait.set(true);
    }

    public void endWait() {
        this.wait.set(false);
    }
}

