/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.listen;

import com.microsoft.azure.eventhubs.ConnectionStringBuilder;
import com.microsoft.azure.eventhubs.EventHubClient;
import com.microsoft.azure.eventprocessorhost.EventProcessorHost;
import com.microsoft.azure.eventprocessorhost.EventProcessorOptions;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.SingleThreadedPipelineExecutor;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerData;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerErrorNotificationHandler;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerEventProcessor;
import org.apache.hop.pipeline.transforms.eventhubs.listen.AzureListenerMeta;

public class AzureListener
extends BaseTransform<AzureListenerMeta, AzureListenerData>
implements ITransform<AzureListenerMeta, AzureListenerData> {
    public AzureListener(TransformMeta TransformMeta2, AzureListenerMeta meta, AzureListenerData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(TransformMeta2, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        ((AzureListenerData)this.data).batchSize = Const.toInt((String)this.resolve(((AzureListenerMeta)this.meta).getBatchSize()), (int)100);
        ((AzureListenerData)this.data).prefetchSize = Const.toInt((String)this.resolve(((AzureListenerMeta)this.meta).getPrefetchSize()), (int)-1);
        ((AzureListenerData)this.data).list = new LinkedList();
        return super.init();
    }

    public void dispose() {
        ((AzureListenerData)this.data).executorService.shutdown();
        super.dispose();
    }

    public boolean processRow() throws HopException {
        EventProcessorHost host;
        ((AzureListenerData)this.data).outputRowMeta = new RowMeta();
        ((AzureListenerMeta)this.meta).getRegularRowMeta(((AzureListenerData)this.data).outputRowMeta, (IVariables)this);
        ((AzureListenerData)this.data).outputField = this.resolve(((AzureListenerMeta)this.meta).getOutputField());
        ((AzureListenerData)this.data).partitionIdField = this.resolve(((AzureListenerMeta)this.meta).getPartitionIdField());
        ((AzureListenerData)this.data).offsetField = this.resolve(((AzureListenerMeta)this.meta).getOffsetField());
        ((AzureListenerData)this.data).sequenceNumberField = this.resolve(((AzureListenerMeta)this.meta).getSequenceNumberField());
        ((AzureListenerData)this.data).hostField = this.resolve(((AzureListenerMeta)this.meta).getHostField());
        ((AzureListenerData)this.data).enqueuedTimeField = this.resolve(((AzureListenerMeta)this.meta).getEnqueuedTimeField());
        String namespace = this.resolve(((AzureListenerMeta)this.meta).getNamespace());
        String eventHubName = this.resolve(((AzureListenerMeta)this.meta).getEventHubName());
        String sasKeyName = this.resolve(((AzureListenerMeta)this.meta).getSasKeyName());
        String sasKey = this.resolve(((AzureListenerMeta)this.meta).getSasKey());
        String consumerGroupName = this.resolve(((AzureListenerMeta)this.meta).getConsumerGroupName());
        String storageContainerName = this.resolve(((AzureListenerMeta)this.meta).getStorageContainerName());
        String storageConnectionString = this.resolve(((AzureListenerMeta)this.meta).getStorageConnectionString());
        String batchTransformationFile = this.resolve(((AzureListenerMeta)this.meta).getBatchPipeline());
        String batchInputTransform = this.resolve(((AzureListenerMeta)this.meta).getBatchInputTransform());
        String batchOutputTransform = this.resolve(((AzureListenerMeta)this.meta).getBatchOutputTransform());
        if (StringUtils.isNotEmpty((String)batchTransformationFile) && StringUtils.isNotEmpty((String)batchInputTransform)) {
            this.logBasic("Passing rows to a batching transformation running single threaded : " + batchTransformationFile);
            ((AzureListenerData)this.data).stt = true;
            ((AzureListenerData)this.data).sttMaxWaitTime = Const.toLong((String)this.resolve(((AzureListenerMeta)this.meta).getBatchMaxWaitTime()), (long)-1L);
            AzureListenerMeta cfr_ignored_0 = (AzureListenerMeta)this.meta;
            ((AzureListenerData)this.data).sttPipelineMeta = AzureListenerMeta.loadBatchPipelineMeta((AzureListenerMeta)this.meta, this.metadataProvider, (IVariables)this);
            ((AzureListenerData)this.data).sttPipelineMeta.setPipelineType(PipelineMeta.PipelineType.SingleThreaded);
            ((AzureListenerData)this.data).sttPipeline = new LocalPipelineEngine(((AzureListenerData)this.data).sttPipelineMeta, (IVariables)this, (ILoggingObject)this);
            ((AzureListenerData)this.data).sttPipeline.setParent((ILoggingObject)this.getPipeline());
            ((AzureListenerData)this.data).sttPipeline.setParentPipeline(this.getPipeline());
            this.getPipeline().addActiveSubPipeline(this.getTransformName(), (IPipelineEngine)((AzureListenerData)this.data).sttPipeline);
            ((AzureListenerData)this.data).sttPipeline.prepareExecution();
            ((AzureListenerData)this.data).sttRowProducer = ((AzureListenerData)this.data).sttPipeline.addRowProducer(batchInputTransform, 0);
            if (StringUtils.isNotEmpty((String)batchOutputTransform)) {
                ITransform outputTransform = ((AzureListenerData)this.data).sttPipeline.findRunThread(batchOutputTransform);
                if (outputTransform == null) {
                    throw new HopTransformException("Unable to find output transform '" + batchOutputTransform + "'in batch pipeline");
                }
                outputTransform.addRowListener((IRowListener)new RowAdapter(){

                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        AzureListener.this.putRow(rowMeta, row);
                    }
                });
            }
            ((AzureListenerData)this.data).sttPipeline.startThreads();
            ((AzureListenerData)this.data).sttExecutor = new SingleThreadedPipelineExecutor(((AzureListenerData)this.data).sttPipeline);
            boolean ok = ((AzureListenerData)this.data).sttExecutor.init();
            if (!ok) {
                this.logError("Initializing batch transformation failed");
                this.stopAll();
                this.setErrors(1L);
                return false;
            }
        } else {
            ((AzureListenerData)this.data).stt = false;
        }
        this.log.logDetailed("Creating connection string builder");
        ((AzureListenerData)this.data).connectionStringBuilder = new ConnectionStringBuilder().setNamespaceName(namespace).setEventHubName(eventHubName).setSasKeyName(sasKeyName).setSasKey(sasKey);
        this.log.logDetailed("Opening new executor service");
        ((AzureListenerData)this.data).executorService = Executors.newSingleThreadScheduledExecutor();
        this.log.logDetailed("Creating event hub client");
        try {
            ((AzureListenerData)this.data).eventHubClient = EventHubClient.createFromConnectionStringSync((String)((AzureListenerData)this.data).connectionStringBuilder.toString(), (ScheduledExecutorService)((AzureListenerData)this.data).executorService);
        }
        catch (Exception e2) {
            throw new HopTransformException("Unable to create event hub client", (Throwable)e2);
        }
        try {
            host = EventProcessorHost.EventProcessorHostBuilder.newBuilder((String)EventProcessorHost.createHostName((String)"HopHost"), (String)consumerGroupName).useAzureStorageCheckpointLeaseManager(storageConnectionString, storageContainerName, "hop").useEventHubConnectionString(((AzureListenerData)this.data).connectionStringBuilder.toString()).build();
        }
        catch (Exception e3) {
            throw new HopException("Unable to set up events host processor", (Throwable)e3);
        }
        this.log.logDetailed("Set up events host named " + host.getHostName());
        EventProcessorOptions options = new EventProcessorOptions();
        options.setExceptionNotification((Consumer)new AzureListenerErrorNotificationHandler(this));
        if (!StringUtils.isNotEmpty((String)((AzureListenerMeta)this.meta).getBatchSize())) {
            options.setMaxBatchSize(Const.toInt((String)this.resolve(((AzureListenerMeta)this.meta).getBatchSize()), (int)100));
        }
        if (!StringUtils.isNotEmpty((String)((AzureListenerMeta)this.meta).getPrefetchSize())) {
            options.setPrefetchCount(Const.toInt((String)this.resolve(((AzureListenerMeta)this.meta).getPrefetchSize()), (int)100));
        }
        ((AzureListenerData)this.data).executorService = Executors.newSingleThreadScheduledExecutor();
        try {
            ((AzureListenerData)this.data).eventHubClient = EventHubClient.createFromConnectionStringSync((String)((AzureListenerData)this.data).connectionStringBuilder.toString(), (ScheduledExecutorService)((AzureListenerData)this.data).executorService);
        }
        catch (Exception e4) {
            throw new HopTransformException("Unable to create event hub client", (Throwable)e4);
        }
        final AzureListenerEventProcessor eventProcessor = new AzureListenerEventProcessor(this, (AzureListenerData)this.data, ((AzureListenerData)this.data).batchSize);
        if (((AzureListenerData)this.data).stt && ((AzureListenerData)this.data).sttMaxWaitTime > 0L) {
            this.logBasic("Checking for stalled rows every 100ms to see if we exceed the maximum wait time: " + ((AzureListenerData)this.data).sttMaxWaitTime);
            try {
                Timer timer = new Timer();
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        long now;
                        long diff;
                        if (eventProcessor.getLastIterationTime() > 0L && eventProcessor.getPassedRowsCount() > 0L && (diff = (now = System.currentTimeMillis()) - eventProcessor.getLastIterationTime()) > ((AzureListenerData)((AzureListener)AzureListener.this).data).sttMaxWaitTime) {
                            AzureListener.this.logDetailed("Stalled rows detected with wait time of " + (double)diff / 1000.0);
                            try {
                                eventProcessor.startWait();
                                eventProcessor.doOneIteration();
                            }
                            catch (Exception e) {
                                throw new RuntimeException("Error in batch iteration when max wait time was exceeded", e);
                            }
                            finally {
                                eventProcessor.endWait();
                            }
                            AzureListener.this.logDetailed("Done processing after max wait time.");
                        }
                    }
                };
                timer.schedule(timerTask, 100L, 100L);
            }
            catch (RuntimeException e5) {
                throw new HopTransformException("Error in batch iteration when max wait time was exceeded", (Throwable)e5);
            }
        }
        try {
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)host.registerEventProcessorFactory(partitionContext -> eventProcessor).whenComplete((unused, e) -> {
                if (e != null) {
                    this.logError("Failure while registering: " + e.toString());
                    if (e.getCause() != null) {
                        this.logError("Inner exception: " + e.getCause().toString());
                    }
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                }
            })).thenAccept(unused -> {
                while (!this.isStopped() && !this.outputIsDone()) {
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            })).thenCompose(unused -> host.unregisterEventProcessor())).exceptionally(e -> {
                this.logError("Failure while unregistering: " + e.toString());
                if (e.getCause() != null) {
                    this.logError("Inner exception: " + e.getCause().toString());
                }
                return null;
            })).get();
        }
        catch (Exception e6) {
            throw new HopException("Error in event processor", (Throwable)e6);
        }
        this.setOutputDone();
        return false;
    }
}

