/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadata;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataData;
import org.w3c.dom.Node;

@Transform(id="FileMetadataPlugin", name="i18n::FileMetadata.Name.Default", image="icon.svg", description="i18n::FileMetadata.Name.Desc", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/filemetadata.html")
public class FileMetadataMeta
extends BaseTransformMeta
implements ITransformMeta<FileMetadata, FileMetadataData> {
    private static final Class<?> PKG = FileMetadataMeta.class;
    private String fileName = "";
    private String limitRows = "0";
    private String defaultCharset = "ISO-8859-1";
    private ArrayList<String> delimiterCandidates = new ArrayList(5);
    private ArrayList<String> enclosureCandidates = new ArrayList(5);

    public void setDefault() {
        this.fileName = "";
        this.limitRows = "10000";
        this.defaultCharset = "ISO-8859-1";
        this.delimiterCandidates.clear();
        this.delimiterCandidates.add("\t");
        this.delimiterCandidates.add(";");
        this.delimiterCandidates.add(",");
        this.enclosureCandidates.clear();
        this.enclosureCandidates.add("\"");
        this.enclosureCandidates.add("'");
    }

    public Object clone() {
        FileMetadataMeta copy = (FileMetadataMeta)((Object)super.clone());
        copy.setDelimiterCandidates(new ArrayList<String>(this.delimiterCandidates));
        copy.setEnclosureCandidates(new ArrayList<String>(this.enclosureCandidates));
        return copy;
    }

    public ITransform createTransform(TransformMeta transformMeta, FileMetadataData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new FileMetadata(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public FileMetadataData getTransformData() {
        return new FileMetadataData();
    }

    public String getXml() throws HopValueException {
        StringBuilder buffer = new StringBuilder(800);
        buffer.append("    ").append(XmlHandler.addTagValue((String)"fileName", (String)this.fileName));
        buffer.append("    ").append(XmlHandler.addTagValue((String)"limitRows", (String)this.limitRows));
        buffer.append("    ").append(XmlHandler.addTagValue((String)"defaultCharset", (String)this.defaultCharset));
        for (String delimiterCandidate : this.delimiterCandidates) {
            buffer.append("      <delimiterCandidate>").append(Const.CR);
            buffer.append("        ").append(XmlHandler.addTagValue((String)"candidate", (String)delimiterCandidate));
            buffer.append("      </delimiterCandidate>").append(Const.CR);
        }
        for (String enclosureCandidate : this.enclosureCandidates) {
            buffer.append("      <enclosureCandidate>").append(Const.CR);
            buffer.append("        ").append(XmlHandler.addTagValue((String)"candidate", (String)enclosureCandidate));
            buffer.append("      </enclosureCandidate>").append(Const.CR);
        }
        return buffer.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.setFileName(XmlHandler.getNodeValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"fileName")));
            this.setLimitRows(XmlHandler.getNodeValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"limitRows")));
            this.setDefaultCharset(XmlHandler.getNodeValue((Node)XmlHandler.getSubNode((Node)transformNode, (String)"defaultCharset")));
            int nrDelimiters = XmlHandler.countNodes((Node)transformNode, (String)"delimiterCandidate");
            this.delimiterCandidates.clear();
            for (int i = 0; i < nrDelimiters; ++i) {
                Node node = XmlHandler.getSubNodeByNr((Node)transformNode, (String)"delimiterCandidate", (int)i);
                String candidate = XmlHandler.getTagValue((Node)node, (String)"candidate");
                this.delimiterCandidates.add(candidate);
            }
            int nrEnclosures = XmlHandler.countNodes((Node)transformNode, (String)"enclosureCandidate");
            this.enclosureCandidates.clear();
            for (int i = 0; i < nrEnclosures; ++i) {
                Node node = XmlHandler.getSubNodeByNr((Node)transformNode, (String)"enclosureCandidate", (int)i);
                String candidate = XmlHandler.getTagValue((Node)node, (String)"candidate");
                this.enclosureCandidates.add(candidate);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("File metadata plugin unable to read transform info from XML node", (Throwable)e);
        }
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("charset"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("delimiter"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("enclosure"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("field_count"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("skip_header_lines"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("skip_footer_lines"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaBoolean("header_line_present"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("name"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("type"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("length"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger("precision"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("mask"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("decimal_symbol"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("grouping_symbol"));
    }

    public ArrayList<String> getDelimiterCandidates() {
        return this.delimiterCandidates;
    }

    public void setDelimiterCandidates(ArrayList<String> delimiterCandidates) {
        this.delimiterCandidates = delimiterCandidates;
    }

    public ArrayList<String> getEnclosureCandidates() {
        return this.enclosureCandidates;
    }

    public void setEnclosureCandidates(ArrayList<String> enclosureCandidates) {
        this.enclosureCandidates = enclosureCandidates;
    }

    public String getLimitRows() {
        return this.limitRows;
    }

    public void setLimitRows(String limitRows) {
        this.limitRows = limitRows;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

