/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FileMetadataDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FileMetadataMeta.class;
    private FileMetadataMeta meta;
    private TextVar wFilename;
    private TableView wDelimiterCandidates;
    private TableView wEnclosureCandidates;
    private TextVar wLimit;
    private ComboVar wDefaultCharset;
    private boolean gotEncodings = false;

    public FileMetadataDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.meta = (FileMetadataMeta)((Object)in);
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wDefaultCharset.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wDefaultCharset.add(charSet.displayName());
            }
            String defEncoding = this.meta.getDefaultCharset();
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wDefaultCharset.getItems());
            if (idx >= 0) {
                this.wDefaultCharset.select(idx);
            }
        }
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.meta);
        this.changed = this.meta.hasChanged();
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileMetadataDialog.this.meta.setChanged();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FileMetadata.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Button wbbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.top = new FormAttachment((Control)lastControl, margin);
        fdbFilename.right = new FormAttachment(100, 0);
        wbbFilename.setLayoutData((Object)fdbFilename);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"FileMetadata.Filename", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.top = new FormAttachment((Control)lastControl, margin);
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.top = new FormAttachment((Control)lastControl, margin);
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        lastControl = this.wFilename;
        Group gDelimitedLayout = new Group((Composite)this.shell, 16);
        gDelimitedLayout.setText("Delimited Layout");
        FormLayout gDelimitedLayoutLayout = new FormLayout();
        gDelimitedLayoutLayout.marginWidth = 3;
        gDelimitedLayoutLayout.marginHeight = 3;
        gDelimitedLayout.setLayout((Layout)gDelimitedLayoutLayout);
        this.props.setLook((Control)gDelimitedLayout);
        Label wlLimit = new Label((Composite)gDelimitedLayout, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.limit", (String[])new String[0]));
        this.props.setLook((Control)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.top = new FormAttachment(0, margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new TextVar(this.variables, (Composite)gDelimitedLayout, 18436);
        this.wLimit.setToolTipText(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.limit.tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.top = new FormAttachment(0, margin);
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        lastControl = this.wLimit;
        Label wlEncoding = new Label((Composite)gDelimitedLayout, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.default_charset", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlDefaultCharset = new FormData();
        fdlDefaultCharset.top = new FormAttachment((Control)lastControl, margin);
        fdlDefaultCharset.left = new FormAttachment(0, 0);
        fdlDefaultCharset.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlDefaultCharset);
        this.wDefaultCharset = new ComboVar(this.variables, (Composite)gDelimitedLayout, 18436);
        this.props.setLook((Control)this.wDefaultCharset);
        this.wDefaultCharset.addModifyListener(lsMod);
        FormData fdDefaultCharset = new FormData();
        fdDefaultCharset.top = new FormAttachment((Control)lastControl, margin);
        fdDefaultCharset.left = new FormAttachment(middle, 0);
        fdDefaultCharset.right = new FormAttachment(100, 0);
        this.wDefaultCharset.setLayoutData((Object)fdDefaultCharset);
        lastControl = this.wDefaultCharset;
        this.wDefaultCharset.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FileMetadataDialog.this.shell.getDisplay(), 1);
                FileMetadataDialog.this.shell.setCursor(busy);
                FileMetadataDialog.this.setEncodings();
                FileMetadataDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        int candidateCount = this.meta.getDelimiterCandidates().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.delimiter_candidates", (String[])new String[0]), 1, false)};
        colinf[0].setUsingVariables(true);
        this.wDelimiterCandidates = new TableView(this.variables, (Composite)gDelimitedLayout, 67586, colinf, candidateCount, lsMod, this.props);
        FormData fdDelimiterCandidates = new FormData();
        fdDelimiterCandidates.left = new FormAttachment(0, 0);
        fdDelimiterCandidates.right = new FormAttachment(100, 0);
        fdDelimiterCandidates.top = new FormAttachment((Control)this.wDefaultCharset, margin);
        fdDelimiterCandidates.bottom = new FormAttachment(50, 0);
        this.wDelimiterCandidates.setLayoutData((Object)fdDelimiterCandidates);
        candidateCount = this.meta.getEnclosureCandidates().size();
        colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FileMetadata.methods.DELIMITED_FIELDS.enclosure_candidates", (String[])new String[0]), 1, false)};
        colinf[0].setUsingVariables(true);
        this.wEnclosureCandidates = new TableView(this.variables, (Composite)gDelimitedLayout, 67586, colinf, candidateCount, lsMod, this.props);
        FormData fdEnclosureCandidates = new FormData();
        fdEnclosureCandidates.left = new FormAttachment(0, 0);
        fdEnclosureCandidates.right = new FormAttachment(100, 0);
        fdEnclosureCandidates.top = new FormAttachment(50, margin);
        fdEnclosureCandidates.bottom = new FormAttachment(100, 0);
        this.wEnclosureCandidates.setLayoutData((Object)fdEnclosureCandidates);
        FormData fdQueryGroup = new FormData();
        fdQueryGroup.left = new FormAttachment(0, 0);
        fdQueryGroup.right = new FormAttachment(100, 0);
        fdQueryGroup.top = new FormAttachment((Control)this.wFilename, margin);
        fdQueryGroup.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        gDelimitedLayout.setLayoutData((Object)fdQueryGroup);
        this.populateDialog();
        this.meta.setChanged(this.changed);
        wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(FileMetadataDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.txt;*.csv", "*.csv", "*.txt", "*"});
                if (FileMetadataDialog.this.wFilename.getText() != null) {
                    String fileName = FileMetadataDialog.this.variables.resolve(FileMetadataDialog.this.wFilename.getText());
                    dialog.setFileName(fileName);
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]) + ", " + BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    FileMetadataDialog.this.wFilename.setText(str);
                }
            }
        });
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void populateDialog() {
        TableItem item;
        String candidate;
        int i;
        this.wTransformName.selectAll();
        if (this.meta.getFileName() != null) {
            this.wFilename.setText(this.meta.getFileName());
        }
        if (this.meta.getLimitRows() != null) {
            this.wLimit.setText(this.meta.getLimitRows());
        }
        if (this.meta.getDefaultCharset() != null) {
            this.wDefaultCharset.setText(this.meta.getDefaultCharset());
        }
        if (this.meta.getDelimiterCandidates() != null) {
            for (i = 0; i < this.meta.getDelimiterCandidates().size(); ++i) {
                candidate = this.meta.getDelimiterCandidates().get(i);
                item = this.wDelimiterCandidates.table.getItem(i);
                item.setText(1, Const.NVL((String)candidate, (String)""));
            }
        }
        if (this.meta.getEnclosureCandidates() != null) {
            for (i = 0; i < this.meta.getEnclosureCandidates().size(); ++i) {
                candidate = this.meta.getEnclosureCandidates().get(i);
                item = this.wEnclosureCandidates.table.getItem(i);
                item.setText(1, Const.NVL((String)candidate, (String)""));
            }
        }
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        this.transformName = this.wTransformName.getText();
        this.meta.setFileName(this.wFilename.getText());
        this.meta.setLimitRows(this.wLimit.getText());
        this.meta.setDefaultCharset(this.wDefaultCharset.getText());
        ArrayList<String> candidates = this.meta.getDelimiterCandidates();
        candidates.clear();
        int nrItems = this.wDelimiterCandidates.nrNonEmpty();
        for (i = 0; i < nrItems; ++i) {
            item = this.wDelimiterCandidates.getNonEmpty(i);
            candidates.add(item.getText(1));
        }
        candidates = this.meta.getEnclosureCandidates();
        candidates.clear();
        nrItems = this.wEnclosureCandidates.nrNonEmpty();
        for (i = 0; i < nrItems; ++i) {
            item = this.wEnclosureCandidates.getNonEmpty(i);
            candidates.add(item.getText(1));
        }
        this.dispose();
    }
}

