/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.filemetadata;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringEvaluator;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataData;
import org.apache.hop.pipeline.transforms.filemetadata.FileMetadataMeta;
import org.apache.hop.pipeline.transforms.filemetadata.util.delimiters.DelimiterDetector;
import org.apache.hop.pipeline.transforms.filemetadata.util.delimiters.DelimiterDetectorBuilder;
import org.apache.hop.pipeline.transforms.filemetadata.util.encoding.EncodingDetector;

public class FileMetadata
extends BaseTransform<FileMetadataMeta, FileMetadataData>
implements ITransform<FileMetadataMeta, FileMetadataData> {
    private Object[] r;
    private int idx;
    private Object[] outputRow;
    private DelimiterDetector.DetectionResult delimiters;
    private String fileName;
    private Charset detectedCharset;
    private Charset defaultCharset = Charsets.ISO_8859_1;
    private long limitRows;

    public FileMetadata(TransformMeta transformMeta, FileMetadataMeta meta, FileMetadataData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        return super.init();
    }

    public boolean processRow() throws HopException {
        this.r = this.getRow();
        if (this.first) {
            this.first = false;
            ((FileMetadataData)this.data).isReceivingInput = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta()).size() > 0;
            ((FileMetadataData)this.data).outputRowMeta = ((FileMetadataData)this.data).isReceivingInput ? this.getInputRowMeta().clone() : new RowMeta();
            ((FileMetadataMeta)this.meta).getFields(((FileMetadataData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
        }
        if (((FileMetadataData)this.data).isReceivingInput) {
            if (this.r == null) {
                this.setOutputDone();
                return false;
            }
            this.buildOutputRows();
            if (this.checkFeedback(this.getLinesRead())) {
                this.logBasic("LineNr " + this.getLinesRead());
            }
            return true;
        }
        this.buildOutputRows();
        this.setOutputDone();
        return false;
    }

    private void buildOutputRows() throws HopTransformException {
        this.idx = ((FileMetadataData)this.data).isReceivingInput ? this.getInputRowMeta().size() : 0;
        this.outputRow = ((FileMetadataData)this.data).isReceivingInput ? RowDataUtil.createResizedCopy((Object[])this.r, (int)((FileMetadataData)this.data).outputRowMeta.size()) : RowDataUtil.allocateRowData((int)((FileMetadataData)this.data).outputRowMeta.size());
        this.fileName = this.resolve(((FileMetadataMeta)this.meta).getFileName());
        try {
            if (!HopVfs.fileExists((String)this.fileName)) {
                this.putRow(((FileMetadataData)this.data).outputRowMeta, this.outputRow);
                return;
            }
        }
        catch (HopFileException e) {
            throw new HopTransformException(e.getMessage(), (Throwable)e);
        }
        String strLimitRows = this.resolve(((FileMetadataMeta)this.meta).getLimitRows());
        this.limitRows = strLimitRows.trim().isEmpty() ? 0L : Long.parseLong(strLimitRows);
        this.defaultCharset = Charset.forName(this.resolve(((FileMetadataMeta)this.meta).getDefaultCharset()));
        ArrayList<Character> delimiterCandidates = new ArrayList<Character>(4);
        for (String string : ((FileMetadataMeta)this.meta).getDelimiterCandidates()) {
            String string2 = this.resolve(string);
            if (string2.length() == 0) {
                this.logBasic("Warning: file metadata transform ignores empty delimiter candidate");
                continue;
            }
            if (string2.length() > 1) {
                this.logBasic("Warning: file metadata transform ignores non-character delimiter candidate: " + string2);
                continue;
            }
            delimiterCandidates.add(Character.valueOf(string2.charAt(0)));
        }
        ArrayList<Character> enclosureCandidates = new ArrayList<Character>(4);
        for (String candidate : ((FileMetadataMeta)this.meta).getEnclosureCandidates()) {
            if ((candidate = this.resolve(candidate)).length() == 0) {
                this.logBasic("Warning: file metadata transform ignores empty enclosure candidate");
                continue;
            }
            if (candidate.length() > 1) {
                this.logBasic("Warning: file metadata transform ignores non-character enclosure candidate: " + candidate);
                continue;
            }
            enclosureCandidates.add(Character.valueOf(candidate.charAt(0)));
        }
        this.detectedCharset = this.detectCharset(this.fileName);
        this.outputRow[this.idx++] = this.detectedCharset;
        this.delimiters = this.detectDelimiters(this.fileName, this.detectedCharset, delimiterCandidates, enclosureCandidates);
        if (this.delimiters == null) {
            throw new HopTransformException("Could not determine a consistent format for file " + this.fileName);
        }
        this.outputRow[this.idx++] = this.delimiters.getDelimiter();
        this.outputRow[this.idx++] = this.delimiters.getEnclosure() == null ? "" : this.delimiters.getEnclosure().toString();
        this.outputRow[this.idx++] = this.delimiters.getDataLineFrequency() + 1L;
        this.outputRow[this.idx++] = this.delimiters.getBadHeaders();
        this.outputRow[this.idx++] = this.delimiters.getBadFooters();
        char c = this.delimiters.getDelimiter().charValue();
        char enclosure = this.delimiters.getEnclosure() == null ? (char)'\u0000' : this.delimiters.getEnclosure().charValue();
        long dataLines = this.delimiters.getDataLines();
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(HopVfs.getInputStream((String)this.fileName), this.detectedCharset));){
            int i;
            for (long skipLines = this.delimiters.getBadHeaders(); skipLines > 0L; --skipLines) {
                inputReader.readLine();
            }
            CSVReader csvReader = new CSVReader((Reader)inputReader, c, enclosure);
            String[] firstLine = csvReader.readNext();
            --dataLines;
            StringEvaluator[] evaluators = new StringEvaluator[firstLine.length];
            for (int i3 = 0; i3 < evaluators.length; ++i3) {
                evaluators[i3] = new StringEvaluator(true);
            }
            while (dataLines > 0L) {
                --dataLines;
                String[] fields = csvReader.readNext();
                if (fields == null) break;
                for (int i4 = 0; i4 < fields.length; ++i4) {
                    if (i4 >= evaluators.length) continue;
                    evaluators[i4].evaluateString(fields[i4]);
                }
            }
            IValueMeta[] fields = new IValueMeta[evaluators.length];
            IValueMeta[] firstLineFields = new IValueMeta[evaluators.length];
            for (int i5 = 0; i5 < evaluators.length; ++i5) {
                fields[i5] = evaluators[i5].getAdvicedResult().getConversionMeta();
                evaluators[i5].evaluateString(firstLine[i5]);
                firstLineFields[i5] = evaluators[i5].getAdvicedResult().getConversionMeta();
            }
            boolean hasHeader = false;
            boolean allStrings = true;
            for (int i2 = 0; i2 < evaluators.length; ++i2) {
                if (fields[i2].getType() != 2) {
                    allStrings = false;
                }
                if (fields[i2].getType() == firstLineFields[i2].getType()) continue;
                hasHeader = true;
                break;
            }
            boolean bl = hasHeader = hasHeader || allStrings;
            if (hasHeader) {
                for (int i2 = 0; i2 < evaluators.length; ++i2) {
                    fields[i2].setName(firstLine[i2].trim());
                }
            } else {
                fields = firstLineFields;
                int colNum = 1;
                for (i = 0; i < evaluators.length; ++i) {
                    fields[i].setName("field_" + colNum++);
                }
            }
            this.outputRow[this.idx++] = hasHeader;
            int fieldIdx = this.idx;
            for (i = 0; i < evaluators.length; ++i) {
                this.outputRow = RowDataUtil.createResizedCopy((Object[])this.outputRow, (int)this.outputRow.length);
                this.idx = fieldIdx;
                this.outputRow[this.idx++] = fields[i].getName();
                this.outputRow[this.idx++] = fields[i].getTypeDesc();
                this.outputRow[this.idx++] = fields[i].getLength() >= 0 ? Long.valueOf(fields[i].getLength()) : null;
                this.outputRow[this.idx++] = fields[i].getPrecision() >= 0 ? Long.valueOf(fields[i].getPrecision()) : null;
                this.outputRow[this.idx++] = fields[i].getConversionMask();
                this.outputRow[this.idx++] = fields[i].getDecimalSymbol();
                this.outputRow[this.idx++] = fields[i].getGroupingSymbol();
                this.putRow(((FileMetadataData)this.data).outputRowMeta, this.outputRow);
            }
        }
        catch (IOException | HopFileException e) {
            this.log.logError("IO Error while reading file: " + this.fileName + ". Invalid charset?");
            throw new HopTransformException(e.getMessage(), e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.log.logError("Error determining field types for: " + this.fileName + ". Inconsistent delimiters?");
            throw new HopTransformException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Charset detectCharset(String fileName) {
        try (InputStream stream = HopVfs.getInputStream((String)fileName);){
            Charset charset = EncodingDetector.detectEncoding(stream, this.defaultCharset, this.limitRows * 500L);
            return charset;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + fileName, e);
        }
        catch (IOException | HopFileException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DelimiterDetector.DetectionResult detectDelimiters(String fileName, Charset charset, ArrayList<Character> delimiterCandidates, ArrayList<Character> enclosureCandidates) {
        try (BufferedReader f = new BufferedReader(new InputStreamReader(HopVfs.getInputStream((String)fileName), charset));){
            DelimiterDetector detector = new DelimiterDetectorBuilder().withDelimiterCandidates(delimiterCandidates).withEnclosureCandidates(enclosureCandidates).withInput(f).withLogger(this.log).withRowLimit(this.limitRows).build();
            DelimiterDetector.DetectionResult detectionResult = detector.detectDelimiters();
            return detectionResult;
        }
        catch (IOException | HopFileException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void dispose() {
        super.dispose();
    }
}

