/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.javascript;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigDecimal;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.DataTypeConverter;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.injection.NullNumberConverter;
import org.apache.hop.core.plugins.HopURLClassLoader;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.javascript.ScriptValues;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesAddClasses;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesAddedFunctions;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesData;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesDummy;
import org.apache.hop.pipeline.transforms.javascript.ScriptValuesScript;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Transform(id="ScriptValueMod", image="javascript.svg", name="i18n::ScriptValuesMod.Name", description="i18n::ScriptValuesMod.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Scripting", documentationUrl="/pipeline/transforms/javascript.html")
@InjectionSupported(localizationPrefix="ScriptValuesMod.Injection.", groups={"FIELDS", "SCRIPTS"})
public class ScriptValuesMeta
extends BaseTransformMeta
implements ITransformMeta<ScriptValues, ScriptValuesData> {
    private static final Class<?> PKG = ScriptValuesMeta.class;
    private static final String JSSCRIPT_TAG_TYPE = "jsScript_type";
    private static final String JSSCRIPT_TAG_NAME = "jsScript_name";
    private static final String JSSCRIPT_TAG_SCRIPT = "jsScript_script";
    public static final String OPTIMIZATION_LEVEL_DEFAULT = "9";
    private ScriptValuesAddClasses[] additionalClasses;
    @InjectionDeep
    private ScriptValuesScript[] jsScripts;
    @Injection(name="FIELD_NAME", group="FIELDS")
    private String[] fieldname;
    @Injection(name="FIELD_RENAME_TO", group="FIELDS")
    private String[] rename;
    @Injection(name="FIELD_TYPE", group="FIELDS", convertEmpty=true, converter=DataTypeConverter.class)
    private int[] type;
    @Injection(name="FIELD_LENGTH", group="FIELDS", convertEmpty=true, converter=NullNumberConverter.class)
    private int[] length;
    @Injection(name="FIELD_PRECISION", group="FIELDS", convertEmpty=true, converter=NullNumberConverter.class)
    private int[] precision;
    @Injection(name="FIELD_REPLACE", group="FIELDS")
    private boolean[] replace;
    @Injection(name="OPTIMIZATION_LEVEL")
    private String optimizationLevel;

    public ScriptValuesMeta() {
        try {
            this.parseXmlForAdditionalClasses();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int[] getLength() {
        return this.length;
    }

    public void setLength(int[] length) {
        this.length = length;
    }

    public String[] getFieldname() {
        return this.fieldname;
    }

    public void setFieldname(String[] fieldname) {
        this.fieldname = fieldname;
    }

    public int[] getPrecision() {
        return this.precision;
    }

    public void setPrecision(int[] precision) {
        this.precision = precision;
    }

    public String[] getRename() {
        return this.rename;
    }

    public void setRename(String[] rename) {
        this.rename = rename;
    }

    public int[] getType() {
        return this.type;
    }

    @AfterInjection
    public void afterInjection() {
        this.extend(this.fieldname.length);
    }

    public void setType(int[] type) {
        this.type = type;
    }

    public int getNumberOfJSScripts() {
        return this.jsScripts.length;
    }

    public String[] getJSScriptNames() {
        String[] strJSNames = new String[this.jsScripts.length];
        for (int i = 0; i < this.jsScripts.length; ++i) {
            strJSNames[i] = this.jsScripts[i].getScriptName();
        }
        return strJSNames;
    }

    public ScriptValuesScript[] getJSScripts() {
        return this.jsScripts;
    }

    public void setJSScripts(ScriptValuesScript[] jsScripts) {
        this.jsScripts = jsScripts;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields) {
        int i;
        this.fieldname = new String[nrFields];
        this.rename = new String[nrFields];
        this.type = new int[nrFields];
        for (i = 0; i < nrFields; ++i) {
            this.type[i] = -1;
        }
        this.length = new int[nrFields];
        for (i = 0; i < nrFields; ++i) {
            this.length[i] = -1;
        }
        this.precision = new int[nrFields];
        for (i = 0; i < nrFields; ++i) {
            this.precision[i] = -1;
        }
        this.replace = new boolean[nrFields];
    }

    @VisibleForTesting
    void extend(int nrFields) {
        this.fieldname = this.extend(this.fieldname, nrFields);
        this.rename = this.extend(this.rename, nrFields);
        this.type = this.extend(this.type, nrFields);
        this.length = this.extend(this.length, nrFields);
        this.precision = this.extend(this.precision, nrFields);
        this.replace = this.extend(this.replace, nrFields);
    }

    private String[] extend(String[] array, int nrFields) {
        if (array == null) {
            return new String[nrFields];
        }
        if (array.length < nrFields) {
            return Arrays.copyOf(array, nrFields);
        }
        return array;
    }

    private int[] extend(int[] array, int nrFields) {
        if (array == null || array.length < nrFields) {
            int originalLength = array == null ? 0 : array.length;
            int[] newArray = array == null ? new int[nrFields] : Arrays.copyOf(array, nrFields);
            for (int i = originalLength; i < nrFields; ++i) {
                newArray[i] = -1;
            }
            return newArray;
        }
        return array;
    }

    private boolean[] extend(boolean[] array, int nrFields) {
        if (array == null) {
            return new boolean[nrFields];
        }
        if (array.length < nrFields) {
            return Arrays.copyOf(array, nrFields);
        }
        return array;
    }

    public Object clone() {
        ScriptValuesMeta retval = (ScriptValuesMeta)((Object)super.clone());
        int nrFields = this.fieldname.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldname, 0, retval.fieldname, 0, nrFields);
        System.arraycopy(this.rename, 0, retval.rename, 0, nrFields);
        System.arraycopy(this.type, 0, retval.type, 0, nrFields);
        System.arraycopy(this.length, 0, retval.length, 0, nrFields);
        System.arraycopy(this.precision, 0, retval.precision, 0, nrFields);
        System.arraycopy(this.replace, 0, retval.replace, 0, nrFields);
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, ScriptValuesData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ScriptValues(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fnode;
            int i;
            String script = XmlHandler.getTagValue((Node)transformNode, (String)"script");
            this.optimizationLevel = XmlHandler.getTagValue((Node)transformNode, (String)"optimizationLevel");
            if (!Utils.isEmpty((CharSequence)script)) {
                this.jsScripts = new ScriptValuesScript[1];
                this.jsScripts[0] = new ScriptValuesScript(0, "ScriptValue", script);
            } else {
                Node scripts = XmlHandler.getSubNode((Node)transformNode, (String)"jsScripts");
                int nrscripts = XmlHandler.countNodes((Node)scripts, (String)"jsScript");
                this.jsScripts = new ScriptValuesScript[nrscripts];
                for (i = 0; i < nrscripts; ++i) {
                    fnode = XmlHandler.getSubNodeByNr((Node)scripts, (String)"jsScript", (int)i);
                    this.jsScripts[i] = new ScriptValuesScript(Integer.parseInt(XmlHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_TYPE)), XmlHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_NAME), XmlHandler.getTagValue((Node)fnode, (String)JSSCRIPT_TAG_SCRIPT));
                }
            }
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (i = 0; i < nrFields; ++i) {
                fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldname[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.rename[i] = XmlHandler.getTagValue((Node)fnode, (String)"rename");
                this.type[i] = ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type"));
                String slen = XmlHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XmlHandler.getTagValue((Node)fnode, (String)"precision");
                this.length[i] = Const.toInt((String)slen, (int)-1);
                this.precision[i] = Const.toInt((String)sprc, (int)-1);
                this.replace[i] = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)fnode, (String)"replace"));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.jsScripts = new ScriptValuesScript[1];
        this.jsScripts[0] = new ScriptValuesScript(0, BaseMessages.getString(PKG, (String)"ScriptValuesMod.Script1", (String[])new String[0]), "//" + BaseMessages.getString(PKG, (String)"ScriptValuesMod.ScriptHere", (String[])new String[0]) + Const.CR + Const.CR);
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.fieldname[i] = "newvalue";
            this.rename[i] = "newvalue";
            this.type[i] = 1;
            this.length[i] = -1;
            this.precision[i] = -1;
            this.replace[i] = false;
        }
        this.optimizationLevel = OPTIMIZATION_LEVEL_DEFAULT;
    }

    public void getFields(IRowMeta row, String originTransformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            for (int i = 0; i < this.fieldname.length; ++i) {
                IValueMeta v;
                if (Utils.isEmpty((CharSequence)this.fieldname[i])) continue;
                int valueIndex = -1;
                if (this.replace[i]) {
                    valueIndex = row.indexOfValue(this.fieldname[i]);
                    if (valueIndex < 0) {
                        if (Utils.isEmpty((CharSequence)this.rename[i])) {
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{this.fieldname[i]}));
                        }
                        valueIndex = row.indexOfValue(this.rename[i]);
                        if (valueIndex < 0) {
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.FieldToReplaceNotFound", (String[])new String[]{this.rename[i]}));
                        }
                    }
                    IValueMeta source = row.getValueMeta(valueIndex);
                    v = ValueMetaFactory.cloneValueMeta((IValueMeta)source, (int)this.type[i]);
                    row.setValueMeta(valueIndex, v);
                } else {
                    v = !Utils.isEmpty((CharSequence)this.rename[i]) ? ValueMetaFactory.createValueMeta((String)this.rename[i], (int)this.type[i]) : ValueMetaFactory.createValueMeta((String)this.fieldname[i], (int)this.type[i]);
                }
                v.setLength(this.length[i]);
                v.setPrecision(this.precision[i]);
                v.setOrigin(originTransformName);
                if (this.replace[i]) continue;
                row.addValueMeta(v);
            }
        }
        catch (HopException e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public String getXml() {
        int i;
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"optimizationLevel", (String)this.optimizationLevel));
        retval.append("    <jsScripts>");
        for (i = 0; i < this.jsScripts.length; ++i) {
            retval.append("      <jsScript>");
            retval.append("        ").append(XmlHandler.addTagValue((String)JSSCRIPT_TAG_TYPE, (int)this.jsScripts[i].getScriptType()));
            retval.append("        ").append(XmlHandler.addTagValue((String)JSSCRIPT_TAG_NAME, (String)this.jsScripts[i].getScriptName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)JSSCRIPT_TAG_SCRIPT, (String)this.jsScripts[i].getScript()));
            retval.append("      </jsScript>");
        }
        retval.append("    </jsScripts>");
        retval.append("    <fields>");
        for (i = 0; i < this.fieldname.length; ++i) {
            retval.append("      <field>");
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.fieldname[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"rename", (String)this.rename[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)this.type[i])));
            retval.append("        ").append(XmlHandler.addTagValue((String)"length", (int)this.length[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"precision", (int)this.precision[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"replace", (boolean)this.replace[i]));
            retval.append("      </field>");
        }
        retval.append("    </fields>");
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        int i;
        CheckResult cr;
        boolean errorFound = false;
        String errorMessage = "";
        Context jscx = ContextFactory.getGlobal().enterContext();
        ScriptableObject jsscope = jscx.initStandardObjects(null, false);
        try {
            jscx.setOptimizationLevel(Integer.valueOf(variables.resolve(this.optimizationLevel)).intValue());
        }
        catch (NumberFormatException nfe) {
            errorMessage = "Error with optimization level.  Could not convert the value of " + variables.resolve(this.optimizationLevel) + " to an integer.";
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        catch (IllegalArgumentException iae) {
            cr = new CheckResult(4, iae.getMessage(), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        String strActiveStartScriptName = "";
        String strActiveEndScriptName = "";
        String strActiveScript = "";
        String strActiveStartScript = "";
        String strActiveEndScript = "";
        if (this.jsScripts.length > 0) {
            for (i = 0; i < this.jsScripts.length; ++i) {
                if (this.jsScripts[i].isTransformScript()) {
                    strActiveScript = this.jsScripts[i].getScript();
                    continue;
                }
                if (this.jsScripts[i].isStartScript()) {
                    strActiveStartScriptName = this.jsScripts[i].getScriptName();
                    strActiveStartScript = this.jsScripts[i].getScript();
                    continue;
                }
                if (!this.jsScripts[i].isEndScript()) continue;
                strActiveEndScriptName = this.jsScripts[i].getScriptName();
                strActiveEndScript = this.jsScripts[i].getScript();
            }
        }
        if (prev != null && strActiveScript.length() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.ConnectedTransformOK", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            for (i = 0; i < this.getNumberOfJSScripts(); ++i) {
                Scriptable jsR = Context.toObject((Object)this.jsScripts[i].getScript(), (Scriptable)jsscope);
                jsscope.put(this.jsScripts[i].getScriptName(), (Scriptable)jsscope, (Object)jsR);
            }
            try {
                if (this.getAddClasses() != null) {
                    for (i = 0; i < this.getAddClasses().length; ++i) {
                        Object jsOut = Context.javaToJS((Object)this.getAddClasses()[i].getAddObject(), (Scriptable)jsscope);
                        ScriptableObject.putProperty((Scriptable)jsscope, (String)this.getAddClasses()[i].getJSName(), (Object)jsOut);
                    }
                }
            }
            catch (Exception e) {
                errorMessage = "Couldn't add JavaClasses to Context! Error:";
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            try {
                Context.javaToJS(ScriptValuesAddedFunctions.class, (Scriptable)jsscope);
                jsscope.defineFunctionProperties(ScriptValuesAddedFunctions.jsFunctionList, ScriptValuesAddedFunctions.class, 2);
            }
            catch (Exception ex) {
                errorMessage = "Couldn't add Default Functions! Error:" + Const.CR + ex.toString();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            try {
                jsscope.put("SKIP_PIPELINE", (Scriptable)jsscope, (Object)1);
                jsscope.put("ABORT_PIPELINE", (Scriptable)jsscope, (Object)-1);
                jsscope.put("ERROR_PIPELINE", (Scriptable)jsscope, (Object)-2);
                jsscope.put("CONTINUE_PIPELINE", (Scriptable)jsscope, (Object)0);
            }
            catch (Exception ex) {
                errorMessage = "Couldn't add Pipeline Constants! Error:" + Const.CR + ex.toString();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            try {
                ScriptValuesDummy dummyTransform = new ScriptValuesDummy(prev, pipelineMeta.getTransformFields(variables, transformMeta));
                Scriptable jsvalue = Context.toObject((Object)dummyTransform, (Scriptable)jsscope);
                jsscope.put("_transform_", (Scriptable)jsscope, (Object)jsvalue);
                Object[] row = new Object[prev.size()];
                Scriptable jsRowMeta = Context.toObject((Object)prev, (Scriptable)jsscope);
                jsscope.put("rowMeta", (Scriptable)jsscope, (Object)jsRowMeta);
                for (int i2 = 0; i2 < prev.size(); ++i2) {
                    IValueMeta valueMeta = prev.getValueMeta(i2);
                    Object valueData = null;
                    if (valueMeta.isDate()) {
                        valueData = new Date();
                    }
                    if (valueMeta.isString()) {
                        valueData = "test value test value test value test value test value test value test value test value test value test value";
                    }
                    if (valueMeta.isInteger()) {
                        valueData = 0L;
                    }
                    if (valueMeta.isNumber()) {
                        valueData = 0.0;
                    }
                    if (valueMeta.isBigNumber()) {
                        valueData = BigDecimal.ZERO;
                    }
                    if (valueMeta.isBoolean()) {
                        valueData = Boolean.TRUE;
                    }
                    if (valueMeta.isBinary()) {
                        valueData = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
                    }
                    row[i2] = valueData;
                    Scriptable jsarg = Context.toObject((Object)valueData, (Scriptable)jsscope);
                    jsscope.put(valueMeta.getName(), (Scriptable)jsscope, (Object)jsarg);
                }
                Scriptable jsRow = Context.toObject((Object)row, (Scriptable)jsscope);
                jsscope.put("row", (Scriptable)jsscope, (Object)jsRow);
            }
            catch (Exception ev) {
                errorMessage = "Couldn't add Input fields to Script! Error:" + Const.CR + ev.toString();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            try {
                if (strActiveStartScript != null && strActiveStartScript.length() > 0) {
                    jscx.evaluateString((Scriptable)jsscope, strActiveStartScript, "pipeline_Start", 1, null);
                    errorMessage = "Found Start Script. " + strActiveStartScriptName + " Processing OK";
                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
            catch (Exception e) {
                errorMessage = "Couldn't process Start Script! Error:" + Const.CR + e.toString();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            try {
                Script jsscript = jscx.compileString(strActiveScript, "script", 1, null);
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.ScriptCompiledOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                try {
                    jsscript.exec(jscx, (Scriptable)jsscope);
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.ScriptCompiledOK2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    if (this.fieldname.length > 0) {
                        StringBuilder message = new StringBuilder(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.FailedToGetValues", (String[])new String[]{String.valueOf(this.fieldname.length)}) + Const.CR + Const.CR);
                        cr = errorFound ? new CheckResult(4, message.toString(), (ICheckResultSource)transformMeta) : new CheckResult(1, message.toString(), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                catch (JavaScriptException jse) {
                    Context.exit();
                    errorMessage = BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.CouldNotExecuteScript", (String[])new String[0]) + Const.CR + jse.toString();
                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                catch (Exception e) {
                    Context.exit();
                    errorMessage = BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.CouldNotExecuteScript2", (String[])new String[0]) + Const.CR + e.toString();
                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
                try {
                    if (strActiveEndScript != null && strActiveEndScript.length() > 0) {
                        jscx.evaluateString((Scriptable)jsscope, strActiveEndScript, "pipeline_End", 1, null);
                        errorMessage = "Found End Script. " + strActiveEndScriptName + " Processing OK";
                        cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                catch (Exception e) {
                    errorMessage = "Couldn't process End Script! Error:" + Const.CR + e.toString();
                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
            catch (Exception e) {
                Context.exit();
                errorMessage = BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.CouldNotCompileScript", (String[])new String[0]) + Const.CR + e.toString();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            Context.exit();
            errorMessage = BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.CouldNotGetFieldsFromPreviousTransform", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.ConnectedTransformOK2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getFunctionFromScript(String strFunction, String strScript) {
        String sRC = "";
        int iStartPos = strScript.indexOf(strFunction);
        if (iStartPos > 0) {
            iStartPos = strScript.indexOf(123, iStartPos);
            int iCounter = 1;
            while (iCounter != 0) {
                if (strScript.charAt(iStartPos++) == '{') {
                    ++iCounter;
                } else if (strScript.charAt(iStartPos++) == '}') {
                    --iCounter;
                }
                sRC = sRC + strScript.charAt(iStartPos);
            }
        }
        return sRC;
    }

    public ScriptValuesData getTransformData() {
        return new ScriptValuesData();
    }

    public void parseXmlForAdditionalClasses() throws HopException {
        try {
            Properties sysprops = System.getProperties();
            String strActPath = sysprops.getProperty("user.dir");
            Document dom = XmlHandler.loadXmlFile((String)(strActPath + "/plugins/transforms/ScriptValues_mod/plugin.xml"));
            Element transformNode = dom.getDocumentElement();
            Node libraries = XmlHandler.getSubNode((Node)transformNode, (String)"js_libraries");
            int nbOfLibs = XmlHandler.countNodes((Node)libraries, (String)"js_lib");
            this.additionalClasses = new ScriptValuesAddClasses[nbOfLibs];
            for (int i = 0; i < nbOfLibs; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)libraries, (String)"js_lib", (int)i);
                String strJarName = XmlHandler.getTagAttribute((Node)fnode, (String)"name");
                String strClassName = XmlHandler.getTagAttribute((Node)fnode, (String)"classname");
                String strJSName = XmlHandler.getTagAttribute((Node)fnode, (String)"js_name");
                Class<?> addClass = ScriptValuesMeta.LoadAdditionalClass(strActPath + "/plugins/transforms/ScriptValues_mod/" + strJarName, strClassName);
                Object addObject = addClass.newInstance();
                this.additionalClasses[i] = new ScriptValuesAddClasses(addClass, addObject, strJSName);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.UnableToParseXMLforAdditionalClasses", (String[])new String[0]), (Throwable)e);
        }
    }

    private static Class<?> LoadAdditionalClass(String strJar, String strClassName) throws HopException {
        try {
            Thread t = Thread.currentThread();
            ClassLoader cl = t.getContextClassLoader();
            URL u = new URL("jar:file:" + strJar + "!/");
            HopURLClassLoader kl = new HopURLClassLoader(new URL[]{u}, cl);
            Class toRun = kl.loadClass(strClassName);
            return toRun;
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ScriptValuesMetaMod.Exception.UnableToLoadAdditionalClass", (String[])new String[0]), (Throwable)e);
        }
    }

    public ScriptValuesAddClasses[] getAddClasses() {
        return this.additionalClasses;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean[] getReplace() {
        return this.replace;
    }

    public void setReplace(boolean[] replace) {
        this.replace = replace;
    }

    public void setOptimizationLevel(String optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public String getOptimizationLevel() {
        return this.optimizationLevel;
    }
}

