/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.splunk;

import org.apache.hop.core.Const;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.splunk.SplunkConnection;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class SplunkConnectionEditor
extends MetadataEditor<SplunkConnection> {
    private static Class<?> PKG = SplunkConnectionEditor.class;
    private Text wName;
    private TextVar wHostname;
    private TextVar wPort;
    private TextVar wUsername;
    private TextVar wPassword;

    public SplunkConnectionEditor(HopGui hopGui, MetadataManager<SplunkConnection> manager, SplunkConnection connection) {
        super(hopGui, manager, (IHopMetadata)connection);
    }

    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = 6;
        Label wlName = new Label(parent, 131072);
        props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"SplunkConnectionDialog.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlHostname = new Label(parent, 131072);
        props.setLook((Control)wlHostname);
        wlHostname.setText(BaseMessages.getString(PKG, (String)"SplunkConnectionDialog.Hostname.Label", (String[])new String[0]));
        FormData fdlHostname = new FormData();
        fdlHostname.top = new FormAttachment((Control)lastControl, margin);
        fdlHostname.left = new FormAttachment(0, 0);
        fdlHostname.right = new FormAttachment(middle, -margin);
        wlHostname.setLayoutData((Object)fdlHostname);
        this.wHostname = new TextVar(this.manager.getVariables(), parent, 18436);
        props.setLook((Control)this.wHostname);
        FormData fdHostname = new FormData();
        fdHostname.top = new FormAttachment((Control)wlHostname, 0, 0x1000000);
        fdHostname.left = new FormAttachment(middle, 0);
        fdHostname.right = new FormAttachment(95, 0);
        this.wHostname.setLayoutData((Object)fdHostname);
        lastControl = this.wHostname;
        Label wlPort = new Label(parent, 131072);
        props.setLook((Control)wlPort);
        wlPort.setText(BaseMessages.getString(PKG, (String)"SplunkConnectionDialog.Port.Label", (String[])new String[0]));
        FormData fdlPort = new FormData();
        fdlPort.top = new FormAttachment((Control)lastControl, margin);
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.right = new FormAttachment(middle, -margin);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar(this.manager.getVariables(), parent, 18436);
        props.setLook((Control)this.wPort);
        FormData fdPort = new FormData();
        fdPort.top = new FormAttachment((Control)wlPort, 0, 0x1000000);
        fdPort.left = new FormAttachment(middle, 0);
        fdPort.right = new FormAttachment(95, 0);
        this.wPort.setLayoutData((Object)fdPort);
        lastControl = this.wPort;
        Label wlUsername = new Label(parent, 131072);
        wlUsername.setText(BaseMessages.getString(PKG, (String)"SplunkConnectionDialog.UserName.Label", (String[])new String[0]));
        props.setLook((Control)wlUsername);
        FormData fdlUsername = new FormData();
        fdlUsername.top = new FormAttachment((Control)lastControl, margin);
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(middle, -margin);
        wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new TextVar(this.manager.getVariables(), parent, 18436);
        props.setLook((Control)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.top = new FormAttachment((Control)wlUsername, 0, 0x1000000);
        fdUsername.left = new FormAttachment(middle, 0);
        fdUsername.right = new FormAttachment(95, 0);
        this.wUsername.setLayoutData((Object)fdUsername);
        lastControl = this.wUsername;
        Label wlPassword = new Label(parent, 131072);
        wlPassword.setText(BaseMessages.getString(PKG, (String)"SplunkConnectionDialog.Password.Label", (String[])new String[0]));
        props.setLook((Control)wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.top = new FormAttachment((Control)lastControl, margin);
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(middle, -margin);
        wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new PasswordTextVar(this.manager.getVariables(), parent, 18436);
        props.setLook((Control)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.top = new FormAttachment((Control)wlPassword, 0, 0x1000000);
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.right = new FormAttachment(95, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        this.setWidgetsContent();
        this.wName.addModifyListener(e -> this.setChanged());
        this.wUsername.addModifyListener(e -> this.setChanged());
        this.wPassword.addModifyListener(e -> this.setChanged());
        this.wHostname.addModifyListener(e -> this.setChanged());
        this.wPort.addModifyListener(e -> this.setChanged());
    }

    public Button[] createButtonsForButtonBar(Composite parent) {
        Button wTest = new Button(parent, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        wTest.addListener(13, e -> this.test());
        return new Button[]{wTest};
    }

    public void setWidgetsContent() {
        SplunkConnection splunk = (SplunkConnection)this.getMetadata();
        this.wName.setText(Const.NVL((String)splunk.getName(), (String)""));
        this.wHostname.setText(Const.NVL((String)splunk.getHostname(), (String)""));
        this.wPort.setText(Const.NVL((String)splunk.getPort(), (String)""));
        this.wUsername.setText(Const.NVL((String)splunk.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)splunk.getPassword(), (String)""));
        this.wName.setFocus();
    }

    public void getWidgetsContent(SplunkConnection splunk) {
        splunk.setName(this.wName.getText());
        splunk.setHostname(this.wHostname.getText());
        splunk.setPort(this.wPort.getText());
        splunk.setUsername(this.wUsername.getText());
        splunk.setPassword(this.wPassword.getText());
    }

    public void test() {
        SplunkConnection splunk = new SplunkConnection();
        IVariables variables = this.manager.getVariables();
        try {
            this.getWidgetsContent(splunk);
            splunk.test(variables);
            MessageBox box = new MessageBox(this.hopGui.getShell(), 32);
            box.setText("OK");
            String message = "Connection successful!" + Const.CR;
            message = message + Const.CR;
            message = message + "Hostname : " + splunk.getRealHostname(variables) + ", port : " + splunk.getRealPort(variables) + ", user : " + splunk.getRealUsername(variables);
            box.setMessage(message);
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), "Error", "Error connecting to Splunk with Hostname '" + splunk.getRealHostname(variables) + "', port " + splunk.getRealPort(variables) + ", and username '" + splunk.getRealUsername(variables), e);
        }
    }
}

