/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.splunkinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.splunkinput.ReturnValue;
import org.apache.hop.pipeline.transforms.splunkinput.SplunkInput;
import org.apache.hop.pipeline.transforms.splunkinput.SplunkInputData;
import org.w3c.dom.Node;

@Transform(id="SplunkInput", name="Splunk Input", description="Read data from Splunk", image="splunk.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/splunkinput.html")
@InjectionSupported(localizationPrefix="Splunk.Injection.", groups={"PARAMETERS", "RETURNS"})
public class SplunkInputMeta
extends BaseTransformMeta
implements ITransformMeta<SplunkInput, SplunkInputData> {
    public static final String CONNECTION = "connection";
    public static final String QUERY = "query";
    public static final String RETURNS = "returns";
    public static final String RETURN = "return";
    public static final String RETURN_NAME = "return_name";
    public static final String RETURN_SPLUNK_NAME = "return_splunk_name";
    public static final String RETURN_TYPE = "return_type";
    public static final String RETURN_LENGTH = "return_length";
    public static final String RETURN_FORMAT = "return_format";
    @Injection(name="connection")
    private String connectionName;
    @Injection(name="query")
    private String query;
    @InjectionDeep
    private List<ReturnValue> returnValues = new ArrayList<ReturnValue>();

    public void setDefault() {
        this.query = "search * | head 100";
    }

    public ITransform createTransform(TransformMeta transformMeta, SplunkInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new SplunkInput(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public SplunkInputData getTransformData() {
        return new SplunkInputData();
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (ReturnValue returnValue : this.returnValues) {
            try {
                int type = ValueMetaFactory.getIdForValueMeta((String)returnValue.getType());
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)returnValue.getName(), (int)type);
                valueMeta.setLength(returnValue.getLength());
                valueMeta.setOrigin(name);
                rowMeta.addValueMeta(valueMeta);
            }
            catch (HopPluginException e) {
                throw new HopTransformException("Unknown data type '" + returnValue.getType() + "' for value named '" + returnValue.getName() + "'");
            }
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.addTagValue((String)CONNECTION, (String)this.connectionName));
        xml.append(XmlHandler.addTagValue((String)QUERY, (String)this.query));
        xml.append(XmlHandler.openTag((String)RETURNS));
        for (ReturnValue returnValue : this.returnValues) {
            xml.append(XmlHandler.openTag((String)RETURN));
            xml.append(XmlHandler.addTagValue((String)RETURN_NAME, (String)returnValue.getName()));
            xml.append(XmlHandler.addTagValue((String)RETURN_SPLUNK_NAME, (String)returnValue.getSplunkName()));
            xml.append(XmlHandler.addTagValue((String)RETURN_TYPE, (String)returnValue.getType()));
            xml.append(XmlHandler.addTagValue((String)RETURN_LENGTH, (int)returnValue.getLength()));
            xml.append(XmlHandler.addTagValue((String)RETURN_FORMAT, (String)returnValue.getFormat()));
            xml.append(XmlHandler.closeTag((String)RETURN));
        }
        xml.append(XmlHandler.closeTag((String)RETURNS));
        return xml.toString();
    }

    public void loadXml(Node stepnode, IHopMetadataProvider provider) throws HopXmlException {
        this.connectionName = XmlHandler.getTagValue((Node)stepnode, (String)CONNECTION);
        this.query = XmlHandler.getTagValue((Node)stepnode, (String)QUERY);
        Node returnsNode = XmlHandler.getSubNode((Node)stepnode, (String)RETURNS);
        List returnNodes = XmlHandler.getNodes((Node)returnsNode, (String)RETURN);
        this.returnValues = new ArrayList<ReturnValue>();
        for (Node returnNode : returnNodes) {
            String name = XmlHandler.getTagValue((Node)returnNode, (String)RETURN_NAME);
            String splunkName = XmlHandler.getTagValue((Node)returnNode, (String)RETURN_SPLUNK_NAME);
            String type = XmlHandler.getTagValue((Node)returnNode, (String)RETURN_TYPE);
            int length = Const.toInt((String)XmlHandler.getTagValue((Node)returnNode, (String)RETURN_LENGTH), (int)-1);
            String format = XmlHandler.getTagValue((Node)returnNode, (String)RETURN_FORMAT);
            this.returnValues.add(new ReturnValue(name, splunkName, type, length, format));
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<ReturnValue> getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(List<ReturnValue> returnValues) {
        this.returnValues = returnValues;
    }
}

