/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.checkdbconnection;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="CHECK_DB_CONNECTIONS", name="i18n::ActionCheckDbConnections.Name", description="i18n::ActionCheckDbConnections.Description", image="CheckDbConnection.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", documentationUrl="/workflow/actions/checkdbconnection.html")
public class ActionCheckDbConnections
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCheckDbConnections.class;
    private DatabaseMeta[] connections = null;
    protected static final String[] unitTimeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeMilliSecond.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeSecond.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeMinute.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.UnitTimeHour.Label", (String[])new String[0])};
    protected static final String[] unitTimeCode = new String[]{"millisecond", "second", "minute", "hour"};
    public static final int UNIT_TIME_MILLI_SECOND = 0;
    public static final int UNIT_TIME_SECOND = 1;
    public static final int UNIT_TIME_MINUTE = 2;
    public static final int UNIT_TIME_HOUR = 3;
    private String[] waitfors = null;
    private int[] waittimes = null;
    private long timeStart;
    private long now;

    public ActionCheckDbConnections(String name) {
        super(name, "");
    }

    public ActionCheckDbConnections() {
        this("");
    }

    public Object clone() {
        ActionCheckDbConnections je = (ActionCheckDbConnections)super.clone();
        return je;
    }

    public DatabaseMeta[] getConnections() {
        return this.connections;
    }

    public void setConnections(DatabaseMeta[] connections) {
        this.connections = connections;
    }

    public String[] getWaitfors() {
        return this.waitfors;
    }

    public void setWaitfors(String[] waitfors) {
        this.waitfors = waitfors;
    }

    public int[] getWaittimes() {
        return this.waittimes;
    }

    public void setWaittimes(int[] waittimes) {
        this.waittimes = waittimes;
    }

    public long getTimeStart() {
        return this.timeStart;
    }

    public long getNow() {
        return this.now;
    }

    private static String getWaitTimeCode(int i) {
        if (i < 0 || i >= unitTimeCode.length) {
            return unitTimeCode[0];
        }
        return unitTimeCode[i];
    }

    public static String getWaitTimeDesc(int i) {
        if (i < 0 || i >= unitTimeDesc.length) {
            return unitTimeDesc[0];
        }
        return unitTimeDesc[i];
    }

    public static int getWaitTimeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < unitTimeDesc.length; ++i) {
            if (!unitTimeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionCheckDbConnections.getWaitTimeByCode(tt);
    }

    private static int getWaitTimeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < unitTimeCode.length; ++i) {
            if (!unitTimeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(120);
        xml.append(super.getXml());
        xml.append("      <connections>").append(Const.CR);
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                xml.append("        <connection>").append(Const.CR);
                xml.append("          ").append(XmlHandler.addTagValue((String)"name", this.connections[i] == null ? null : this.connections[i].getName()));
                xml.append("          ").append(XmlHandler.addTagValue((String)"waitfor", (String)this.waitfors[i]));
                xml.append("          ").append(XmlHandler.addTagValue((String)"waittime", (String)ActionCheckDbConnections.getWaitTimeCode(this.waittimes[i])));
                xml.append("        </connection>").append(Const.CR);
            }
        }
        xml.append("      </connections>").append(Const.CR);
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"connections");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"connection");
            this.connections = new DatabaseMeta[nrFields];
            this.waitfors = new String[nrFields];
            this.waittimes = new int[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"connection", (int)i);
                String dbname = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.connections[i] = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)dbname);
                this.waitfors[i] = XmlHandler.getTagValue((Node)fnode, (String)"waitfor");
                this.waittimes[i] = ActionCheckDbConnections.getWaitTimeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"waittime"), (String)""));
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[]{xe.getMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(true);
        int nrerrors = 0;
        int nrsuccess = 0;
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length && !this.parentWorkflow.isStopped(); ++i) {
                Database db = new Database((ILoggingObject)this, (IVariables)this, this.connections[i]);
                try {
                    int iMaximumTimeout;
                    db.connect();
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Connected", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName()}));
                    }
                    if ((iMaximumTimeout = Const.toInt((String)this.resolve(this.waitfors[i]), (int)0)) > 0) {
                        int multiple = 1;
                        String waitTimeMessage = unitTimeDesc[0];
                        switch (this.waittimes[i]) {
                            case 0: {
                                multiple = 1;
                                waitTimeMessage = unitTimeDesc[0];
                                break;
                            }
                            case 1: {
                                multiple = 1000;
                                waitTimeMessage = unitTimeDesc[1];
                                break;
                            }
                            case 2: {
                                multiple = 60000;
                                waitTimeMessage = unitTimeDesc[2];
                                break;
                            }
                            case 3: {
                                multiple = 3600000;
                                waitTimeMessage = unitTimeDesc[3];
                                break;
                            }
                            default: {
                                multiple = 1000;
                                waitTimeMessage = unitTimeDesc[1];
                            }
                        }
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Wait", (String[])new String[]{"" + iMaximumTimeout, waitTimeMessage}));
                        }
                        this.timeStart = System.currentTimeMillis();
                        boolean continueLoop = true;
                        while (continueLoop && !this.parentWorkflow.isStopped()) {
                            this.now = System.currentTimeMillis();
                            if (this.now >= this.timeStart + (long)(iMaximumTimeout * multiple)) {
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.WaitTimeIsElapsed.Label", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName()}));
                                }
                                continueLoop = false;
                                continue;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    ++nrsuccess;
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.ConnectionOK", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName()}));
                    continue;
                }
                catch (HopDatabaseException e) {
                    ++nrerrors;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Exception", (String[])new String[]{this.connections[i].getDatabaseName(), this.connections[i].getName(), e.toString()}));
                    continue;
                }
                finally {
                    if (db != null) {
                        try {
                            db.disconnect();
                            db = null;
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (nrerrors > 0) {
            result.setNrErrors((long)nrerrors);
            result.setResult(false);
        }
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Log.Info.ConnectionsInError", (String[])new String[]{"" + nrerrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckDbConnections.Log.Info.ConnectionsInSuccess", (String[])new String[]{"" + nrsuccess}));
            this.logDetailed("=======================================");
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return this.connections;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (this.connections != null) {
            for (int i = 0; i < this.connections.length; ++i) {
                DatabaseMeta connection = this.connections[i];
                ResourceReference reference = new ResourceReference((IResourceHolder)this);
                reference.getEntries().add(new ResourceEntry(connection.getHostname(), ResourceEntry.ResourceType.SERVER));
                reference.getEntries().add(new ResourceEntry(connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
                references.add(reference);
            }
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "columnname", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

