/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ssh.SSH;
import org.apache.hop.pipeline.transforms.ssh.SSHData;
import org.w3c.dom.Node;

@Transform(id="SSH", image="ssh.svg", name="i18n::SSH.Name", description="i18n::SSH.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", documentationUrl="/pipeline/transforms/runssh.html")
public class SSHMeta
extends BaseTransformMeta
implements ITransformMeta<SSH, SSHData> {
    static Class<?> PKG = SSHMeta.class;
    private static int DEFAULT_PORT = 22;
    private String command;
    private boolean dynamicCommandField;
    private String commandfieldname;
    private String serverName;
    private String port;
    private String userName;
    private String password;
    private boolean usePrivateKey;
    private String keyFileName;
    private String passPhrase;
    private String stdOutFieldName;
    private String stdErrFieldName;
    private String timeOut;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        SSHMeta retval = (SSHMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.dynamicCommandField = false;
        this.command = null;
        this.commandfieldname = null;
        this.port = String.valueOf(DEFAULT_PORT);
        this.serverName = null;
        this.userName = null;
        this.password = null;
        this.usePrivateKey = true;
        this.keyFileName = null;
        this.stdOutFieldName = "stdOut";
        this.stdErrFieldName = "stdErr";
        this.timeOut = "0";
        this.proxyHost = null;
        this.proxyPort = null;
        this.proxyUsername = null;
        this.proxyPassword = null;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getuserName() {
        return this.userName;
    }

    public void setuserName(String userName) {
        this.userName = userName;
    }

    public void setpassword(String password) {
        this.password = password;
    }

    public String getpassword() {
        return this.password;
    }

    public void setcommandfieldname(String commandfieldname) {
        this.commandfieldname = commandfieldname;
    }

    public String getcommandfieldname() {
        return this.commandfieldname;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setDynamicCommand(boolean value) {
        this.dynamicCommandField = value;
    }

    public boolean isDynamicCommand() {
        return this.dynamicCommandField;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void usePrivateKey(boolean value) {
        this.usePrivateKey = value;
    }

    public boolean isusePrivateKey() {
        return this.usePrivateKey;
    }

    public void setKeyFileName(String value) {
        this.keyFileName = value;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setPassphrase(String value) {
        this.passPhrase = value;
    }

    public String getPassphrase() {
        return this.passPhrase;
    }

    public void setTimeOut(String timeOut) {
        this.timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.timeOut;
    }

    public void setstdOutFieldName(String value) {
        this.stdOutFieldName = value;
    }

    public String getStdOutFieldName() {
        return this.stdOutFieldName;
    }

    public void setStdErrFieldName(String value) {
        this.stdErrFieldName = value;
    }

    public String getStdErrFieldName() {
        return this.stdErrFieldName;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamicCommandField", (boolean)this.dynamicCommandField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"command", (String)this.command));
        retval.append("    ").append(XmlHandler.addTagValue((String)"commandfieldname", (String)this.commandfieldname));
        retval.append("    ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"userName", (String)this.userName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"usePrivateKey", (boolean)this.usePrivateKey));
        retval.append("    ").append(XmlHandler.addTagValue((String)"keyFileName", (String)this.keyFileName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"passPhrase", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.passPhrase)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"stdOutFieldName", (String)this.stdOutFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"stdErrFieldName", (String)this.stdErrFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"timeOut", (String)this.timeOut));
        retval.append("    ").append(XmlHandler.addTagValue((String)"proxyHost", (String)this.proxyHost));
        retval.append("    ").append(XmlHandler.addTagValue((String)"proxyPort", (String)this.proxyPort));
        retval.append("    ").append(XmlHandler.addTagValue((String)"proxyUsername", (String)this.proxyUsername));
        retval.append("    ").append(XmlHandler.addTagValue((String)"proxyPassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.dynamicCommandField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicCommandField"));
            this.command = XmlHandler.getTagValue((Node)transformNode, (String)"command");
            this.commandfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"commandfieldname");
            this.port = XmlHandler.getTagValue((Node)transformNode, (String)"port");
            this.serverName = XmlHandler.getTagValue((Node)transformNode, (String)"servername");
            this.userName = XmlHandler.getTagValue((Node)transformNode, (String)"userName");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"password"));
            this.usePrivateKey = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usePrivateKey"));
            this.keyFileName = XmlHandler.getTagValue((Node)transformNode, (String)"keyFileName");
            this.passPhrase = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"passPhrase"));
            this.stdOutFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"stdOutFieldName");
            this.stdErrFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"stdErrFieldName");
            this.timeOut = XmlHandler.getTagValue((Node)transformNode, (String)"timeOut");
            this.proxyHost = XmlHandler.getTagValue((Node)transformNode, (String)"proxyHost");
            this.proxyPort = XmlHandler.getTagValue((Node)transformNode, (String)"proxyPort");
            this.proxyUsername = XmlHandler.getTagValue((Node)transformNode, (String)"proxyUsername");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"proxyPassword"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SSHMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.getServerName())) {
            errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.TargetHostMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.TargetHostOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isusePrivateKey()) {
            String keyfilename = variables.resolve(this.getKeyFileName());
            if (Utils.isEmpty((CharSequence)keyfilename)) {
                errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNameMissing", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNameOK", (String[])new String[0]);
                cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                boolean keyFileExists = false;
                try {
                    keyFileExists = HopVfs.fileExists((String)keyfilename);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!keyFileExists) {
                    errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileNotExist", (String[])new String[]{keyfilename});
                    cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    errorMessage = BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.PrivateKeyFileExists", (String[])new String[]{keyfilename});
                    cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SSHMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (!this.isDynamicCommand()) {
            row.clear();
        }
        ValueMetaString v = new ValueMetaString(variables.resolve(this.getStdOutFieldName()));
        v.setOrigin(name);
        row.addValueMeta((IValueMeta)v);
        String stderrfield = variables.resolve(this.getStdErrFieldName());
        if (!Utils.isEmpty((CharSequence)stderrfield)) {
            v = new ValueMetaBoolean(stderrfield);
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, SSHData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new SSH(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public SSHData getTransformData() {
        return new SSHData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public ITransformIOMeta getTransformIOMeta() {
        return new TransformIOMeta(this.isDynamicCommand(), true, false, false, false, false);
    }
}

