/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import com.google.common.annotations.VisibleForTesting;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.ProxyData;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transform.BaseTransformData;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transforms.ssh.SSHMeta;

public class SSHData
extends BaseTransformData
implements ITransformData {
    public int indexOfCommand = -1;
    public Connection conn = null;
    public boolean wroteOneRow = false;
    public String commands = null;
    public int nrInputFields;
    public int nrOutputFields;
    public String stdOutField = null;
    public String stdTypeField = null;
    public IRowMeta outputRowMeta;

    public static Connection OpenConnection(String serveur, int port, String username, String password, boolean useKey, String keyFilename, String passPhrase, int timeOut, IVariables variables, String proxyhost, int proxyport, String proxyusername, String proxypassword) throws HopException {
        Connection conn = null;
        char[] content = null;
        boolean isAuthenticated = false;
        try {
            if (useKey) {
                if (Utils.isEmpty((CharSequence)keyFilename)) {
                    throw new HopException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.PrivateKeyFileMissing", (String[])new String[0]));
                }
                FileObject keyFileObject = HopVfs.getFileObject((String)keyFilename);
                if (!keyFileObject.exists()) {
                    throw new HopException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.PrivateKeyNotExist", (String[])new String[]{keyFilename}));
                }
                FileContent keyFileContent = keyFileObject.getContent();
                CharArrayWriter charArrayWriter = new CharArrayWriter((int)keyFileContent.getSize());
                try (InputStream in = keyFileContent.getInputStream();){
                    IOUtils.copy((InputStream)in, (Writer)charArrayWriter);
                }
                content = charArrayWriter.toCharArray();
            }
            conn = SSHData.createConnection(serveur, port);
            if (!Utils.isEmpty((CharSequence)proxyhost)) {
                if (!Utils.isEmpty((CharSequence)proxyusername)) {
                    conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport, proxyusername, proxypassword));
                } else {
                    conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport));
                }
            }
            if (timeOut == 0) {
                conn.connect();
            } else {
                conn.connect(null, 0, timeOut * 1000);
            }
            isAuthenticated = useKey ? conn.authenticateWithPublicKey(username, content, variables.resolve(passPhrase)) : conn.authenticateWithPassword(username, password);
            if (!isAuthenticated) {
                throw new HopException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.AuthenticationFailed", (String[])new String[]{username}));
            }
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw new HopException(BaseMessages.getString(SSHMeta.PKG, (String)"SSH.Error.ErrorConnecting", (String[])new String[]{serveur, username}), (Throwable)e);
        }
        return conn;
    }

    @VisibleForTesting
    static Connection createConnection(String serveur, int port) {
        return new Connection(serveur, port);
    }
}

